/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharShortHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharShortScatterMap
extends CharShortHashMap {
    public CharShortScatterMap() {
        this(4);
    }

    public CharShortScatterMap(int n) {
        this(n, 0.75);
    }

    public CharShortScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static CharShortScatterMap from(char[] cArray, short[] sArray) {
        if (cArray.length == sArray.length) {
            CharShortScatterMap charShortScatterMap = new CharShortScatterMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charShortScatterMap.put(cArray[i], sArray[i]);
            }
            return charShortScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(char c) {
        return BitMixer.mixPhi(c);
    }
}

