/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Containers {
    public static final int DEFAULT_EXPECTED_ELEMENTS = 4;
    private static final String NOT_AVAILABLE = new String();
    private static String testsSeedProperty;

    private Containers() {
    }

    public static long randomSeed64() {
        PrivilegedAction<String> privilegedAction;
        if (testsSeedProperty == null) {
            try {
                privilegedAction = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("tests.seed", NOT_AVAILABLE);
                    }
                };
                testsSeedProperty = (String)AccessController.doPrivileged(privilegedAction);
            }
            catch (SecurityException securityException) {
                testsSeedProperty = NOT_AVAILABLE;
                Logger.getLogger(Containers.class.getName()).log(Level.INFO, "Failed to read 'tests.seed' property for initial random seed.", securityException);
            }
        }
        long l = (privilegedAction = testsSeedProperty) != NOT_AVAILABLE ? (long)((String)((Object)privilegedAction)).hashCode() : System.nanoTime() ^ (long)System.identityHashCode(new Object());
        return BitMixer.mix64(l);
    }

    static void test$reset() {
        testsSeedProperty = null;
    }
}

