/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.DoubleArrayList;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.DoubleDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class DoubleArrayDeque
extends AbstractDoubleCollection
implements DoubleDeque,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public double[] buffer = DoubleArrayList.EMPTY_ARRAY;
    public int head;
    protected final ArraySizingStrategy resizer;
    public int tail;

    public DoubleArrayDeque() {
        this(4);
    }

    public DoubleArrayDeque(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public DoubleArrayDeque(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public DoubleArrayDeque(DoubleContainer doubleContainer) {
        this(doubleContainer.size());
        this.addLast(doubleContainer);
    }

    private void descendingForEach(DoublePredicate doublePredicate, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        double[] dArray = this.buffer;
        while (doublePredicate.apply(dArray[n3 = DoubleArrayDeque.oneLeft(n2, dArray.length)])) {
            n2 = n3;
            if (n3 != n) continue;
        }
    }

    private void descendingForEach(DoubleProcedure doubleProcedure, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        double[] dArray = this.buffer;
        do {
            n3 = DoubleArrayDeque.oneLeft(n2, dArray.length);
            doubleProcedure.apply(dArray[n3]);
            n2 = n3;
        } while (n3 != n);
    }

    private void forEach(DoubleProcedure doubleProcedure, int n, int n2) {
        double[] dArray = this.buffer;
        while (n != n2) {
            doubleProcedure.apply(dArray[n]);
            n = DoubleArrayDeque.oneRight(n, dArray.length);
        }
    }

    public static DoubleArrayDeque from(double ... dArray) {
        DoubleArrayDeque doubleArrayDeque = new DoubleArrayDeque(dArray.length);
        doubleArrayDeque.addLast(dArray);
        return doubleArrayDeque;
    }

    protected static int oneLeft(int n, int n2) {
        if (n >= 1) {
            return n - 1;
        }
        return n2 - 1;
    }

    protected static int oneRight(int n, int n2) {
        int n3;
        n = n3 = n + 1;
        if (n3 == n2) {
            n = 0;
        }
        return n;
    }

    public int addFirst(DoubleContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addFirst(((DoubleCursor)object.next()).value);
        }
        return n;
    }

    public int addFirst(Iterable<? extends DoubleCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addFirst(((DoubleCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addFirst(double d) {
        int n;
        int n2 = n = DoubleArrayDeque.oneLeft(this.head, this.buffer.length);
        if (n == this.tail) {
            this.ensureBufferSpace(1);
            n2 = DoubleArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        double[] dArray = this.buffer;
        this.head = n2;
        dArray[n2] = d;
    }

    public final void addFirst(double ... dArray) {
        this.ensureBufferSpace(dArray.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.addFirst(dArray[i]);
        }
    }

    public int addLast(DoubleContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addLast(((DoubleCursor)object.next()).value);
        }
        return n;
    }

    public int addLast(Iterable<? extends DoubleCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addLast(((DoubleCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addLast(double d) {
        int n;
        int n2 = n = DoubleArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == n) {
            this.ensureBufferSpace(1);
            n2 = DoubleArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = d;
        this.tail = n2;
    }

    public final void addLast(double ... dArray) {
        this.ensureBufferSpace(1);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.addLast(dArray[i]);
        }
    }

    public int bufferIndexOf(double d) {
        int n = this.tail;
        int n2 = this.buffer.length;
        int n3 = this.head;
        while (n3 != n) {
            if (Double.doubleToLongBits(this.buffer[n3]) == Double.doubleToLongBits(d)) {
                return n3;
            }
            n3 = DoubleArrayDeque.oneRight(n3, n2);
        }
        return -1;
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            Arrays.fill(this.buffer, n, n2, 0.0);
        } else {
            Arrays.fill(this.buffer, 0, n2, 0.0);
            double[] dArray = this.buffer;
            Arrays.fill(dArray, this.head, dArray.length, 0.0);
        }
        this.tail = 0;
        this.head = 0;
    }

    public DoubleArrayDeque clone() {
        try {
            DoubleArrayDeque doubleArrayDeque = (DoubleArrayDeque)super.clone();
            doubleArrayDeque.buffer = (double[])this.buffer.clone();
            return doubleArrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(double d) {
        int n = this.head;
        int n2 = this.tail;
        double[] dArray = this.buffer;
        while (n != n2) {
            if (Double.doubleToLongBits(dArray[n]) == Double.doubleToLongBits(d)) {
                return true;
            }
            n = DoubleArrayDeque.oneRight(n, dArray.length);
        }
        return false;
    }

    @Override
    public <T extends DoublePredicate> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public <T extends DoubleProcedure> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public Iterator<DoubleCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureBufferSpace(int n) {
        int n2 = this.buffer.length;
        int n3 = this.size();
        if (n3 + n < n2) return;
        n = this.resizer.grow(n2, n3 + 1, n);
        try {
            double[] dArray = new double[n];
            if (n2 > 0) {
                this.toArray(dArray);
                this.tail = n3;
                this.head = 0;
            }
            this.buffer = dArray;
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensureBufferSpace(n - this.size());
    }

    protected boolean equalElements(DoubleArrayDeque object) {
        int n = this.size();
        int n2 = ((DoubleArrayDeque)object).size();
        boolean bl = false;
        if (n2 != n) {
            return false;
        }
        Iterator<DoubleCursor> iterator = this.iterator();
        object = ((DoubleArrayDeque)object).iterator();
        while (iterator.hasNext() && object.hasNext()) {
            if (Double.doubleToLongBits(((DoubleCursor)object.next()).value) == Double.doubleToLongBits(iterator.next().value)) continue;
            return false;
        }
        boolean bl2 = bl;
        if (!iterator.hasNext()) {
            bl2 = bl;
            if (!object.hasNext()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((DoubleArrayDeque)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends DoublePredicate> T forEach(T t) {
        int n = this.head;
        int n2 = this.tail;
        double[] dArray = this.buffer;
        while (n != n2 && t.apply(dArray[n])) {
            n = DoubleArrayDeque.oneRight(n, dArray.length);
        }
        return t;
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T t) {
        this.forEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public double getFirst() {
        return this.buffer[this.head];
    }

    @Override
    public double getLast() {
        double[] dArray = this.buffer;
        return dArray[DoubleArrayDeque.oneLeft(this.tail, dArray.length)];
    }

    public int hashCode() {
        int n = this.head;
        int n2 = this.tail;
        double[] dArray = this.buffer;
        int n3 = 1;
        while (n != n2) {
            n3 = n3 * 31 + BitMixer.mix(this.buffer[n]);
            n = DoubleArrayDeque.oneRight(n, dArray.length);
        }
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<DoubleCursor> iterator() {
        return new ValueIterator();
    }

    public int lastBufferIndexOf(double d) {
        int n;
        int n2 = this.buffer.length;
        int n3 = DoubleArrayDeque.oneLeft(this.head, n2);
        int n4 = this.tail;
        while ((n = DoubleArrayDeque.oneLeft(n4, n2)) != n3) {
            n4 = n;
            if (Double.doubleToLongBits(this.buffer[n]) != Double.doubleToLongBits(d)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = DoubleArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public int removeAll(double d) {
        int n;
        int n2 = this.tail;
        int n3 = this.buffer.length;
        int n4 = n = this.head;
        int n5 = 0;
        while (n != n2) {
            if (Double.doubleToLongBits(this.buffer[n]) == Double.doubleToLongBits(d)) {
                this.buffer[n] = 0.0;
                ++n5;
            } else {
                if (n4 != n) {
                    double[] dArray = this.buffer;
                    dArray[n4] = dArray[n];
                    dArray[n] = 0.0;
                }
                n4 = DoubleArrayDeque.oneRight(n4, n3);
            }
            n = DoubleArrayDeque.oneRight(n, n3);
        }
        this.tail = n4;
        return n5;
    }

    /*
     * Loose catch block
     */
    @Override
    public int removeAll(DoublePredicate doublePredicate) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        double[] dArray;
        block10: {
            int n6;
            dArray = this.buffer;
            n5 = this.tail;
            n4 = dArray.length;
            int n7 = n6 = this.head;
            n3 = 0;
            while (true) {
                n2 = n6;
                n = n7;
                if (n6 == n5) break block10;
                n2 = n7;
                if (doublePredicate.apply(dArray[n6])) {
                    dArray[n6] = 0.0;
                    ++n3;
                    break block11;
                }
                if (n7 == n6) break block12;
                break;
            }
            catch (Throwable throwable) {
                while (n6 != n5) {
                    if (n2 != n6) {
                        dArray[n2] = dArray[n6];
                        dArray[n6] = 0.0;
                    }
                    n2 = DoubleArrayDeque.oneRight(n2, n4);
                    n6 = DoubleArrayDeque.oneRight(n6, n4);
                }
                this.tail = n2;
                throw throwable;
            }
            {
                block11: {
                    block12: {
                        dArray[n7] = dArray[n6];
                        dArray[n6] = 0.0;
                    }
                    n2 = n7;
                    n7 = DoubleArrayDeque.oneRight(n7, n4);
                }
                n2 = n7;
                n6 = n = DoubleArrayDeque.oneRight(n6, n4);
                continue;
            }
        }
        while (n2 != n5) {
            if (n != n2) {
                dArray[n] = dArray[n2];
                dArray[n2] = 0.0;
            }
            n = DoubleArrayDeque.oneRight(n, n4);
            n2 = DoubleArrayDeque.oneRight(n2, n4);
        }
        this.tail = n;
        return n3;
    }

    public void removeAtBufferIndex(int n) {
        int n2;
        double[] dArray = this.buffer;
        int n3 = dArray.length;
        int n4 = n3 - 1;
        int n5 = this.head;
        int n6 = this.tail;
        int n7 = Math.abs(n - n5) % n3;
        if (n7 < (n2 = Math.abs(n6 - n) % n3)) {
            if (n >= n5) {
                System.arraycopy(dArray, n5, dArray, n5 + 1, n7);
            } else {
                System.arraycopy(dArray, 0, dArray, 1, n);
                dArray[0] = dArray[n4];
                System.arraycopy(dArray, n5, dArray, n5 + 1, n4 - n5);
            }
            dArray[n5] = 0.0;
            this.head = DoubleArrayDeque.oneRight(n5, n3);
        } else {
            if (n < n6) {
                System.arraycopy(dArray, n + 1, dArray, n, n2);
            } else {
                System.arraycopy(dArray, n + 1, dArray, n, n4 - n);
                dArray[n4] = dArray[0];
                System.arraycopy(dArray, 1, dArray, 0, n6);
            }
            dArray[n6] = 0.0;
            this.tail = DoubleArrayDeque.oneLeft(n6, n3);
        }
    }

    @Override
    public double removeFirst() {
        double[] dArray = this.buffer;
        int n = this.head;
        double d = dArray[n];
        dArray[n] = 0.0;
        this.head = DoubleArrayDeque.oneRight(n, dArray.length);
        return d;
    }

    @Override
    public int removeFirst(double d) {
        int n = this.bufferIndexOf(d);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public double removeLast() {
        int n;
        this.tail = n = DoubleArrayDeque.oneLeft(this.tail, this.buffer.length);
        double[] dArray = this.buffer;
        double d = dArray[n];
        dArray[n] = 0.0;
        return d;
    }

    @Override
    public int removeLast(double d) {
        int n = this.lastBufferIndexOf(d);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public int size() {
        int n = this.head;
        int n2 = this.tail;
        if (n <= n2) {
            return n2 - n;
        }
        return n2 - n + this.buffer.length;
    }

    @Override
    public double[] toArray() {
        return this.toArray(new double[this.size()]);
    }

    public double[] toArray(double[] dArray) {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            System.arraycopy(this.buffer, n, dArray, 0, this.size());
        } else if (n > n2) {
            double[] dArray2 = this.buffer;
            n2 = dArray2.length - n;
            System.arraycopy(dArray2, n, dArray, 0, n2);
            System.arraycopy(this.buffer, 0, dArray, n2, this.tail);
        }
        return dArray;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private int remaining;

        public DescendingValueIterator() {
            DoubleCursor doubleCursor;
            this.cursor = doubleCursor = new DoubleCursor();
            doubleCursor.index = DoubleArrayDeque.this.tail;
            this.remaining = DoubleArrayDeque.this.size();
        }

        @Override
        protected DoubleCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (DoubleCursor)this.done();
            }
            this.remaining = n - 1;
            DoubleCursor doubleCursor = this.cursor;
            double[] dArray = DoubleArrayDeque.this.buffer;
            DoubleCursor doubleCursor2 = this.cursor;
            doubleCursor2.index = n = DoubleArrayDeque.oneLeft(doubleCursor2.index, DoubleArrayDeque.this.buffer.length);
            doubleCursor.value = dArray[n];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private int remaining;

        public ValueIterator() {
            DoubleCursor doubleCursor;
            this.cursor = doubleCursor = new DoubleCursor();
            doubleCursor.index = DoubleArrayDeque.oneLeft(DoubleArrayDeque.this.head, DoubleArrayDeque.this.buffer.length);
            this.remaining = DoubleArrayDeque.this.size();
        }

        @Override
        protected DoubleCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (DoubleCursor)this.done();
            }
            this.remaining = n - 1;
            DoubleCursor doubleCursor = this.cursor;
            double[] dArray = DoubleArrayDeque.this.buffer;
            DoubleCursor doubleCursor2 = this.cursor;
            doubleCursor2.index = n = DoubleArrayDeque.oneRight(doubleCursor2.index, DoubleArrayDeque.this.buffer.length);
            doubleCursor.value = dArray[n];
            return this.cursor;
        }
    }
}

