/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.DoubleIndexedContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class DoubleArrayList
extends AbstractDoubleCollection
implements DoubleIndexedContainer,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final double[] EMPTY_ARRAY = new double[0];
    public double[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public DoubleArrayList() {
        this(4);
    }

    public DoubleArrayList(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public DoubleArrayList(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public DoubleArrayList(DoubleContainer doubleContainer) {
        this(doubleContainer.size());
        this.addAll(doubleContainer);
    }

    public static DoubleArrayList from(double ... dArray) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray.length);
        doubleArrayList.add(dArray);
        return doubleArrayList;
    }

    @Override
    public void add(double d) {
        this.ensureBufferSpace(1);
        double[] dArray = this.buffer;
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        dArray[n] = d;
    }

    public void add(double d, double d2) {
        int n;
        this.ensureBufferSpace(2);
        double[] dArray = this.buffer;
        int n2 = this.elementsCount;
        this.elementsCount = n = n2 + 1;
        dArray[n2] = d;
        this.elementsCount = n + 1;
        dArray[n] = d2;
    }

    public final void add(double ... dArray) {
        this.add(dArray, 0, dArray.length);
    }

    public void add(double[] dArray, int n, int n2) {
        this.ensureBufferSpace(n2);
        System.arraycopy(dArray, n, this.buffer, this.elementsCount, n2);
        this.elementsCount += n2;
    }

    public int addAll(DoubleContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.add(((DoubleCursor)object.next()).value);
        }
        return n;
    }

    public int addAll(Iterable<? extends DoubleCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.add(((DoubleCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0.0);
        this.elementsCount = 0;
    }

    public DoubleArrayList clone() {
        try {
            DoubleArrayList doubleArrayList = (DoubleArrayList)super.clone();
            doubleArrayList.buffer = (double[])this.buffer.clone();
            return doubleArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(double d) {
        boolean bl = this.indexOf(d) >= 0;
        return bl;
    }

    protected void ensureBufferSpace(int n) {
        int n2 = this.elementsCount;
        double[] dArray = this.buffer;
        int n3 = dArray == null ? 0 : dArray.length;
        if (n2 + n > n3) {
            n = this.resizer.grow(n3, n2, n);
            this.buffer = Arrays.copyOf(this.buffer, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        double[] dArray = this.buffer;
        int n2 = dArray == null ? 0 : dArray.length;
        if (n > n2) {
            this.ensureBufferSpace(n - this.size());
        }
    }

    protected boolean equalElements(DoubleArrayList doubleArrayList) {
        int n = this.size();
        if (doubleArrayList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Double.doubleToLongBits(doubleArrayList.get(i)) == Double.doubleToLongBits(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((DoubleArrayList)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends DoublePredicate> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends DoublePredicate> T forEach(T t, int n, int n2) {
        double[] dArray = this.buffer;
        while (n < n2 && t.apply(dArray[n])) {
            ++n;
        }
        return t;
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends DoubleProcedure> T forEach(T t, int n, int n2) {
        double[] dArray = this.buffer;
        while (n < n2) {
            t.apply(dArray[n]);
            ++n;
        }
        return t;
    }

    @Override
    public double get(int n) {
        return this.buffer[n];
    }

    public int hashCode() {
        int n = this.elementsCount;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + BitMixer.mix(this.buffer[i]);
        }
        return n2;
    }

    @Override
    public int indexOf(double d) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (Double.doubleToLongBits(this.buffer[i]) != Double.doubleToLongBits(d)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insert(int n, double d) {
        this.ensureBufferSpace(1);
        double[] dArray = this.buffer;
        System.arraycopy(dArray, n, dArray, n + 1, this.elementsCount - n);
        this.buffer[n] = d;
        ++this.elementsCount;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.elementsCount == 0;
        return bl;
    }

    @Override
    public Iterator<DoubleCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public int lastIndexOf(double d) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (Double.doubleToLongBits(this.buffer[i]) != Double.doubleToLongBits(d)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public double remove(int n) {
        double[] dArray = this.buffer;
        double d = dArray[n];
        int n2 = n + 1;
        int n3 = this.elementsCount;
        if (n2 < n3) {
            System.arraycopy(dArray, n2, dArray, n, n3 - n - 1);
        }
        this.elementsCount = n = this.elementsCount - 1;
        this.buffer[n] = 0.0;
        return d;
    }

    @Override
    public int removeAll(double d) {
        int n;
        int n2 = 0;
        for (int i = 0; i < (n = this.elementsCount); ++i) {
            if (Double.doubleToLongBits(this.buffer[i]) == Double.doubleToLongBits(d)) {
                this.buffer[i] = 0.0;
                continue;
            }
            if (n2 != i) {
                double[] dArray = this.buffer;
                dArray[n2] = dArray[i];
                dArray[i] = 0.0;
            }
            ++n2;
        }
        this.elementsCount = n2;
        return n - n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removeAll(DoublePredicate doublePredicate) {
        int n;
        int n2;
        double[] dArray = this.buffer;
        int n3 = this.elementsCount;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            n2 = ++n4;
            n = ++n5;
            if (n4 >= n3) break;
            try {
                if (doublePredicate.apply(dArray[n4])) {
                    dArray[n4] = 0.0;
                    continue;
                }
                if (n5 == n4) continue;
            }
            catch (Throwable throwable) {
                while (true) {
                    if (n4 >= n3) {
                        this.elementsCount = n5;
                        throw throwable;
                    }
                    if (n5 != n4) {
                        dArray[n5] = dArray[n4];
                        dArray[n4] = 0.0;
                    }
                    ++n5;
                    ++n4;
                }
            }
            dArray[n5] = dArray[n4];
            dArray[n4] = 0.0;
        }
        while (true) {
            if (n2 >= n3) {
                this.elementsCount = n;
                return n3 - n;
            }
            if (n != n2) {
                dArray[n] = dArray[n2];
                dArray[n2] = 0.0;
            }
            ++n;
            ++n2;
        }
    }

    @Override
    public int removeFirst(double d) {
        int n = this.indexOf(d);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public int removeLast(double d) {
        int n = this.lastIndexOf(d);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public void removeRange(int n, int n2) {
        double[] dArray = this.buffer;
        System.arraycopy(dArray, n2, dArray, n, this.elementsCount - n2);
        n = n2 - n;
        this.elementsCount = n2 = this.elementsCount - n;
        Arrays.fill(this.buffer, n2, n + n2, 0.0);
    }

    public void resize(int n) {
        double[] dArray = this.buffer;
        if (n <= dArray.length) {
            int n2 = this.elementsCount;
            if (n < n2) {
                Arrays.fill(dArray, n, n2, 0.0);
            } else {
                Arrays.fill(dArray, n2, n, 0.0);
            }
        } else {
            this.ensureCapacity(n);
        }
        this.elementsCount = n;
    }

    @Override
    public double set(int n, double d) {
        double[] dArray = this.buffer;
        double d2 = dArray[n];
        dArray[n] = d;
        return d2;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    static final class ValueIterator
    extends AbstractIterator<DoubleCursor> {
        private final double[] buffer;
        private final DoubleCursor cursor;
        private final int size;

        public ValueIterator(double[] dArray, int n) {
            DoubleCursor doubleCursor;
            this.cursor = doubleCursor = new DoubleCursor();
            doubleCursor.index = -1;
            this.size = n;
            this.buffer = dArray;
        }

        @Override
        protected DoubleCursor fetch() {
            int n;
            if (this.cursor.index + 1 == this.size) {
                return (DoubleCursor)this.done();
            }
            DoubleCursor doubleCursor = this.cursor;
            double[] dArray = this.buffer;
            doubleCursor.index = n = doubleCursor.index + 1;
            doubleCursor.value = dArray[n];
            return this.cursor;
        }
    }
}

