/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.FloatArrayList;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.FloatDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class FloatArrayDeque
extends AbstractFloatCollection
implements FloatDeque,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public float[] buffer = FloatArrayList.EMPTY_ARRAY;
    public int head;
    protected final ArraySizingStrategy resizer;
    public int tail;

    public FloatArrayDeque() {
        this(4);
    }

    public FloatArrayDeque(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public FloatArrayDeque(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public FloatArrayDeque(FloatContainer floatContainer) {
        this(floatContainer.size());
        this.addLast(floatContainer);
    }

    private void descendingForEach(FloatPredicate floatPredicate, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        float[] fArray = this.buffer;
        while (floatPredicate.apply(fArray[n3 = FloatArrayDeque.oneLeft(n2, fArray.length)])) {
            n2 = n3;
            if (n3 != n) continue;
        }
    }

    private void descendingForEach(FloatProcedure floatProcedure, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        float[] fArray = this.buffer;
        do {
            n3 = FloatArrayDeque.oneLeft(n2, fArray.length);
            floatProcedure.apply(fArray[n3]);
            n2 = n3;
        } while (n3 != n);
    }

    private void forEach(FloatProcedure floatProcedure, int n, int n2) {
        float[] fArray = this.buffer;
        while (n != n2) {
            floatProcedure.apply(fArray[n]);
            n = FloatArrayDeque.oneRight(n, fArray.length);
        }
    }

    public static FloatArrayDeque from(float ... fArray) {
        FloatArrayDeque floatArrayDeque = new FloatArrayDeque(fArray.length);
        floatArrayDeque.addLast(fArray);
        return floatArrayDeque;
    }

    protected static int oneLeft(int n, int n2) {
        if (n >= 1) {
            return n - 1;
        }
        return n2 - 1;
    }

    protected static int oneRight(int n, int n2) {
        int n3;
        n = n3 = n + 1;
        if (n3 == n2) {
            n = 0;
        }
        return n;
    }

    public int addFirst(FloatContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addFirst(((FloatCursor)object.next()).value);
        }
        return n;
    }

    public int addFirst(Iterable<? extends FloatCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addFirst(((FloatCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addFirst(float f) {
        int n;
        int n2 = n = FloatArrayDeque.oneLeft(this.head, this.buffer.length);
        if (n == this.tail) {
            this.ensureBufferSpace(1);
            n2 = FloatArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        float[] fArray = this.buffer;
        this.head = n2;
        fArray[n2] = f;
    }

    public final void addFirst(float ... fArray) {
        this.ensureBufferSpace(fArray.length);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            this.addFirst(fArray[i]);
        }
    }

    public int addLast(FloatContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addLast(((FloatCursor)object.next()).value);
        }
        return n;
    }

    public int addLast(Iterable<? extends FloatCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addLast(((FloatCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addLast(float f) {
        int n;
        int n2 = n = FloatArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == n) {
            this.ensureBufferSpace(1);
            n2 = FloatArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = f;
        this.tail = n2;
    }

    public final void addLast(float ... fArray) {
        this.ensureBufferSpace(1);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            this.addLast(fArray[i]);
        }
    }

    public int bufferIndexOf(float f) {
        int n = this.tail;
        int n2 = this.buffer.length;
        int n3 = this.head;
        while (n3 != n) {
            if (Float.floatToIntBits(this.buffer[n3]) == Float.floatToIntBits(f)) {
                return n3;
            }
            n3 = FloatArrayDeque.oneRight(n3, n2);
        }
        return -1;
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            Arrays.fill(this.buffer, n, n2, 0.0f);
        } else {
            Arrays.fill(this.buffer, 0, n2, 0.0f);
            float[] fArray = this.buffer;
            Arrays.fill(fArray, this.head, fArray.length, 0.0f);
        }
        this.tail = 0;
        this.head = 0;
    }

    public FloatArrayDeque clone() {
        try {
            FloatArrayDeque floatArrayDeque = (FloatArrayDeque)super.clone();
            floatArrayDeque.buffer = (float[])this.buffer.clone();
            return floatArrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(float f) {
        int n = this.head;
        int n2 = this.tail;
        float[] fArray = this.buffer;
        while (n != n2) {
            if (Float.floatToIntBits(fArray[n]) == Float.floatToIntBits(f)) {
                return true;
            }
            n = FloatArrayDeque.oneRight(n, fArray.length);
        }
        return false;
    }

    @Override
    public <T extends FloatPredicate> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public <T extends FloatProcedure> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public Iterator<FloatCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureBufferSpace(int n) {
        int n2 = this.buffer.length;
        int n3 = this.size();
        if (n3 + n < n2) return;
        n = this.resizer.grow(n2, n3 + 1, n);
        try {
            float[] fArray = new float[n];
            if (n2 > 0) {
                this.toArray(fArray);
                this.tail = n3;
                this.head = 0;
            }
            this.buffer = fArray;
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensureBufferSpace(n - this.size());
    }

    protected boolean equalElements(FloatArrayDeque object) {
        int n = this.size();
        int n2 = ((FloatArrayDeque)object).size();
        boolean bl = false;
        if (n2 != n) {
            return false;
        }
        Iterator<FloatCursor> iterator = this.iterator();
        object = ((FloatArrayDeque)object).iterator();
        while (iterator.hasNext() && object.hasNext()) {
            if (Float.floatToIntBits(((FloatCursor)object.next()).value) == Float.floatToIntBits(iterator.next().value)) continue;
            return false;
        }
        boolean bl2 = bl;
        if (!iterator.hasNext()) {
            bl2 = bl;
            if (!object.hasNext()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((FloatArrayDeque)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends FloatPredicate> T forEach(T t) {
        int n = this.head;
        int n2 = this.tail;
        float[] fArray = this.buffer;
        while (n != n2 && t.apply(fArray[n])) {
            n = FloatArrayDeque.oneRight(n, fArray.length);
        }
        return t;
    }

    @Override
    public <T extends FloatProcedure> T forEach(T t) {
        this.forEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public float getFirst() {
        return this.buffer[this.head];
    }

    @Override
    public float getLast() {
        float[] fArray = this.buffer;
        return fArray[FloatArrayDeque.oneLeft(this.tail, fArray.length)];
    }

    public int hashCode() {
        int n = this.head;
        int n2 = this.tail;
        float[] fArray = this.buffer;
        int n3 = 1;
        while (n != n2) {
            n3 = n3 * 31 + BitMixer.mix(this.buffer[n]);
            n = FloatArrayDeque.oneRight(n, fArray.length);
        }
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<FloatCursor> iterator() {
        return new ValueIterator();
    }

    public int lastBufferIndexOf(float f) {
        int n;
        int n2 = this.buffer.length;
        int n3 = FloatArrayDeque.oneLeft(this.head, n2);
        int n4 = this.tail;
        while ((n = FloatArrayDeque.oneLeft(n4, n2)) != n3) {
            n4 = n;
            if (Float.floatToIntBits(this.buffer[n]) != Float.floatToIntBits(f)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = FloatArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public int removeAll(float f) {
        int n;
        int n2 = this.tail;
        int n3 = this.buffer.length;
        int n4 = n = this.head;
        int n5 = 0;
        while (n != n2) {
            if (Float.floatToIntBits(this.buffer[n]) == Float.floatToIntBits(f)) {
                this.buffer[n] = 0.0f;
                ++n5;
            } else {
                if (n4 != n) {
                    float[] fArray = this.buffer;
                    fArray[n4] = fArray[n];
                    fArray[n] = 0.0f;
                }
                n4 = FloatArrayDeque.oneRight(n4, n3);
            }
            n = FloatArrayDeque.oneRight(n, n3);
        }
        this.tail = n4;
        return n5;
    }

    /*
     * Loose catch block
     */
    @Override
    public int removeAll(FloatPredicate floatPredicate) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        float[] fArray;
        block10: {
            int n6;
            fArray = this.buffer;
            n5 = this.tail;
            n4 = fArray.length;
            int n7 = n6 = this.head;
            n3 = 0;
            while (true) {
                n2 = n6;
                n = n7;
                if (n6 == n5) break block10;
                n2 = n7;
                if (floatPredicate.apply(fArray[n6])) {
                    fArray[n6] = 0.0f;
                    ++n3;
                    break block11;
                }
                if (n7 == n6) break block12;
                break;
            }
            catch (Throwable throwable) {
                while (n6 != n5) {
                    if (n2 != n6) {
                        fArray[n2] = fArray[n6];
                        fArray[n6] = 0.0f;
                    }
                    n2 = FloatArrayDeque.oneRight(n2, n4);
                    n6 = FloatArrayDeque.oneRight(n6, n4);
                }
                this.tail = n2;
                throw throwable;
            }
            {
                block11: {
                    block12: {
                        fArray[n7] = fArray[n6];
                        fArray[n6] = 0.0f;
                    }
                    n2 = n7;
                    n7 = FloatArrayDeque.oneRight(n7, n4);
                }
                n2 = n7;
                n6 = n = FloatArrayDeque.oneRight(n6, n4);
                continue;
            }
        }
        while (n2 != n5) {
            if (n != n2) {
                fArray[n] = fArray[n2];
                fArray[n2] = 0.0f;
            }
            n = FloatArrayDeque.oneRight(n, n4);
            n2 = FloatArrayDeque.oneRight(n2, n4);
        }
        this.tail = n;
        return n3;
    }

    public void removeAtBufferIndex(int n) {
        int n2;
        float[] fArray = this.buffer;
        int n3 = fArray.length;
        int n4 = n3 - 1;
        int n5 = this.head;
        int n6 = this.tail;
        int n7 = Math.abs(n - n5) % n3;
        if (n7 < (n2 = Math.abs(n6 - n) % n3)) {
            if (n >= n5) {
                System.arraycopy(fArray, n5, fArray, n5 + 1, n7);
            } else {
                System.arraycopy(fArray, 0, fArray, 1, n);
                fArray[0] = fArray[n4];
                System.arraycopy(fArray, n5, fArray, n5 + 1, n4 - n5);
            }
            fArray[n5] = 0.0f;
            this.head = FloatArrayDeque.oneRight(n5, n3);
        } else {
            if (n < n6) {
                System.arraycopy(fArray, n + 1, fArray, n, n2);
            } else {
                System.arraycopy(fArray, n + 1, fArray, n, n4 - n);
                fArray[n4] = fArray[0];
                System.arraycopy(fArray, 1, fArray, 0, n6);
            }
            fArray[n6] = 0.0f;
            this.tail = FloatArrayDeque.oneLeft(n6, n3);
        }
    }

    @Override
    public float removeFirst() {
        float[] fArray = this.buffer;
        int n = this.head;
        float f = fArray[n];
        fArray[n] = 0.0f;
        this.head = FloatArrayDeque.oneRight(n, fArray.length);
        return f;
    }

    @Override
    public int removeFirst(float f) {
        int n = this.bufferIndexOf(f);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public float removeLast() {
        int n;
        this.tail = n = FloatArrayDeque.oneLeft(this.tail, this.buffer.length);
        float[] fArray = this.buffer;
        float f = fArray[n];
        fArray[n] = 0.0f;
        return f;
    }

    @Override
    public int removeLast(float f) {
        int n = this.lastBufferIndexOf(f);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public int size() {
        int n = this.head;
        int n2 = this.tail;
        if (n <= n2) {
            return n2 - n;
        }
        return n2 - n + this.buffer.length;
    }

    @Override
    public float[] toArray() {
        return this.toArray(new float[this.size()]);
    }

    public float[] toArray(float[] fArray) {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            System.arraycopy(this.buffer, n, fArray, 0, this.size());
        } else if (n > n2) {
            float[] fArray2 = this.buffer;
            n2 = fArray2.length - n;
            System.arraycopy(fArray2, n, fArray, 0, n2);
            System.arraycopy(this.buffer, 0, fArray, n2, this.tail);
        }
        return fArray;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private int remaining;

        public DescendingValueIterator() {
            FloatCursor floatCursor;
            this.cursor = floatCursor = new FloatCursor();
            floatCursor.index = FloatArrayDeque.this.tail;
            this.remaining = FloatArrayDeque.this.size();
        }

        @Override
        protected FloatCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (FloatCursor)this.done();
            }
            this.remaining = n - 1;
            FloatCursor floatCursor = this.cursor;
            float[] fArray = FloatArrayDeque.this.buffer;
            FloatCursor floatCursor2 = this.cursor;
            floatCursor2.index = n = FloatArrayDeque.oneLeft(floatCursor2.index, FloatArrayDeque.this.buffer.length);
            floatCursor.value = fArray[n];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private int remaining;

        public ValueIterator() {
            FloatCursor floatCursor;
            this.cursor = floatCursor = new FloatCursor();
            floatCursor.index = FloatArrayDeque.oneLeft(FloatArrayDeque.this.head, FloatArrayDeque.this.buffer.length);
            this.remaining = FloatArrayDeque.this.size();
        }

        @Override
        protected FloatCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (FloatCursor)this.done();
            }
            this.remaining = n - 1;
            FloatCursor floatCursor = this.cursor;
            float[] fArray = FloatArrayDeque.this.buffer;
            FloatCursor floatCursor2 = this.cursor;
            floatCursor2.index = n = FloatArrayDeque.oneRight(floatCursor2.index, FloatArrayDeque.this.buffer.length);
            floatCursor.value = fArray[n];
            return this.cursor;
        }
    }
}

