/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.FloatIndexedContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class FloatArrayList
extends AbstractFloatCollection
implements FloatIndexedContainer,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final float[] EMPTY_ARRAY = new float[0];
    public float[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public FloatArrayList() {
        this(4);
    }

    public FloatArrayList(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public FloatArrayList(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public FloatArrayList(FloatContainer floatContainer) {
        this(floatContainer.size());
        this.addAll(floatContainer);
    }

    public static FloatArrayList from(float ... fArray) {
        FloatArrayList floatArrayList = new FloatArrayList(fArray.length);
        floatArrayList.add(fArray);
        return floatArrayList;
    }

    @Override
    public void add(float f) {
        this.ensureBufferSpace(1);
        float[] fArray = this.buffer;
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        fArray[n] = f;
    }

    public void add(float f, float f2) {
        int n;
        this.ensureBufferSpace(2);
        float[] fArray = this.buffer;
        int n2 = this.elementsCount;
        this.elementsCount = n = n2 + 1;
        fArray[n2] = f;
        this.elementsCount = n + 1;
        fArray[n] = f2;
    }

    public final void add(float ... fArray) {
        this.add(fArray, 0, fArray.length);
    }

    public void add(float[] fArray, int n, int n2) {
        this.ensureBufferSpace(n2);
        System.arraycopy(fArray, n, this.buffer, this.elementsCount, n2);
        this.elementsCount += n2;
    }

    public int addAll(FloatContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.add(((FloatCursor)object.next()).value);
        }
        return n;
    }

    public int addAll(Iterable<? extends FloatCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.add(((FloatCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0.0f);
        this.elementsCount = 0;
    }

    public FloatArrayList clone() {
        try {
            FloatArrayList floatArrayList = (FloatArrayList)super.clone();
            floatArrayList.buffer = (float[])this.buffer.clone();
            return floatArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(float f) {
        boolean bl = this.indexOf(f) >= 0;
        return bl;
    }

    protected void ensureBufferSpace(int n) {
        int n2 = this.elementsCount;
        float[] fArray = this.buffer;
        int n3 = fArray == null ? 0 : fArray.length;
        if (n2 + n > n3) {
            n = this.resizer.grow(n3, n2, n);
            this.buffer = Arrays.copyOf(this.buffer, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        float[] fArray = this.buffer;
        int n2 = fArray == null ? 0 : fArray.length;
        if (n > n2) {
            this.ensureBufferSpace(n - this.size());
        }
    }

    protected boolean equalElements(FloatArrayList floatArrayList) {
        int n = this.size();
        if (floatArrayList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Float.floatToIntBits(floatArrayList.get(i)) == Float.floatToIntBits(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((FloatArrayList)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends FloatPredicate> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends FloatPredicate> T forEach(T t, int n, int n2) {
        float[] fArray = this.buffer;
        while (n < n2 && t.apply(fArray[n])) {
            ++n;
        }
        return t;
    }

    @Override
    public <T extends FloatProcedure> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends FloatProcedure> T forEach(T t, int n, int n2) {
        float[] fArray = this.buffer;
        while (n < n2) {
            t.apply(fArray[n]);
            ++n;
        }
        return t;
    }

    @Override
    public float get(int n) {
        return this.buffer[n];
    }

    public int hashCode() {
        int n = this.elementsCount;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + BitMixer.mix(this.buffer[i]);
        }
        return n2;
    }

    @Override
    public int indexOf(float f) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (Float.floatToIntBits(this.buffer[i]) != Float.floatToIntBits(f)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insert(int n, float f) {
        this.ensureBufferSpace(1);
        float[] fArray = this.buffer;
        System.arraycopy(fArray, n, fArray, n + 1, this.elementsCount - n);
        this.buffer[n] = f;
        ++this.elementsCount;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.elementsCount == 0;
        return bl;
    }

    @Override
    public Iterator<FloatCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public int lastIndexOf(float f) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (Float.floatToIntBits(this.buffer[i]) != Float.floatToIntBits(f)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public float remove(int n) {
        float[] fArray = this.buffer;
        float f = fArray[n];
        int n2 = n + 1;
        int n3 = this.elementsCount;
        if (n2 < n3) {
            System.arraycopy(fArray, n2, fArray, n, n3 - n - 1);
        }
        this.elementsCount = n = this.elementsCount - 1;
        this.buffer[n] = 0.0f;
        return f;
    }

    @Override
    public int removeAll(float f) {
        int n;
        int n2 = 0;
        for (int i = 0; i < (n = this.elementsCount); ++i) {
            if (Float.floatToIntBits(this.buffer[i]) == Float.floatToIntBits(f)) {
                this.buffer[i] = 0.0f;
                continue;
            }
            if (n2 != i) {
                float[] fArray = this.buffer;
                fArray[n2] = fArray[i];
                fArray[i] = 0.0f;
            }
            ++n2;
        }
        this.elementsCount = n2;
        return n - n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removeAll(FloatPredicate floatPredicate) {
        int n;
        int n2;
        float[] fArray = this.buffer;
        int n3 = this.elementsCount;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            n2 = ++n4;
            n = ++n5;
            if (n4 >= n3) break;
            try {
                if (floatPredicate.apply(fArray[n4])) {
                    fArray[n4] = 0.0f;
                    continue;
                }
                if (n5 == n4) continue;
            }
            catch (Throwable throwable) {
                while (true) {
                    if (n4 >= n3) {
                        this.elementsCount = n5;
                        throw throwable;
                    }
                    if (n5 != n4) {
                        fArray[n5] = fArray[n4];
                        fArray[n4] = 0.0f;
                    }
                    ++n5;
                    ++n4;
                }
            }
            fArray[n5] = fArray[n4];
            fArray[n4] = 0.0f;
        }
        while (true) {
            if (n2 >= n3) {
                this.elementsCount = n;
                return n3 - n;
            }
            if (n != n2) {
                fArray[n] = fArray[n2];
                fArray[n2] = 0.0f;
            }
            ++n;
            ++n2;
        }
    }

    @Override
    public int removeFirst(float f) {
        int n = this.indexOf(f);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public int removeLast(float f) {
        int n = this.lastIndexOf(f);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public void removeRange(int n, int n2) {
        float[] fArray = this.buffer;
        System.arraycopy(fArray, n2, fArray, n, this.elementsCount - n2);
        n = n2 - n;
        this.elementsCount = n2 = this.elementsCount - n;
        Arrays.fill(this.buffer, n2, n + n2, 0.0f);
    }

    public void resize(int n) {
        float[] fArray = this.buffer;
        if (n <= fArray.length) {
            int n2 = this.elementsCount;
            if (n < n2) {
                Arrays.fill(fArray, n, n2, 0.0f);
            } else {
                Arrays.fill(fArray, n2, n, 0.0f);
            }
        } else {
            this.ensureCapacity(n);
        }
        this.elementsCount = n;
    }

    @Override
    public float set(int n, float f) {
        float[] fArray = this.buffer;
        float f2 = fArray[n];
        fArray[n] = f;
        return f2;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public float[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    static final class ValueIterator
    extends AbstractIterator<FloatCursor> {
        private final float[] buffer;
        private final FloatCursor cursor;
        private final int size;

        public ValueIterator(float[] fArray, int n) {
            FloatCursor floatCursor;
            this.cursor = floatCursor = new FloatCursor();
            floatCursor.index = -1;
            this.size = n;
            this.buffer = fArray;
        }

        @Override
        protected FloatCursor fetch() {
            int n;
            if (this.cursor.index + 1 == this.size) {
                return (FloatCursor)this.done();
            }
            FloatCursor floatCursor = this.cursor;
            float[] fArray = this.buffer;
            floatCursor.index = n = floatCursor.index + 1;
            floatCursor.value = fArray[n];
            return this.cursor;
        }
    }
}

