/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.BufferAllocationException;

public final class HashContainers {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int MAX_HASH_ARRAY_LENGTH = 0x40000000;
    public static final float MAX_LOAD_FACTOR = 0.99f;
    public static final int MIN_HASH_ARRAY_LENGTH = 4;
    public static final float MIN_LOAD_FACTOR = 0.01f;

    static void checkLoadFactor(double d, double d2, double d3) {
        if (!(d < d2) && !(d > d3)) {
            return;
        }
        throw new BufferAllocationException("The load factor should be in range [%.2f, %.2f]: %f", d2, d3, d);
    }

    static boolean checkPowerOfTwo(int n) {
        return true;
    }

    static int expandAtCount(int n, double d) {
        return Math.min(n - 1, (int)Math.ceil((double)n * d));
    }

    public static int maxElements(double d) {
        HashContainers.checkLoadFactor(d, 0.0, 1.0);
        return HashContainers.expandAtCount(0x40000000, d) - 1;
    }

    static int minBufferSize(int n, double d) {
        if (n >= 0) {
            long l;
            long l2 = l = (long)Math.ceil((double)n / d);
            if (l == (long)n) {
                l2 = l + 1L;
            }
            if ((l2 = Math.max(4L, BitUtil.nextHighestPowerOfTwo(l2))) <= 0x40000000L) {
                return (int)l2;
            }
            throw new BufferAllocationException("Maximum array size exceeded for this load factor (elements: %d, load factor: %f)", n, d);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Number of elements must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    static int nextBufferSize(int n, int n2, double d) {
        if (n != 0x40000000) {
            return n << 1;
        }
        throw new BufferAllocationException("Maximum array size exceeded for this load factor (elements: %d, load factor: %f)", n2, d);
    }
}

