/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.Containers;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.RandomizedHashOrderMixer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HashOrderMixing {
    private static final HashOrderMixingStrategy DETERMINISTIC = new HashOrderMixingStrategy(){

        @Override
        public HashOrderMixingStrategy clone() {
            return this;
        }

        @Override
        public int newKeyMixer(int n) {
            return BitMixer.mix32(n);
        }
    };
    public static final String PROPERTY_BIT_MIXER = "hppc.bitmixer";
    private static Strategy strategy;

    private HashOrderMixing() {
    }

    public static HashOrderMixingStrategy constant(final long l) {
        return new HashOrderMixingStrategy(){

            @Override
            public HashOrderMixingStrategy clone() {
                return this;
            }

            @Override
            public int newKeyMixer(int n) {
                return (int)BitMixer.mix64((long)n ^ l);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashOrderMixingStrategy defaultStrategy() {
        if (strategy == null) {
            block8: {
                PrivilegedAction<String> privilegedAction = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(HashOrderMixing.PROPERTY_BIT_MIXER);
                    }
                };
                privilegedAction = (String)AccessController.doPrivileged(privilegedAction);
                if (privilegedAction == null) break block8;
                for (Strategy strategy : Strategy.values()) {
                    try {
                        if (!strategy.name().equalsIgnoreCase((String)((Object)privilegedAction))) continue;
                        HashOrderMixing.strategy = strategy;
                        break;
                    }
                    catch (SecurityException securityException) {
                        Logger.getLogger(Containers.class.getName()).log(Level.INFO, "Failed to read 'tests.seed' property for initial random seed.", securityException);
                        break;
                    }
                }
            }
            if (strategy == null) {
                strategy = Strategy.RANDOM;
            }
        }
        try {
            return (HashOrderMixingStrategy)strategy.call();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Deprecated
    public static HashOrderMixingStrategy deterministic() {
        return DETERMINISTIC;
    }

    @Deprecated
    public static HashOrderMixingStrategy none() {
        return new HashOrderMixingStrategy(){

            @Override
            public HashOrderMixingStrategy clone() {
                return this;
            }

            @Override
            public int newKeyMixer(int n) {
                return 0;
            }
        };
    }

    public static HashOrderMixingStrategy randomized() {
        return RandomizedHashOrderMixer.INSTANCE;
    }

    public static abstract class Strategy
    extends Enum<Strategy>
    implements Callable<HashOrderMixingStrategy> {
        private static final /* synthetic */ Strategy[] $VALUES;
        public static final /* enum */ Strategy DETERMINISTIC;
        public static final /* enum */ Strategy NONE;
        public static final /* enum */ Strategy RANDOM;

        static {
            Strategy strategy;
            Strategy strategy2;
            Strategy strategy3;
            RANDOM = strategy3 = new Strategy(){

                @Override
                public HashOrderMixingStrategy call() {
                    return HashOrderMixing.randomized();
                }
            };
            DETERMINISTIC = strategy2 = new Strategy(){

                @Override
                public HashOrderMixingStrategy call() {
                    return HashOrderMixing.deterministic();
                }
            };
            NONE = strategy = new Strategy(){

                @Override
                public HashOrderMixingStrategy call() {
                    return HashOrderMixing.none();
                }
            };
            $VALUES = new Strategy[]{strategy3, strategy2, strategy};
        }

        public static Strategy valueOf(String string2) {
            return Enum.valueOf(Strategy.class, string2);
        }

        public static Strategy[] values() {
            return (Strategy[])$VALUES.clone();
        }
    }
}

