/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntArrayDeque
extends AbstractIntCollection
implements IntDeque,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public int[] buffer = IntArrayList.EMPTY_ARRAY;
    public int head;
    protected final ArraySizingStrategy resizer;
    public int tail;

    public IntArrayDeque() {
        this(4);
    }

    public IntArrayDeque(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public IntArrayDeque(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public IntArrayDeque(IntContainer intContainer) {
        this(intContainer.size());
        this.addLast(intContainer);
    }

    private void descendingForEach(IntPredicate intPredicate, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        int[] nArray = this.buffer;
        while (intPredicate.apply(nArray[n3 = IntArrayDeque.oneLeft(n2, nArray.length)])) {
            n2 = n3;
            if (n3 != n) continue;
        }
    }

    private void descendingForEach(IntProcedure intProcedure, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        int[] nArray = this.buffer;
        do {
            n3 = IntArrayDeque.oneLeft(n2, nArray.length);
            intProcedure.apply(nArray[n3]);
            n2 = n3;
        } while (n3 != n);
    }

    private void forEach(IntProcedure intProcedure, int n, int n2) {
        int[] nArray = this.buffer;
        while (n != n2) {
            intProcedure.apply(nArray[n]);
            n = IntArrayDeque.oneRight(n, nArray.length);
        }
    }

    public static IntArrayDeque from(int ... nArray) {
        IntArrayDeque intArrayDeque = new IntArrayDeque(nArray.length);
        intArrayDeque.addLast(nArray);
        return intArrayDeque;
    }

    protected static int oneLeft(int n, int n2) {
        if (n >= 1) {
            return n - 1;
        }
        return n2 - 1;
    }

    protected static int oneRight(int n, int n2) {
        int n3;
        n = n3 = n + 1;
        if (n3 == n2) {
            n = 0;
        }
        return n;
    }

    public int addFirst(IntContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addFirst(((IntCursor)object.next()).value);
        }
        return n;
    }

    public int addFirst(Iterable<? extends IntCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addFirst(((IntCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addFirst(int n) {
        int n2;
        int n3 = n2 = IntArrayDeque.oneLeft(this.head, this.buffer.length);
        if (n2 == this.tail) {
            this.ensureBufferSpace(1);
            n3 = IntArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        int[] nArray = this.buffer;
        this.head = n3;
        nArray[n3] = n;
    }

    public final void addFirst(int ... nArray) {
        this.ensureBufferSpace(nArray.length);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.addFirst(nArray[i]);
        }
    }

    public int addLast(IntContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addLast(((IntCursor)object.next()).value);
        }
        return n;
    }

    public int addLast(Iterable<? extends IntCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addLast(((IntCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addLast(int n) {
        int n2;
        int n3 = n2 = IntArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == n2) {
            this.ensureBufferSpace(1);
            n3 = IntArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = n;
        this.tail = n3;
    }

    public final void addLast(int ... nArray) {
        this.ensureBufferSpace(1);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.addLast(nArray[i]);
        }
    }

    public int bufferIndexOf(int n) {
        int n2 = this.tail;
        int n3 = this.buffer.length;
        int n4 = this.head;
        while (n4 != n2) {
            if (this.buffer[n4] == n) {
                return n4;
            }
            n4 = IntArrayDeque.oneRight(n4, n3);
        }
        return -1;
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            Arrays.fill(this.buffer, n, n2, 0);
        } else {
            Arrays.fill(this.buffer, 0, n2, 0);
            int[] nArray = this.buffer;
            Arrays.fill(nArray, this.head, nArray.length, 0);
        }
        this.tail = 0;
        this.head = 0;
    }

    public IntArrayDeque clone() {
        try {
            IntArrayDeque intArrayDeque = (IntArrayDeque)super.clone();
            intArrayDeque.buffer = (int[])this.buffer.clone();
            return intArrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(int n) {
        int n2 = this.head;
        int n3 = this.tail;
        int[] nArray = this.buffer;
        while (n2 != n3) {
            if (nArray[n2] == n) {
                return true;
            }
            n2 = IntArrayDeque.oneRight(n2, nArray.length);
        }
        return false;
    }

    @Override
    public <T extends IntPredicate> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public <T extends IntProcedure> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public Iterator<IntCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureBufferSpace(int n) {
        int n2 = this.buffer.length;
        int n3 = this.size();
        if (n3 + n < n2) return;
        n = this.resizer.grow(n2, n3 + 1, n);
        try {
            int[] nArray = new int[n];
            if (n2 > 0) {
                this.toArray(nArray);
                this.tail = n3;
                this.head = 0;
            }
            this.buffer = nArray;
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensureBufferSpace(n - this.size());
    }

    protected boolean equalElements(IntArrayDeque object) {
        int n = this.size();
        int n2 = ((IntArrayDeque)object).size();
        boolean bl = false;
        if (n2 != n) {
            return false;
        }
        Iterator<IntCursor> iterator = this.iterator();
        object = ((IntArrayDeque)object).iterator();
        while (iterator.hasNext() && object.hasNext()) {
            if (((IntCursor)object.next()).value == iterator.next().value) continue;
            return false;
        }
        boolean bl2 = bl;
        if (!iterator.hasNext()) {
            bl2 = bl;
            if (!object.hasNext()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntArrayDeque)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntPredicate> T forEach(T t) {
        int n = this.head;
        int n2 = this.tail;
        int[] nArray = this.buffer;
        while (n != n2 && t.apply(nArray[n])) {
            n = IntArrayDeque.oneRight(n, nArray.length);
        }
        return t;
    }

    @Override
    public <T extends IntProcedure> T forEach(T t) {
        this.forEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public int getFirst() {
        return this.buffer[this.head];
    }

    @Override
    public int getLast() {
        int[] nArray = this.buffer;
        return nArray[IntArrayDeque.oneLeft(this.tail, nArray.length)];
    }

    public int hashCode() {
        int n = this.head;
        int n2 = this.tail;
        int[] nArray = this.buffer;
        int n3 = 1;
        while (n != n2) {
            n3 = n3 * 31 + BitMixer.mix(this.buffer[n]);
            n = IntArrayDeque.oneRight(n, nArray.length);
        }
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new ValueIterator();
    }

    public int lastBufferIndexOf(int n) {
        int n2;
        int n3 = this.buffer.length;
        int n4 = IntArrayDeque.oneLeft(this.head, n3);
        int n5 = this.tail;
        while ((n2 = IntArrayDeque.oneLeft(n5, n3)) != n4) {
            n5 = n2;
            if (this.buffer[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = IntArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public int removeAll(int n) {
        int n2;
        int n3 = this.tail;
        int n4 = this.buffer.length;
        int n5 = n2 = this.head;
        int n6 = 0;
        while (n2 != n3) {
            int[] nArray = this.buffer;
            if (nArray[n2] == n) {
                nArray[n2] = 0;
                ++n6;
            } else {
                if (n5 != n2) {
                    nArray[n5] = nArray[n2];
                    nArray[n2] = 0;
                }
                n5 = IntArrayDeque.oneRight(n5, n4);
            }
            n2 = IntArrayDeque.oneRight(n2, n4);
        }
        this.tail = n5;
        return n6;
    }

    /*
     * Loose catch block
     */
    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        block10: {
            int n6;
            nArray = this.buffer;
            n5 = this.tail;
            n4 = nArray.length;
            int n7 = n6 = this.head;
            n3 = 0;
            while (true) {
                n2 = n6;
                n = n7;
                if (n6 == n5) break block10;
                n2 = n7;
                if (intPredicate.apply(nArray[n6])) {
                    nArray[n6] = 0;
                    ++n3;
                    break block11;
                }
                if (n7 == n6) break block12;
                break;
            }
            catch (Throwable throwable) {
                while (n6 != n5) {
                    if (n2 != n6) {
                        nArray[n2] = nArray[n6];
                        nArray[n6] = 0;
                    }
                    n2 = IntArrayDeque.oneRight(n2, n4);
                    n6 = IntArrayDeque.oneRight(n6, n4);
                }
                this.tail = n2;
                throw throwable;
            }
            {
                block11: {
                    block12: {
                        nArray[n7] = nArray[n6];
                        nArray[n6] = 0;
                    }
                    n2 = n7;
                    n7 = IntArrayDeque.oneRight(n7, n4);
                }
                n2 = n7;
                n6 = n = IntArrayDeque.oneRight(n6, n4);
                continue;
            }
        }
        while (n2 != n5) {
            if (n != n2) {
                nArray[n] = nArray[n2];
                nArray[n2] = 0;
            }
            n = IntArrayDeque.oneRight(n, n4);
            n2 = IntArrayDeque.oneRight(n2, n4);
        }
        this.tail = n;
        return n3;
    }

    public void removeAtBufferIndex(int n) {
        int n2;
        int[] nArray = this.buffer;
        int n3 = nArray.length;
        int n4 = n3 - 1;
        int n5 = this.head;
        int n6 = this.tail;
        int n7 = Math.abs(n - n5) % n3;
        if (n7 < (n2 = Math.abs(n6 - n) % n3)) {
            if (n >= n5) {
                System.arraycopy(nArray, n5, nArray, n5 + 1, n7);
            } else {
                System.arraycopy(nArray, 0, nArray, 1, n);
                nArray[0] = nArray[n4];
                System.arraycopy(nArray, n5, nArray, n5 + 1, n4 - n5);
            }
            nArray[n5] = 0;
            this.head = IntArrayDeque.oneRight(n5, n3);
        } else {
            if (n < n6) {
                System.arraycopy(nArray, n + 1, nArray, n, n2);
            } else {
                System.arraycopy(nArray, n + 1, nArray, n, n4 - n);
                nArray[n4] = nArray[0];
                System.arraycopy(nArray, 1, nArray, 0, n6);
            }
            nArray[n6] = 0;
            this.tail = IntArrayDeque.oneLeft(n6, n3);
        }
    }

    @Override
    public int removeFirst() {
        int[] nArray = this.buffer;
        int n = this.head;
        int n2 = nArray[n];
        nArray[n] = 0;
        this.head = IntArrayDeque.oneRight(n, nArray.length);
        return n2;
    }

    @Override
    public int removeFirst(int n) {
        if ((n = this.bufferIndexOf(n)) >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public int removeLast() {
        int n;
        this.tail = n = IntArrayDeque.oneLeft(this.tail, this.buffer.length);
        int[] nArray = this.buffer;
        int n2 = nArray[n];
        nArray[n] = 0;
        return n2;
    }

    @Override
    public int removeLast(int n) {
        if ((n = this.lastBufferIndexOf(n)) >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public int size() {
        int n = this.head;
        int n2 = this.tail;
        if (n <= n2) {
            return n2 - n;
        }
        return n2 - n + this.buffer.length;
    }

    @Override
    public int[] toArray() {
        return this.toArray(new int[this.size()]);
    }

    public int[] toArray(int[] nArray) {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            System.arraycopy(this.buffer, n, nArray, 0, this.size());
        } else if (n > n2) {
            int[] nArray2 = this.buffer;
            n2 = nArray2.length - n;
            System.arraycopy(nArray2, n, nArray, 0, n2);
            System.arraycopy(this.buffer, 0, nArray, n2, this.tail);
        }
        return nArray;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private int remaining;

        public DescendingValueIterator() {
            IntCursor intCursor;
            this.cursor = intCursor = new IntCursor();
            intCursor.index = IntArrayDeque.this.tail;
            this.remaining = IntArrayDeque.this.size();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (IntCursor)this.done();
            }
            this.remaining = n - 1;
            IntCursor intCursor = this.cursor;
            int[] nArray = IntArrayDeque.this.buffer;
            IntCursor intCursor2 = this.cursor;
            intCursor2.index = n = IntArrayDeque.oneLeft(intCursor2.index, IntArrayDeque.this.buffer.length);
            intCursor.value = nArray[n];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private int remaining;

        public ValueIterator() {
            IntCursor intCursor;
            this.cursor = intCursor = new IntCursor();
            intCursor.index = IntArrayDeque.oneLeft(IntArrayDeque.this.head, IntArrayDeque.this.buffer.length);
            this.remaining = IntArrayDeque.this.size();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (IntCursor)this.done();
            }
            this.remaining = n - 1;
            IntCursor intCursor = this.cursor;
            int[] nArray = IntArrayDeque.this.buffer;
            IntCursor intCursor2 = this.cursor;
            intCursor2.index = n = IntArrayDeque.oneRight(intCursor2.index, IntArrayDeque.this.buffer.length);
            intCursor.value = nArray[n];
            return this.cursor;
        }
    }
}

