/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntArrayList
extends AbstractIntCollection
implements IntIndexedContainer,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final int[] EMPTY_ARRAY = new int[0];
    public int[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public IntArrayList() {
        this(4);
    }

    public IntArrayList(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public IntArrayList(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public IntArrayList(IntContainer intContainer) {
        this(intContainer.size());
        this.addAll(intContainer);
    }

    public static IntArrayList from(int ... nArray) {
        IntArrayList intArrayList = new IntArrayList(nArray.length);
        intArrayList.add(nArray);
        return intArrayList;
    }

    @Override
    public void add(int n) {
        this.ensureBufferSpace(1);
        int[] nArray = this.buffer;
        int n2 = this.elementsCount;
        this.elementsCount = n2 + 1;
        nArray[n2] = n;
    }

    public void add(int n, int n2) {
        int n3;
        this.ensureBufferSpace(2);
        int[] nArray = this.buffer;
        int n4 = this.elementsCount;
        this.elementsCount = n3 = n4 + 1;
        nArray[n4] = n;
        this.elementsCount = n3 + 1;
        nArray[n3] = n2;
    }

    public final void add(int ... nArray) {
        this.add(nArray, 0, nArray.length);
    }

    public void add(int[] nArray, int n, int n2) {
        this.ensureBufferSpace(n2);
        System.arraycopy(nArray, n, this.buffer, this.elementsCount, n2);
        this.elementsCount += n2;
    }

    public int addAll(IntContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.add(((IntCursor)object.next()).value);
        }
        return n;
    }

    public int addAll(Iterable<? extends IntCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.add(((IntCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0);
        this.elementsCount = 0;
    }

    public IntArrayList clone() {
        try {
            IntArrayList intArrayList = (IntArrayList)super.clone();
            intArrayList.buffer = (int[])this.buffer.clone();
            return intArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(int n) {
        boolean bl = this.indexOf(n) >= 0;
        return bl;
    }

    protected void ensureBufferSpace(int n) {
        int n2 = this.elementsCount;
        int[] nArray = this.buffer;
        int n3 = nArray == null ? 0 : nArray.length;
        if (n2 + n > n3) {
            n = this.resizer.grow(n3, n2, n);
            this.buffer = Arrays.copyOf(this.buffer, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        int[] nArray = this.buffer;
        int n2 = nArray == null ? 0 : nArray.length;
        if (n > n2) {
            this.ensureBufferSpace(n - this.size());
        }
    }

    protected boolean equalElements(IntArrayList intArrayList) {
        int n = this.size();
        if (intArrayList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (intArrayList.get(i) == this.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntArrayList)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntPredicate> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends IntPredicate> T forEach(T t, int n, int n2) {
        int[] nArray = this.buffer;
        while (n < n2 && t.apply(nArray[n])) {
            ++n;
        }
        return t;
    }

    @Override
    public <T extends IntProcedure> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends IntProcedure> T forEach(T t, int n, int n2) {
        int[] nArray = this.buffer;
        while (n < n2) {
            t.apply(nArray[n]);
            ++n;
        }
        return t;
    }

    @Override
    public int get(int n) {
        return this.buffer[n];
    }

    public int hashCode() {
        int n = this.elementsCount;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + BitMixer.mix(this.buffer[i]);
        }
        return n2;
    }

    @Override
    public int indexOf(int n) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (this.buffer[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insert(int n, int n2) {
        this.ensureBufferSpace(1);
        int[] nArray = this.buffer;
        System.arraycopy(nArray, n, nArray, n + 1, this.elementsCount - n);
        this.buffer[n] = n2;
        ++this.elementsCount;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.elementsCount == 0;
        return bl;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public int lastIndexOf(int n) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (this.buffer[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public int remove(int n) {
        int[] nArray = this.buffer;
        int n2 = nArray[n];
        int n3 = n + 1;
        int n4 = this.elementsCount;
        if (n3 < n4) {
            System.arraycopy(nArray, n3, nArray, n, n4 - n - 1);
        }
        this.elementsCount = n = this.elementsCount - 1;
        this.buffer[n] = 0;
        return n2;
    }

    @Override
    public int removeAll(int n) {
        int n2;
        int n3 = 0;
        for (int i = 0; i < (n2 = this.elementsCount); ++i) {
            int[] nArray = this.buffer;
            if (nArray[i] == n) {
                nArray[i] = 0;
                continue;
            }
            if (n3 != i) {
                nArray[n3] = nArray[i];
                nArray[i] = 0;
            }
            ++n3;
        }
        this.elementsCount = n3;
        return n2 - n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n;
        int n2;
        int[] nArray = this.buffer;
        int n3 = this.elementsCount;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            n2 = ++n4;
            n = ++n5;
            if (n4 >= n3) break;
            try {
                if (intPredicate.apply(nArray[n4])) {
                    nArray[n4] = 0;
                    continue;
                }
                if (n5 == n4) continue;
            }
            catch (Throwable throwable) {
                while (true) {
                    if (n4 >= n3) {
                        this.elementsCount = n5;
                        throw throwable;
                    }
                    if (n5 != n4) {
                        nArray[n5] = nArray[n4];
                        nArray[n4] = 0;
                    }
                    ++n5;
                    ++n4;
                }
            }
            nArray[n5] = nArray[n4];
            nArray[n4] = 0;
        }
        while (true) {
            if (n2 >= n3) {
                this.elementsCount = n;
                return n3 - n;
            }
            if (n != n2) {
                nArray[n] = nArray[n2];
                nArray[n2] = 0;
            }
            ++n;
            ++n2;
        }
    }

    @Override
    public int removeFirst(int n) {
        if ((n = this.indexOf(n)) >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public int removeLast(int n) {
        if ((n = this.lastIndexOf(n)) >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public void removeRange(int n, int n2) {
        int[] nArray = this.buffer;
        System.arraycopy(nArray, n2, nArray, n, this.elementsCount - n2);
        n2 -= n;
        this.elementsCount = n = this.elementsCount - n2;
        Arrays.fill(this.buffer, n, n2 + n, 0);
    }

    public void resize(int n) {
        int[] nArray = this.buffer;
        if (n <= nArray.length) {
            int n2 = this.elementsCount;
            if (n < n2) {
                Arrays.fill(nArray, n, n2, 0);
            } else {
                Arrays.fill(nArray, n2, n, 0);
            }
        } else {
            this.ensureCapacity(n);
        }
        this.elementsCount = n;
    }

    @Override
    public int set(int n, int n2) {
        int[] nArray = this.buffer;
        int n3 = nArray[n];
        nArray[n] = n2;
        return n3;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    static final class ValueIterator
    extends AbstractIterator<IntCursor> {
        private final int[] buffer;
        private final IntCursor cursor;
        private final int size;

        public ValueIterator(int[] nArray, int n) {
            IntCursor intCursor;
            this.cursor = intCursor = new IntCursor();
            intCursor.index = -1;
            this.size = n;
            this.buffer = nArray;
        }

        @Override
        protected IntCursor fetch() {
            int n;
            if (this.cursor.index + 1 == this.size) {
                return (IntCursor)this.done();
            }
            IntCursor intCursor = this.cursor;
            int[] nArray = this.buffer;
            intCursor.index = n = intCursor.index + 1;
            intCursor.value = nArray[n];
            return this.cursor;
        }
    }
}

