/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntByteAssociativeContainer;
import com.carrotsearch.hppc.IntByteMap;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.IntByteCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.IntBytePredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.IntByteProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntByteHashMap
implements IntByteMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public int[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public byte[] values;

    public IntByteHashMap() {
        this(4);
    }

    public IntByteHashMap(int n) {
        this(n, 0.75);
    }

    public IntByteHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public IntByteHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public IntByteHashMap(IntByteAssociativeContainer intByteAssociativeContainer) {
        this(intByteAssociativeContainer.size());
        this.putAll(intByteAssociativeContainer);
    }

    public static IntByteHashMap from(int[] nArray, byte[] byArray) {
        if (nArray.length == byArray.length) {
            IntByteHashMap intByteHashMap = new IntByteHashMap(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                intByteHashMap.put(nArray[i], byArray[i]);
            }
            return intByteHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public byte addTo(int n, byte by) {
        return this.putOrAdd(n, by, by);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        int[] nArray = this.keys;
        byte[] byArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new int[n3];
            this.values = new byte[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = nArray;
            this.values = byArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, int n2, byte by) {
        int[] nArray = this.keys;
        byte[] byArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        nArray[n] = n2;
        byArray[n] = by;
        this.rehash(nArray, byArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public IntByteHashMap clone() {
        try {
            IntByteHashMap intByteHashMap = (IntByteHashMap)super.clone();
            intByteHashMap.keys = (int[])this.keys.clone();
            intByteHashMap.values = (byte[])this.values.clone();
            intByteHashMap.hasEmptyKey = intByteHashMap.hasEmptyKey;
            intByteHashMap.orderMixer = this.orderMixer.clone();
            return intByteHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(int n) {
        int n2;
        if (n == 0) {
            return this.hasEmptyKey;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            int[] nArray = this.keys;
            byte[] byArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (nArray != null && !this.isEmpty()) {
                this.rehash(nArray, byArray);
            }
        }
    }

    protected boolean equalElements(IntByteHashMap object) {
        if (((IntByteHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((IntByteHashMap)object).iterator();
        while (object.hasNext()) {
            IntByteCursor intByteCursor = (IntByteCursor)object.next();
            int n = intByteCursor.key;
            if (this.containsKey(n) && this.get(n) == intByteCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntByteHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntBytePredicate> T forEach(T t) {
        int[] nArray = this.keys;
        byte[] byArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply(0, byArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (nArray[i] == 0 || t.apply(nArray[i], byArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends IntByteProcedure> T forEach(T t) {
        int[] nArray = this.keys;
        byte[] byArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply(0, byArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (nArray[n] != 0) {
                t.apply(nArray[n], byArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public byte get(int n) {
        int n2;
        int n3 = 0;
        if (n == 0) {
            int n4 = n3;
            if (this.hasEmptyKey) {
                n4 = n = this.values[this.mask + 1];
            }
            return (byte)n4;
        }
        int[] nArray = this.keys;
        int n5 = this.mask;
        n3 = this.hashKey(n);
        while ((n2 = nArray[n3 &= n5]) != 0) {
            if (n2 == n) {
                return this.values[n3];
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(int n, byte by) {
        int n2;
        if (n == 0) {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
                by = (byte)n;
            }
            return by;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return this.values[n4];
            }
            ++n4;
        }
        return by;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (IntByteCursor intByteCursor : this) {
            n += BitMixer.mix(intByteCursor.key) + BitMixer.mix(intByteCursor.value);
        }
        return n;
    }

    protected int hashKey(int n) {
        return BitMixer.mix(n, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public byte indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, int n2, byte by) {
        if (n2 == 0) {
            this.values[n] = by;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, n2, by);
            } else {
                this.keys[n] = n2;
                this.values[n] = by;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            n = n3 + 1;
            if (!bl) {
                // empty if block
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return n2;
            }
            n4 = n2 + 1;
        }
        return n2;
    }

    @Override
    public byte indexReplace(int n, byte by) {
        byte[] byArray = this.values;
        byte by2 = byArray[n];
        byArray[n] = by;
        return by2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public byte put(int n, byte by) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = true;
            byte[] byArray = this.values;
            n = n3 + 1;
            byte by2 = byArray[n];
            byArray[n] = by;
            return by2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = objectArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                objectArray = this.values;
                byte by3 = objectArray[n4];
                objectArray[n4] = by;
                return by3;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, n, by);
        } else {
            objectArray[n4] = n;
            this.values[n4] = by;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(IntByteAssociativeContainer object) {
        int n = this.size();
        Iterator<IntByteCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((IntByteCursor)object).key, ((IntByteCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends IntByteCursor> object) {
        int n = this.size();
        Iterator<? extends IntByteCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((IntByteCursor)object).key, ((IntByteCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(int n, byte by) {
        int n2 = this.indexOf(n);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, n, by);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(int n, byte by, byte by2) {
        int n2 = this.indexOf(n);
        if (this.indexExists(n2)) {
            by = (byte)(this.values[n2] + by2);
            this.indexReplace(n2, by);
        } else {
            this.indexInsert(n2, n, by);
        }
        return by;
    }

    protected void rehash(int[] nArray, byte[] byArray) {
        int n;
        int[] nArray2 = this.keys;
        byte[] byArray2 = this.values;
        int n2 = this.mask;
        int n3 = nArray.length - 1;
        nArray2[nArray2.length - 1] = nArray[n3];
        byArray2[byArray2.length - 1] = byArray[n3];
        while ((n = n3 - 1) >= 0) {
            int n4 = nArray[n];
            n3 = n;
            if (n4 == 0) continue;
            n3 = this.hashKey(n4);
            while (nArray2[n3 &= n2] != 0) {
                ++n3;
            }
            nArray2[n3] = n4;
            byArray2[n3] = byArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public byte remove(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = false;
            byte[] byArray = this.values;
            n = n3 + 1;
            byte by = byArray[n];
            byArray[n] = (byte)0;
            return by;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                byte by = this.values[n2];
                this.shiftConflictingKeys(n2);
                return by;
            }
            n4 = n2 + 1;
        }
        return 0;
    }

    @Override
    public int removeAll(IntContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof IntLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (byte)0;
            }
            int[] nArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                int n4 = nArray[n2];
                if (n4 != 0 && object.contains(n4)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((IntCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntBytePredicate intBytePredicate) {
        int n;
        byte[] byArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && intBytePredicate.apply(0, (byArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (byte)0;
        }
        int[] nArray = this.keys;
        byArray = this.values;
        while (n4 <= n3) {
            n = nArray[n4];
            if (n != 0 && intBytePredicate.apply(n, byArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && intPredicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (byte)0;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            int n4 = nArray[n2];
            if (n4 != 0 && intPredicate.apply(n4)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        int[] nArray = this.keys;
        byte[] byArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            do {
                if ((n4 = nArray[n5 = n + (n3 = n6 + 1) & n2]) == 0) {
                    nArray[n] = 0;
                    byArray[n] = (byte)0;
                    --this.assigned;
                    return;
                }
                n6 = n3;
            } while ((n5 - this.hashKey(n4) & n2) < n3);
            nArray[n] = n4;
            byArray[n] = byArray[n5];
            n = n5;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<IntByteCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            IntByteCursor intByteCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(intByteCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(intByteCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<IntByteCursor> {
        private final IntByteCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntByteCursor();
        }

        @Override
        protected IntByteCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntByteHashMap.this.keys;
                    n = this.slot;
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        this.cursor.index = n;
                        this.cursor.key = n2;
                        this.cursor.value = IntByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntByteCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntByteHashMap owner;

        public KeysContainer() {
            this.owner = IntByteHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            return this.owner.containsKey(n);
        }

        @Override
        public <T extends IntPredicate> T forEach(final T t) {
            this.owner.forEach(new IntBytePredicate(){

                @Override
                public boolean apply(int n, byte by) {
                    return t.apply(n);
                }
            });
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(final T t) {
            this.owner.forEach(new IntByteProcedure(){

                @Override
                public void apply(int n, byte by) {
                    t.apply(n);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(int n) {
            if (this.owner.containsKey(n)) {
                this.owner.remove(n);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(IntPredicate intPredicate) {
            return this.owner.removeAll(intPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntByteHashMap.this.keys;
                    n = this.slot;
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        this.cursor.index = n;
                        this.cursor.value = n2;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final IntByteHashMap owner;

        private ValuesContainer() {
            this.owner = IntByteHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(byte by) {
            Iterator<IntByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != by) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends BytePredicate> T forEach(T t) {
            Iterator<IntByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T t) {
            Iterator<IntByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final byte by) {
            return this.owner.removeAll(new IntBytePredicate(){

                @Override
                public boolean apply(int n, byte by2) {
                    boolean bl = by2 == by;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final BytePredicate bytePredicate) {
            return this.owner.removeAll(new IntBytePredicate(){

                @Override
                public boolean apply(int n, byte by) {
                    return bytePredicate.apply(by);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntByteHashMap.this.keys;
                    n = this.slot;
                    if (nArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = IntByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }
}

