/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntCharAssociativeContainer;
import com.carrotsearch.hppc.IntCharMap;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.IntCharCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.IntCharPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.IntCharProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntCharHashMap
implements IntCharMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public int[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public char[] values;

    public IntCharHashMap() {
        this(4);
    }

    public IntCharHashMap(int n) {
        this(n, 0.75);
    }

    public IntCharHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public IntCharHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public IntCharHashMap(IntCharAssociativeContainer intCharAssociativeContainer) {
        this(intCharAssociativeContainer.size());
        this.putAll(intCharAssociativeContainer);
    }

    public static IntCharHashMap from(int[] nArray, char[] cArray) {
        if (nArray.length == cArray.length) {
            IntCharHashMap intCharHashMap = new IntCharHashMap(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                intCharHashMap.put(nArray[i], cArray[i]);
            }
            return intCharHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public char addTo(int n, char c) {
        return this.putOrAdd(n, c, c);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        int[] nArray = this.keys;
        char[] cArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new int[n3];
            this.values = new char[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = nArray;
            this.values = cArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, int n2, char c) {
        int[] nArray = this.keys;
        char[] cArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        nArray[n] = n2;
        cArray[n] = c;
        this.rehash(nArray, cArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public IntCharHashMap clone() {
        try {
            IntCharHashMap intCharHashMap = (IntCharHashMap)super.clone();
            intCharHashMap.keys = (int[])this.keys.clone();
            intCharHashMap.values = (char[])this.values.clone();
            intCharHashMap.hasEmptyKey = intCharHashMap.hasEmptyKey;
            intCharHashMap.orderMixer = this.orderMixer.clone();
            return intCharHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(int n) {
        int n2;
        if (n == 0) {
            return this.hasEmptyKey;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return true;
            }
            n4 = n2 + 1;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            int[] nArray = this.keys;
            char[] cArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (nArray != null && !this.isEmpty()) {
                this.rehash(nArray, cArray);
            }
        }
    }

    protected boolean equalElements(IntCharHashMap object) {
        if (((IntCharHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<IntCharCursor> iterator = ((IntCharHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            int n = ((IntCharCursor)object).key;
            if (this.containsKey(n) && this.get(n) == ((IntCharCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntCharHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntCharPredicate> T forEach(T t) {
        int[] nArray = this.keys;
        char[] cArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply(0, cArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (nArray[i] == 0 || t.apply(nArray[i], cArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends IntCharProcedure> T forEach(T t) {
        int[] nArray = this.keys;
        char[] cArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply(0, cArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (nArray[n] != 0) {
                t.apply(nArray[n], cArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public char get(int n) {
        int n2;
        int n3 = 0;
        if (n == 0) {
            int n4 = n3;
            if (this.hasEmptyKey) {
                n4 = n = this.values[this.mask + 1];
            }
            return (char)n4;
        }
        int[] nArray = this.keys;
        int n5 = this.mask;
        n3 = this.hashKey(n);
        while ((n3 = nArray[n2 = n3 & n5]) != 0) {
            if (n3 == n) {
                return this.values[n2];
            }
            n3 = n2 + 1;
        }
        return '\u0000';
    }

    @Override
    public char getOrDefault(int n, char c) {
        int n2;
        if (n == 0) {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
                c = (char)n;
            }
            return c;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return this.values[n2];
            }
            n4 = n2 + 1;
        }
        return c;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (IntCharCursor intCharCursor : this) {
            n += BitMixer.mix(intCharCursor.key) + BitMixer.mix(intCharCursor.value);
        }
        return n;
    }

    protected int hashKey(int n) {
        return BitMixer.mix(n, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public char indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, int n2, char c) {
        if (n2 == 0) {
            this.values[n] = c;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, n2, c);
            } else {
                this.keys[n] = n2;
                this.values[n] = c;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            n = n3 + 1;
            if (!bl) {
                // empty if block
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return n4;
            }
            ++n4;
        }
        return n4;
    }

    @Override
    public char indexReplace(int n, char c) {
        char[] cArray = this.values;
        char c2 = cArray[n];
        cArray[n] = c;
        return c2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntCharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public char put(int n, char c) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = true;
            char[] cArray = this.values;
            n = n3 + 1;
            char c2 = cArray[n];
            cArray[n] = c;
            return c2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = objectArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                objectArray = this.values;
                char c3 = objectArray[n4];
                objectArray[n4] = c;
                return c3;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, n, c);
        } else {
            objectArray[n4] = n;
            this.values[n4] = c;
        }
        ++this.assigned;
        return '\u0000';
    }

    @Override
    public int putAll(IntCharAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntCharCursor intCharCursor = (IntCharCursor)object.next();
            this.put(intCharCursor.key, intCharCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends IntCharCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntCharCursor intCharCursor = (IntCharCursor)object.next();
            this.put(intCharCursor.key, intCharCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(int n, char c) {
        int n2 = this.indexOf(n);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, n, c);
            return true;
        }
        return false;
    }

    @Override
    public char putOrAdd(int n, char c, char c2) {
        int n2 = this.indexOf(n);
        if (this.indexExists(n2)) {
            c = (char)(this.values[n2] + c2);
            this.indexReplace(n2, c);
        } else {
            this.indexInsert(n2, n, c);
        }
        return c;
    }

    protected void rehash(int[] nArray, char[] cArray) {
        int n;
        int[] nArray2 = this.keys;
        char[] cArray2 = this.values;
        int n2 = this.mask;
        int n3 = nArray.length - 1;
        nArray2[nArray2.length - 1] = nArray[n3];
        cArray2[cArray2.length - 1] = cArray[n3];
        while ((n = n3 - 1) >= 0) {
            int n4 = nArray[n];
            n3 = n;
            if (n4 == 0) continue;
            n3 = this.hashKey(n4);
            while (nArray2[n3 &= n2] != 0) {
                ++n3;
            }
            nArray2[n3] = n4;
            cArray2[n3] = cArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public char remove(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = false;
            char[] cArray = this.values;
            n = n3 + 1;
            char c = cArray[n];
            cArray[n] = (char)0;
            return c;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                char c = this.values[n4];
                this.shiftConflictingKeys(n4);
                return c;
            }
            ++n4;
        }
        return '\u0000';
    }

    @Override
    public int removeAll(IntContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof IntLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (char)0;
            }
            int[] nArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                int n4 = nArray[n2];
                if (n4 != 0 && object.contains(n4)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((IntCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntCharPredicate intCharPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && intCharPredicate.apply(0, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (char)0;
        }
        objectArray = this.keys;
        char[] cArray = this.values;
        while (n4 <= n3) {
            n = objectArray[n4];
            if (n != 0 && intCharPredicate.apply(n, cArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && intPredicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (char)0;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            int n4 = nArray[n2];
            if (n4 != 0 && intPredicate.apply(n4)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        int[] nArray = this.keys;
        char[] cArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            do {
                if ((n4 = nArray[n5 = n + (n3 = n6 + 1) & n2]) == 0) {
                    nArray[n] = 0;
                    cArray[n] = (char)0;
                    --this.assigned;
                    return;
                }
                n6 = n3;
            } while ((n5 - this.hashKey(n4) & n2) < n3);
            nArray[n] = n4;
            cArray[n] = cArray[n5];
            n = n5;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<IntCharCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            IntCharCursor intCharCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(intCharCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(intCharCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public CharCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<IntCharCursor> {
        private final IntCharCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCharCursor();
        }

        @Override
        protected IntCharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntCharHashMap.this.keys;
                    int n2 = this.slot;
                    n = nArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = n;
                        this.cursor.value = IntCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && IntCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntCharCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntCharHashMap owner;

        public KeysContainer() {
            this.owner = IntCharHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            return this.owner.containsKey(n);
        }

        @Override
        public <T extends IntPredicate> T forEach(final T t) {
            this.owner.forEach(new IntCharPredicate(){

                @Override
                public boolean apply(int n, char c) {
                    return t.apply(n);
                }
            });
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(final T t) {
            this.owner.forEach(new IntCharProcedure(){

                @Override
                public void apply(int n, char c) {
                    t.apply(n);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(int n) {
            if (this.owner.containsKey(n)) {
                this.owner.remove(n);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(IntPredicate intPredicate) {
            return this.owner.removeAll(intPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntCharHashMap.this.keys;
                    n = this.slot;
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        this.cursor.index = n;
                        this.cursor.value = n2;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final IntCharHashMap owner;

        private ValuesContainer() {
            this.owner = IntCharHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            Iterator<IntCharCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != c) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharPredicate> T forEach(T t) {
            Iterator<IntCharCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(T t) {
            Iterator<IntCharCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final char c) {
            return this.owner.removeAll(new IntCharPredicate(){

                @Override
                public boolean apply(int n, char c2) {
                    boolean bl = c2 == c;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final CharPredicate charPredicate) {
            return this.owner.removeAll(new IntCharPredicate(){

                @Override
                public boolean apply(int n, char c) {
                    return charPredicate.apply(c);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntCharHashMap.this.keys;
                    n = this.slot;
                    if (nArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = IntCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

