/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.DoubleCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntDoubleAssociativeContainer;
import com.carrotsearch.hppc.IntDoubleMap;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntDoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.IntDoublePredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.IntDoubleProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntDoubleHashMap
implements IntDoubleMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public int[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public double[] values;

    public IntDoubleHashMap() {
        this(4);
    }

    public IntDoubleHashMap(int n) {
        this(n, 0.75);
    }

    public IntDoubleHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public IntDoubleHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public IntDoubleHashMap(IntDoubleAssociativeContainer intDoubleAssociativeContainer) {
        this(intDoubleAssociativeContainer.size());
        this.putAll(intDoubleAssociativeContainer);
    }

    public static IntDoubleHashMap from(int[] nArray, double[] dArray) {
        if (nArray.length == dArray.length) {
            IntDoubleHashMap intDoubleHashMap = new IntDoubleHashMap(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                intDoubleHashMap.put(nArray[i], dArray[i]);
            }
            return intDoubleHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public double addTo(int n, double d) {
        return this.putOrAdd(n, d, d);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        int[] nArray = this.keys;
        double[] dArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new int[n3];
            this.values = new double[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = nArray;
            this.values = dArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, int n2, double d) {
        int[] nArray = this.keys;
        double[] dArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        nArray[n] = n2;
        dArray[n] = d;
        this.rehash(nArray, dArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public IntDoubleHashMap clone() {
        try {
            IntDoubleHashMap intDoubleHashMap = (IntDoubleHashMap)super.clone();
            intDoubleHashMap.keys = (int[])this.keys.clone();
            intDoubleHashMap.values = (double[])this.values.clone();
            intDoubleHashMap.hasEmptyKey = intDoubleHashMap.hasEmptyKey;
            intDoubleHashMap.orderMixer = this.orderMixer.clone();
            return intDoubleHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(int n) {
        int n2;
        if (n == 0) {
            return this.hasEmptyKey;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return true;
            }
            n4 = n2 + 1;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            int[] nArray = this.keys;
            double[] dArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (nArray != null && !this.isEmpty()) {
                this.rehash(nArray, dArray);
            }
        }
    }

    protected boolean equalElements(IntDoubleHashMap object) {
        if (((IntDoubleHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((IntDoubleHashMap)object).iterator();
        while (object.hasNext()) {
            IntDoubleCursor intDoubleCursor = (IntDoubleCursor)object.next();
            int n = intDoubleCursor.key;
            if (this.containsKey(n) && Double.doubleToLongBits(this.get(n)) == Double.doubleToLongBits(intDoubleCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntDoubleHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntDoublePredicate> T forEach(T t) {
        int[] nArray = this.keys;
        double[] dArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply(0, dArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (nArray[i] == 0 || t.apply(nArray[i], dArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends IntDoubleProcedure> T forEach(T t) {
        int[] nArray = this.keys;
        double[] dArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply(0, dArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (nArray[n] != 0) {
                t.apply(nArray[n], dArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public double get(int n) {
        int n2;
        double d = 0.0;
        if (n == 0) {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return this.values[n4];
            }
            ++n4;
        }
        return 0.0;
    }

    @Override
    public double getOrDefault(int n, double d) {
        int n2;
        if (n == 0) {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return this.values[n4];
            }
            ++n4;
        }
        return d;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (IntDoubleCursor intDoubleCursor : this) {
            n += BitMixer.mix(intDoubleCursor.key) + BitMixer.mix(intDoubleCursor.value);
        }
        return n;
    }

    protected int hashKey(int n) {
        return BitMixer.mix(n, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public double indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, int n2, double d) {
        if (n2 == 0) {
            this.values[n] = d;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, n2, d);
            } else {
                this.keys[n] = n2;
                this.values[n] = d;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            n = n3 + 1;
            if (!bl) {
                // empty if block
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return n2;
            }
            n4 = n2 + 1;
        }
        return n2;
    }

    @Override
    public double indexReplace(int n, double d) {
        double[] dArray = this.values;
        double d2 = dArray[n];
        dArray[n] = d;
        return d2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntDoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public double put(int n, double d) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = true;
            double[] dArray = this.values;
            n = n3 + 1;
            double d2 = dArray[n];
            dArray[n] = d;
            return d2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = objectArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                objectArray = this.values;
                int n5 = objectArray[n4];
                objectArray[n4] = (int)d;
                return n5;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, n, d);
        } else {
            objectArray[n4] = n;
            this.values[n4] = d;
        }
        ++this.assigned;
        return 0.0;
    }

    @Override
    public int putAll(IntDoubleAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntDoubleCursor intDoubleCursor = (IntDoubleCursor)object.next();
            this.put(intDoubleCursor.key, intDoubleCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends IntDoubleCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntDoubleCursor intDoubleCursor = (IntDoubleCursor)object.next();
            this.put(intDoubleCursor.key, intDoubleCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(int n, double d) {
        int n2 = this.indexOf(n);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, n, d);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(int n, double d, double d2) {
        int n2 = this.indexOf(n);
        if (this.indexExists(n2)) {
            d = this.values[n2] + d2;
            this.indexReplace(n2, d);
        } else {
            this.indexInsert(n2, n, d);
        }
        return d;
    }

    protected void rehash(int[] nArray, double[] dArray) {
        int n;
        int[] nArray2 = this.keys;
        double[] dArray2 = this.values;
        int n2 = this.mask;
        int n3 = nArray.length - 1;
        nArray2[nArray2.length - 1] = nArray[n3];
        dArray2[dArray2.length - 1] = dArray[n3];
        while ((n = n3 - 1) >= 0) {
            int n4 = nArray[n];
            n3 = n;
            if (n4 == 0) continue;
            n3 = this.hashKey(n4);
            while (nArray2[n3 &= n2] != 0) {
                ++n3;
            }
            nArray2[n3] = n4;
            dArray2[n3] = dArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public double remove(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = false;
            double[] dArray = this.values;
            n = n3 + 1;
            double d = dArray[n];
            dArray[n] = 0.0;
            return d;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                double d = this.values[n2];
                this.shiftConflictingKeys(n2);
                return d;
            }
            n4 = n2 + 1;
        }
        return 0.0;
    }

    @Override
    public int removeAll(IntContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof IntLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0;
            }
            int[] nArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                int n4 = nArray[n2];
                if (n4 != 0 && object.contains(n4)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((IntCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntDoublePredicate intDoublePredicate) {
        int n;
        double[] dArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && intDoublePredicate.apply(0, (dArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0;
        }
        int[] nArray = this.keys;
        dArray = this.values;
        while (n4 <= n3) {
            n = nArray[n4];
            if (n != 0 && intDoublePredicate.apply(n, dArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && intPredicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            int n4 = nArray[n2];
            if (n4 != 0 && intPredicate.apply(n4)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        int[] nArray = this.keys;
        double[] dArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            do {
                if ((n4 = nArray[n5 = n + (n3 = n6 + 1) & n2]) == 0) {
                    nArray[n] = 0;
                    dArray[n] = 0.0;
                    --this.assigned;
                    return;
                }
                n6 = n3;
            } while ((n5 - this.hashKey(n4) & n2) < n3);
            nArray[n] = n4;
            dArray[n] = dArray[n5];
            n = n5;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<IntDoubleCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            IntDoubleCursor intDoubleCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(intDoubleCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(intDoubleCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public DoubleCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<IntDoubleCursor> {
        private final IntDoubleCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntDoubleCursor();
        }

        @Override
        protected IntDoubleCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntDoubleHashMap.this.keys;
                    int n2 = this.slot;
                    n = nArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = n;
                        this.cursor.value = IntDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && IntDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntDoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntDoubleHashMap owner;

        public KeysContainer() {
            this.owner = IntDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            return this.owner.containsKey(n);
        }

        @Override
        public <T extends IntPredicate> T forEach(final T t) {
            this.owner.forEach(new IntDoublePredicate(){

                @Override
                public boolean apply(int n, double d) {
                    return t.apply(n);
                }
            });
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(final T t) {
            this.owner.forEach(new IntDoubleProcedure(){

                @Override
                public void apply(int n, double d) {
                    t.apply(n);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(int n) {
            if (this.owner.containsKey(n)) {
                this.owner.remove(n);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(IntPredicate intPredicate) {
            return this.owner.removeAll(intPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntDoubleHashMap.this.keys;
                    int n2 = this.slot;
                    n = nArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.value = n;
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && IntDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final IntDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = IntDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(double d) {
            Iterator<IntDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Double.doubleToLongBits(iterator.next().value) != Double.doubleToLongBits(d)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T t) {
            Iterator<IntDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T t) {
            Iterator<IntDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final double d) {
            return this.owner.removeAll(new IntDoublePredicate(){

                @Override
                public boolean apply(int n, double d2) {
                    boolean bl = Double.doubleToLongBits(d2) == Double.doubleToLongBits(d);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final DoublePredicate doublePredicate) {
            return this.owner.removeAll(new IntDoublePredicate(){

                @Override
                public boolean apply(int n, double d) {
                    return doublePredicate.apply(d);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntDoubleHashMap.this.keys;
                    n = this.slot;
                    if (nArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = IntDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }
}

