/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntFloatAssociativeContainer;
import com.carrotsearch.hppc.IntFloatMap;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.IntFloatPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.IntFloatProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntFloatHashMap
implements IntFloatMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public int[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public float[] values;

    public IntFloatHashMap() {
        this(4);
    }

    public IntFloatHashMap(int n) {
        this(n, 0.75);
    }

    public IntFloatHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public IntFloatHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public IntFloatHashMap(IntFloatAssociativeContainer intFloatAssociativeContainer) {
        this(intFloatAssociativeContainer.size());
        this.putAll(intFloatAssociativeContainer);
    }

    public static IntFloatHashMap from(int[] nArray, float[] fArray) {
        if (nArray.length == fArray.length) {
            IntFloatHashMap intFloatHashMap = new IntFloatHashMap(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                intFloatHashMap.put(nArray[i], fArray[i]);
            }
            return intFloatHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public float addTo(int n, float f) {
        return this.putOrAdd(n, f, f);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        int[] nArray = this.keys;
        float[] fArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new int[n3];
            this.values = new float[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = nArray;
            this.values = fArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, int n2, float f) {
        int[] nArray = this.keys;
        float[] fArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        nArray[n] = n2;
        fArray[n] = f;
        this.rehash(nArray, fArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public IntFloatHashMap clone() {
        try {
            IntFloatHashMap intFloatHashMap = (IntFloatHashMap)super.clone();
            intFloatHashMap.keys = (int[])this.keys.clone();
            intFloatHashMap.values = (float[])this.values.clone();
            intFloatHashMap.hasEmptyKey = intFloatHashMap.hasEmptyKey;
            intFloatHashMap.orderMixer = this.orderMixer.clone();
            return intFloatHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(int n) {
        int n2;
        if (n == 0) {
            return this.hasEmptyKey;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            int[] nArray = this.keys;
            float[] fArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (nArray != null && !this.isEmpty()) {
                this.rehash(nArray, fArray);
            }
        }
    }

    protected boolean equalElements(IntFloatHashMap object) {
        if (((IntFloatHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<IntFloatCursor> iterator = ((IntFloatHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            int n = ((IntFloatCursor)object).key;
            if (this.containsKey(n) && Float.floatToIntBits(this.get(n)) == Float.floatToIntBits(((IntFloatCursor)object).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntFloatHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntFloatPredicate> T forEach(T t) {
        int[] nArray = this.keys;
        float[] fArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply(0, fArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (nArray[i] == 0 || t.apply(nArray[i], fArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends IntFloatProcedure> T forEach(T t) {
        int[] nArray = this.keys;
        float[] fArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply(0, fArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (nArray[n] != 0) {
                t.apply(nArray[n], fArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public float get(int n) {
        int n2;
        float f = 0.0f;
        if (n == 0) {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return this.values[n4];
            }
            ++n4;
        }
        return 0.0f;
    }

    @Override
    public float getOrDefault(int n, float f) {
        int n2;
        if (n == 0) {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return this.values[n2];
            }
            n4 = n2 + 1;
        }
        return f;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (IntFloatCursor intFloatCursor : this) {
            n += BitMixer.mix(intFloatCursor.key) + BitMixer.mix(intFloatCursor.value);
        }
        return n;
    }

    protected int hashKey(int n) {
        return BitMixer.mix(n, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public float indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, int n2, float f) {
        if (n2 == 0) {
            this.values[n] = f;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, n2, f);
            } else {
                this.keys[n] = n2;
                this.values[n] = f;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            n = n3 + 1;
            if (!bl) {
                // empty if block
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return n2;
            }
            n4 = n2 + 1;
        }
        return n2;
    }

    @Override
    public float indexReplace(int n, float f) {
        float[] fArray = this.values;
        float f2 = fArray[n];
        fArray[n] = f;
        return f2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntFloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public float put(int n, float f) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = true;
            float[] fArray = this.values;
            n = n3 + 1;
            float f2 = fArray[n];
            fArray[n] = f;
            return f2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n4 = objectArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                objectArray = this.values;
                int n5 = objectArray[n2];
                objectArray[n2] = (int)f;
                return n5;
            }
            n4 = n2 + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n2, n, f);
        } else {
            objectArray[n2] = n;
            this.values[n2] = f;
        }
        ++this.assigned;
        return 0.0f;
    }

    @Override
    public int putAll(IntFloatAssociativeContainer object) {
        int n = this.size();
        Iterator<IntFloatCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((IntFloatCursor)object).key, ((IntFloatCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends IntFloatCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntFloatCursor intFloatCursor = (IntFloatCursor)object.next();
            this.put(intFloatCursor.key, intFloatCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(int n, float f) {
        int n2 = this.indexOf(n);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, n, f);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(int n, float f, float f2) {
        int n2 = this.indexOf(n);
        if (this.indexExists(n2)) {
            f = this.values[n2] + f2;
            this.indexReplace(n2, f);
        } else {
            this.indexInsert(n2, n, f);
        }
        return f;
    }

    protected void rehash(int[] nArray, float[] fArray) {
        int n;
        int[] nArray2 = this.keys;
        float[] fArray2 = this.values;
        int n2 = this.mask;
        int n3 = nArray.length - 1;
        nArray2[nArray2.length - 1] = nArray[n3];
        fArray2[fArray2.length - 1] = fArray[n3];
        while ((n = n3 - 1) >= 0) {
            int n4 = nArray[n];
            n3 = n;
            if (n4 == 0) continue;
            n3 = this.hashKey(n4);
            while (nArray2[n3 &= n2] != 0) {
                ++n3;
            }
            nArray2[n3] = n4;
            fArray2[n3] = fArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public float remove(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = false;
            float[] fArray = this.values;
            n = n3 + 1;
            float f = fArray[n];
            fArray[n] = 0.0f;
            return f;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                float f = this.values[n4];
                this.shiftConflictingKeys(n4);
                return f;
            }
            ++n4;
        }
        return 0.0f;
    }

    @Override
    public int removeAll(IntContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof IntLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0f;
            }
            int[] nArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                int n4 = nArray[n2];
                if (n4 != 0 && object.contains(n4)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((IntCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntFloatPredicate intFloatPredicate) {
        int n;
        float[] fArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && intFloatPredicate.apply(0, (fArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0f;
        }
        int[] nArray = this.keys;
        fArray = this.values;
        while (n4 <= n3) {
            n = nArray[n4];
            if (n != 0 && intFloatPredicate.apply(n, fArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && intPredicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0f;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            int n4 = nArray[n2];
            if (n4 != 0 && intPredicate.apply(n4)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        int[] nArray = this.keys;
        float[] fArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            do {
                if ((n4 = nArray[n5 = n + (n3 = n6 + 1) & n2]) == 0) {
                    nArray[n] = 0;
                    fArray[n] = 0.0f;
                    --this.assigned;
                    return;
                }
                n6 = n3;
            } while ((n5 - this.hashKey(n4) & n2) < n3);
            nArray[n] = n4;
            fArray[n] = fArray[n5];
            n = n5;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<IntFloatCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            IntFloatCursor intFloatCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(intFloatCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(intFloatCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public FloatCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<IntFloatCursor> {
        private final IntFloatCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntFloatCursor();
        }

        @Override
        protected IntFloatCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntFloatHashMap.this.keys;
                    n = this.slot;
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        this.cursor.index = n;
                        this.cursor.key = n2;
                        this.cursor.value = IntFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntFloatCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntFloatHashMap owner;

        public KeysContainer() {
            this.owner = IntFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            return this.owner.containsKey(n);
        }

        @Override
        public <T extends IntPredicate> T forEach(final T t) {
            this.owner.forEach(new IntFloatPredicate(){

                @Override
                public boolean apply(int n, float f) {
                    return t.apply(n);
                }
            });
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(final T t) {
            this.owner.forEach(new IntFloatProcedure(){

                @Override
                public void apply(int n, float f) {
                    t.apply(n);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(int n) {
            if (this.owner.containsKey(n)) {
                this.owner.remove(n);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(IntPredicate intPredicate) {
            return this.owner.removeAll(intPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntFloatHashMap.this.keys;
                    n = this.slot;
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        this.cursor.index = n;
                        this.cursor.value = n2;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final IntFloatHashMap owner;

        private ValuesContainer() {
            this.owner = IntFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(float f) {
            Iterator<IntFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Float.floatToIntBits(iterator.next().value) != Float.floatToIntBits(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T t) {
            Iterator<IntFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T t) {
            Iterator<IntFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final float f) {
            return this.owner.removeAll(new IntFloatPredicate(){

                @Override
                public boolean apply(int n, float f2) {
                    boolean bl = Float.floatToIntBits(f2) == Float.floatToIntBits(f);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final FloatPredicate floatPredicate) {
            return this.owner.removeAll(new IntFloatPredicate(){

                @Override
                public boolean apply(int n, float f) {
                    return floatPredicate.apply(f);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new FloatCursor();
        }

        @Override
        protected FloatCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntFloatHashMap.this.keys;
                    n = this.slot;
                    if (nArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = IntFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }
}

