/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntHashSet
extends AbstractIntCollection
implements IntLookupContainer,
IntSet,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public int[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;

    public IntHashSet() {
        this(4, 0.75);
    }

    public IntHashSet(int n) {
        this(n, 0.75);
    }

    public IntHashSet(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public IntHashSet(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public IntHashSet(IntContainer intContainer) {
        this(intContainer.size());
        this.addAll(intContainer);
    }

    public static IntHashSet from(int ... nArray) {
        IntHashSet intHashSet = new IntHashSet(nArray.length);
        intHashSet.addAll(nArray);
        return intHashSet;
    }

    private boolean sameKeys(IntSet object) {
        if (object.size() != this.size()) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (this.contains(((IntCursor)object.next()).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(int n) {
        int n2;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = true;
            return bl ^ true;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return false;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, n);
        } else {
            nArray[n4] = n;
        }
        ++this.assigned;
        return true;
    }

    public int addAll(IntContainer intContainer) {
        this.ensureCapacity(intContainer.size());
        return this.addAll((Iterable<? extends IntCursor>)intContainer);
    }

    public int addAll(Iterable<? extends IntCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            if (!this.add(((IntCursor)object.next()).value)) continue;
            ++n;
        }
        return n;
    }

    public final int addAll(int ... nArray) {
        this.ensureCapacity(nArray.length);
        int n = nArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = n2;
            if (this.add(nArray[i])) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        int[] nArray = this.keys;
        try {
            this.keys = new int[n + 1];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = nArray;
            n2 = this.keys == null ? 0 : this.size();
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, int n2) {
        int[] nArray = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        nArray[n] = n2;
        this.rehash(nArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public IntHashSet clone() {
        try {
            IntHashSet intHashSet = (IntHashSet)super.clone();
            intHashSet.keys = (int[])this.keys.clone();
            intHashSet.hasEmptyKey = intHashSet.hasEmptyKey;
            intHashSet.orderMixer = this.orderMixer.clone();
            return intHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(int n) {
        int n2;
        if (n == 0) {
            return this.hasEmptyKey;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return true;
            }
            n4 = n2 + 1;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            int[] nArray = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (nArray != null && !this.isEmpty()) {
                this.rehash(nArray);
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.sameKeys((IntSet)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntPredicate> T forEach(T t) {
        int n;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply(0)) {
            return t;
        }
        int[] nArray = this.keys;
        int n2 = this.mask;
        for (int i = 0; i <= n2 && ((n = nArray[i]) == 0 || t.apply(n)); ++i) {
        }
        return t;
    }

    @Override
    public <T extends IntProcedure> T forEach(T t) {
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply(0);
        }
        int[] nArray = this.keys;
        int n2 = this.mask;
        while (n <= n2) {
            int n3 = nArray[n];
            if (n3 != 0) {
                t.apply(n3);
            }
            ++n;
        }
        return t;
    }

    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        int[] nArray = this.keys;
        for (int i = this.mask; i >= 0; --i) {
            int n2 = nArray[i];
            int n3 = n;
            if (n2 != 0) {
                n3 = n + BitMixer.mix(n2);
            }
            n = n3;
        }
        return n;
    }

    protected int hashKey(int n) {
        return BitMixer.mix(n, this.keyMixer);
    }

    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    public int indexGet(int n) {
        return this.keys[n];
    }

    public void indexInsert(int n, int n2) {
        if (n2 == 0) {
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, n2);
            } else {
                this.keys[n] = n2;
            }
            ++this.assigned;
        }
    }

    public int indexOf(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            n = n3 + 1;
            if (!bl) {
                // empty if block
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return n4;
            }
            ++n4;
        }
        return n4;
    }

    public int indexReplace(int n, int n2) {
        int[] nArray = this.keys;
        int n3 = nArray[n];
        nArray[n] = n2;
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new EntryIterator();
    }

    protected void rehash(int[] nArray) {
        int n;
        int[] nArray2 = this.keys;
        int n2 = this.mask;
        int n3 = nArray.length - 1;
        while ((n = n3 - 1) >= 0) {
            int n4 = nArray[n];
            n3 = n;
            if (n4 == 0) continue;
            n3 = this.hashKey(n4);
            while (nArray2[n3 &= n2] != 0) {
                ++n3;
            }
            nArray2[n3] = n4;
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    public boolean remove(int n) {
        int n2;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return bl;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                this.shiftConflictingKeys(n4);
                return true;
            }
            ++n4;
        }
        return false;
    }

    @Override
    public int removeAll(int n) {
        return this.remove(n) ? 1 : 0;
    }

    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && intPredicate.apply(0)) {
            this.hasEmptyKey = false;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            int n4 = nArray[n2];
            if (n4 != 0 && intPredicate.apply(n4)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        int[] nArray = this.keys;
        int n2 = this.mask;
        while (true) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            do {
                if ((n4 = nArray[n5 = n + (n3 = n6 + 1) & n2]) == 0) {
                    nArray[n] = 0;
                    --this.assigned;
                    return;
                }
                n6 = n3;
            } while ((n5 - this.hashKey(n4) & n2) < n3);
            nArray[n] = n4;
            n = n5;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    @Override
    public int[] toArray() {
        int n;
        int[] nArray = new int[this.size()];
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl) {
            nArray[0] = 0;
            n = 1;
        } else {
            n = 0;
        }
        int[] nArray2 = this.keys;
        int n3 = this.mask;
        int n4 = n;
        while (n2 <= n3) {
            int n5 = nArray2[n2];
            n = n4;
            if (n5 != 0) {
                nArray[n4] = n5;
                n = n4 + 1;
            }
            ++n2;
            n4 = n;
        }
        return nArray;
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    protected final class EntryIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntHashSet.this.keys;
                    int n2 = this.slot;
                    n = nArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.value = n;
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && IntHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

