/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntIntAssociativeContainer;
import com.carrotsearch.hppc.IntIntMap;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import com.carrotsearch.hppc.predicates.IntIntPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.IntIntProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntIntHashMap
implements IntIntMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public int[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public int[] values;

    public IntIntHashMap() {
        this(4);
    }

    public IntIntHashMap(int n) {
        this(n, 0.75);
    }

    public IntIntHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public IntIntHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public IntIntHashMap(IntIntAssociativeContainer intIntAssociativeContainer) {
        this(intIntAssociativeContainer.size());
        this.putAll(intIntAssociativeContainer);
    }

    public static IntIntHashMap from(int[] nArray, int[] nArray2) {
        if (nArray.length == nArray2.length) {
            IntIntHashMap intIntHashMap = new IntIntHashMap(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                intIntHashMap.put(nArray[i], nArray2[i]);
            }
            return intIntHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public int addTo(int n, int n2) {
        return this.putOrAdd(n, n2, n2);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        int n3 = n + 1;
        try {
            this.keys = new int[n3];
            this.values = new int[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = nArray;
            this.values = nArray2;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, int n2, int n3) {
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        nArray[n] = n2;
        nArray2[n] = n3;
        this.rehash(nArray, nArray2);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public IntIntHashMap clone() {
        try {
            IntIntHashMap intIntHashMap = (IntIntHashMap)super.clone();
            intIntHashMap.keys = (int[])this.keys.clone();
            intIntHashMap.values = (int[])this.values.clone();
            intIntHashMap.hasEmptyKey = intIntHashMap.hasEmptyKey;
            intIntHashMap.orderMixer = this.orderMixer.clone();
            return intIntHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(int n) {
        int n2;
        if (n == 0) {
            return this.hasEmptyKey;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            int[] nArray = this.keys;
            int[] nArray2 = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (nArray != null && !this.isEmpty()) {
                this.rehash(nArray, nArray2);
            }
        }
    }

    protected boolean equalElements(IntIntHashMap object) {
        if (((IntIntHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<IntIntCursor> iterator = ((IntIntHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            int n = ((IntIntCursor)object).key;
            if (this.containsKey(n) && this.get(n) == ((IntIntCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntIntHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntIntPredicate> T forEach(T t) {
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply(0, nArray2[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (nArray[i] == 0 || t.apply(nArray[i], nArray2[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends IntIntProcedure> T forEach(T t) {
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply(0, nArray2[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (nArray[n] != 0) {
                t.apply(nArray[n], nArray2[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public int get(int n) {
        int n2;
        int n3 = 0;
        if (n == 0) {
            n = n3;
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.mask;
        n3 = this.hashKey(n);
        while ((n2 = nArray[n3 &= n4]) != 0) {
            if (n2 == n) {
                return this.values[n3];
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int getOrDefault(int n, int n2) {
        int n3;
        if (n == 0) {
            if (this.hasEmptyKey) {
                n2 = this.values[this.mask + 1];
            }
            return n2;
        }
        int[] nArray = this.keys;
        int n4 = this.mask;
        int n5 = this.hashKey(n);
        while ((n5 = nArray[n3 = n5 & n4]) != 0) {
            if (n5 == n) {
                return this.values[n3];
            }
            n5 = n3 + 1;
        }
        return n2;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (IntIntCursor intIntCursor : this) {
            n += BitMixer.mix(intIntCursor.key) + BitMixer.mix(intIntCursor.value);
        }
        return n;
    }

    protected int hashKey(int n) {
        return BitMixer.mix(n, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public int indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, int n2, int n3) {
        if (n2 == 0) {
            this.values[n] = n3;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, n2, n3);
            } else {
                this.keys[n] = n2;
                this.values[n] = n3;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            n = n3 + 1;
            if (!bl) {
                // empty if block
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return n4;
            }
            ++n4;
        }
        return n4;
    }

    @Override
    public int indexReplace(int n, int n2) {
        int[] nArray = this.values;
        int n3 = nArray[n];
        nArray[n] = n2;
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public int put(int n, int n2) {
        int n3;
        int n4 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = true;
            int[] nArray = this.values;
            n = n4 + 1;
            int n5 = nArray[n];
            nArray[n] = n2;
            return n5;
        }
        int[] nArray = this.keys;
        int n6 = this.hashKey(n);
        while ((n3 = nArray[n6 &= n4]) != 0) {
            if (n3 == n) {
                nArray = this.values;
                n = nArray[n6];
                nArray[n6] = n2;
                return n;
            }
            ++n6;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n6, n, n2);
        } else {
            nArray[n6] = n;
            this.values[n6] = n2;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(IntIntAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntIntCursor intIntCursor = (IntIntCursor)object.next();
            this.put(intIntCursor.key, intIntCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends IntIntCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntIntCursor intIntCursor = (IntIntCursor)object.next();
            this.put(intIntCursor.key, intIntCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(int n, int n2) {
        int n3 = this.indexOf(n);
        if (!this.indexExists(n3)) {
            this.indexInsert(n3, n, n2);
            return true;
        }
        return false;
    }

    @Override
    public int putOrAdd(int n, int n2, int n3) {
        int n4 = this.indexOf(n);
        if (this.indexExists(n4)) {
            n2 = this.values[n4] + n3;
            this.indexReplace(n4, n2);
        } else {
            this.indexInsert(n4, n, n2);
        }
        return n2;
    }

    protected void rehash(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = this.keys;
        int[] nArray4 = this.values;
        int n2 = this.mask;
        int n3 = nArray.length - 1;
        nArray3[nArray3.length - 1] = nArray[n3];
        nArray4[nArray4.length - 1] = nArray2[n3];
        while ((n = n3 - 1) >= 0) {
            int n4 = nArray[n];
            n3 = n;
            if (n4 == 0) continue;
            n3 = this.hashKey(n4);
            while (nArray3[n3 &= n2] != 0) {
                ++n3;
            }
            nArray3[n3] = n4;
            nArray4[n3] = nArray2[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int remove(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = false;
            int[] nArray = this.values;
            n = n3 + 1;
            int n4 = nArray[n];
            nArray[n] = 0;
            return n4;
        }
        int[] nArray = this.keys;
        int n5 = this.hashKey(n);
        while ((n2 = nArray[n5 &= n3]) != 0) {
            if (n2 == n) {
                n = this.values[n5];
                this.shiftConflictingKeys(n5);
                return n;
            }
            ++n5;
        }
        return 0;
    }

    @Override
    public int removeAll(IntContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof IntLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            int[] nArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                int n4 = nArray[n2];
                if (n4 != 0 && object.contains(n4)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((IntCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntIntPredicate intIntPredicate) {
        int n;
        int[] nArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && intIntPredicate.apply(0, (nArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0;
        }
        int[] nArray2 = this.keys;
        nArray = this.values;
        while (n4 <= n3) {
            n = nArray2[n4];
            if (n != 0 && intIntPredicate.apply(n, nArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && intPredicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            int n4 = nArray[n2];
            if (n4 != 0 && intPredicate.apply(n4)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            do {
                if ((n4 = nArray[n5 = n + (n3 = n6 + 1) & n2]) == 0) {
                    nArray[n] = 0;
                    nArray2[n] = 0;
                    --this.assigned;
                    return;
                }
                n6 = n3;
            } while ((n5 - this.hashKey(n4) & n2) < n3);
            nArray[n] = n4;
            nArray2[n] = nArray2[n5];
            n = n5;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<IntIntCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            IntIntCursor intIntCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(intIntCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(intIntCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public IntCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<IntIntCursor> {
        private final IntIntCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntIntCursor();
        }

        @Override
        protected IntIntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntIntHashMap.this.keys;
                    int n2 = this.slot;
                    n = nArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = n;
                        this.cursor.value = IntIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && IntIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntIntCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntIntHashMap owner;

        public KeysContainer() {
            this.owner = IntIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            return this.owner.containsKey(n);
        }

        @Override
        public <T extends IntPredicate> T forEach(final T t) {
            this.owner.forEach(new IntIntPredicate(){

                @Override
                public boolean apply(int n, int n2) {
                    return t.apply(n);
                }
            });
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(final T t) {
            this.owner.forEach(new IntIntProcedure(){

                @Override
                public void apply(int n, int n2) {
                    t.apply(n);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(int n) {
            if (this.owner.containsKey(n)) {
                this.owner.remove(n);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(IntPredicate intPredicate) {
            return this.owner.removeAll(intPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntIntHashMap.this.keys;
                    n = this.slot;
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        this.cursor.index = n;
                        this.cursor.value = n2;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final IntIntHashMap owner;

        private ValuesContainer() {
            this.owner = IntIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            Iterator<IntIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != n) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntPredicate> T forEach(T t) {
            Iterator<IntIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(T t) {
            Iterator<IntIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final int n) {
            return this.owner.removeAll(new IntIntPredicate(){

                @Override
                public boolean apply(int n3, int n2) {
                    boolean bl = n2 == n;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final IntPredicate intPredicate) {
            return this.owner.removeAll(new IntIntPredicate(){

                @Override
                public boolean apply(int n, int n2) {
                    return intPredicate.apply(n2);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntIntHashMap.this.keys;
                    n = this.slot;
                    if (nArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = IntIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

