/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLongAssociativeContainer;
import com.carrotsearch.hppc.IntLongMap;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntLongCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.IntLongPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.IntLongProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntLongHashMap
implements IntLongMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public int[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public long[] values;

    public IntLongHashMap() {
        this(4);
    }

    public IntLongHashMap(int n) {
        this(n, 0.75);
    }

    public IntLongHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public IntLongHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public IntLongHashMap(IntLongAssociativeContainer intLongAssociativeContainer) {
        this(intLongAssociativeContainer.size());
        this.putAll(intLongAssociativeContainer);
    }

    public static IntLongHashMap from(int[] nArray, long[] lArray) {
        if (nArray.length == lArray.length) {
            IntLongHashMap intLongHashMap = new IntLongHashMap(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                intLongHashMap.put(nArray[i], lArray[i]);
            }
            return intLongHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public long addTo(int n, long l) {
        return this.putOrAdd(n, l, l);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        int[] nArray = this.keys;
        long[] lArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new int[n3];
            this.values = new long[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = nArray;
            this.values = lArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, int n2, long l) {
        int[] nArray = this.keys;
        long[] lArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        nArray[n] = n2;
        lArray[n] = l;
        this.rehash(nArray, lArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public IntLongHashMap clone() {
        try {
            IntLongHashMap intLongHashMap = (IntLongHashMap)super.clone();
            intLongHashMap.keys = (int[])this.keys.clone();
            intLongHashMap.values = (long[])this.values.clone();
            intLongHashMap.hasEmptyKey = intLongHashMap.hasEmptyKey;
            intLongHashMap.orderMixer = this.orderMixer.clone();
            return intLongHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(int n) {
        int n2;
        if (n == 0) {
            return this.hasEmptyKey;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return true;
            }
            n4 = n2 + 1;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            int[] nArray = this.keys;
            long[] lArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (nArray != null && !this.isEmpty()) {
                this.rehash(nArray, lArray);
            }
        }
    }

    protected boolean equalElements(IntLongHashMap object) {
        if (((IntLongHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<IntLongCursor> iterator = ((IntLongHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            int n = ((IntLongCursor)object).key;
            if (this.containsKey(n) && this.get(n) == ((IntLongCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntLongHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntLongPredicate> T forEach(T t) {
        int[] nArray = this.keys;
        long[] lArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply(0, lArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (nArray[i] == 0 || t.apply(nArray[i], lArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends IntLongProcedure> T forEach(T t) {
        int[] nArray = this.keys;
        long[] lArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply(0, lArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (nArray[n] != 0) {
                t.apply(nArray[n], lArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public long get(int n) {
        int n2;
        long l = 0L;
        if (n == 0) {
            if (this.hasEmptyKey) {
                l = this.values[this.mask + 1];
            }
            return l;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return this.values[n4];
            }
            ++n4;
        }
        return 0L;
    }

    @Override
    public long getOrDefault(int n, long l) {
        int n2;
        if (n == 0) {
            if (this.hasEmptyKey) {
                l = this.values[this.mask + 1];
            }
            return l;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return this.values[n2];
            }
            n4 = n2 + 1;
        }
        return l;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (IntLongCursor intLongCursor : this) {
            n += BitMixer.mix(intLongCursor.key) + BitMixer.mix(intLongCursor.value);
        }
        return n;
    }

    protected int hashKey(int n) {
        return BitMixer.mix(n, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public long indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, int n2, long l) {
        if (n2 == 0) {
            this.values[n] = l;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, n2, l);
            } else {
                this.keys[n] = n2;
                this.values[n] = l;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            n = n3 + 1;
            if (!bl) {
                // empty if block
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return n2;
            }
            n4 = n2 + 1;
        }
        return n2;
    }

    @Override
    public long indexReplace(int n, long l) {
        long[] lArray = this.values;
        long l2 = lArray[n];
        lArray[n] = l;
        return l2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntLongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public long put(int n, long l) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = true;
            long[] lArray = this.values;
            n = n3 + 1;
            long l2 = lArray[n];
            lArray[n] = l;
            return l2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = objectArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                objectArray = this.values;
                int n5 = objectArray[n4];
                objectArray[n4] = (int)l;
                return n5;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, n, l);
        } else {
            objectArray[n4] = n;
            this.values[n4] = l;
        }
        ++this.assigned;
        return 0L;
    }

    @Override
    public int putAll(IntLongAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntLongCursor intLongCursor = (IntLongCursor)object.next();
            this.put(intLongCursor.key, intLongCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends IntLongCursor> object) {
        int n = this.size();
        Iterator<? extends IntLongCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((IntLongCursor)object).key, ((IntLongCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(int n, long l) {
        int n2 = this.indexOf(n);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, n, l);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(int n, long l, long l2) {
        int n2 = this.indexOf(n);
        if (this.indexExists(n2)) {
            l = this.values[n2] + l2;
            this.indexReplace(n2, l);
        } else {
            this.indexInsert(n2, n, l);
        }
        return l;
    }

    protected void rehash(int[] nArray, long[] lArray) {
        int n;
        int[] nArray2 = this.keys;
        long[] lArray2 = this.values;
        int n2 = this.mask;
        int n3 = nArray.length - 1;
        nArray2[nArray2.length - 1] = nArray[n3];
        lArray2[lArray2.length - 1] = lArray[n3];
        while ((n = n3 - 1) >= 0) {
            int n4 = nArray[n];
            n3 = n;
            if (n4 == 0) continue;
            n3 = this.hashKey(n4);
            while (nArray2[n3 &= n2] != 0) {
                ++n3;
            }
            nArray2[n3] = n4;
            lArray2[n3] = lArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public long remove(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = false;
            long[] lArray = this.values;
            n = n3 + 1;
            long l = lArray[n];
            lArray[n] = 0L;
            return l;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                long l = this.values[n4];
                this.shiftConflictingKeys(n4);
                return l;
            }
            ++n4;
        }
        return 0L;
    }

    @Override
    public int removeAll(IntContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof IntLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0L;
            }
            int[] nArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                int n4 = nArray[n2];
                if (n4 != 0 && object.contains(n4)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((IntCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntLongPredicate intLongPredicate) {
        int n;
        long[] lArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && intLongPredicate.apply(0, (lArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0L;
        }
        int[] nArray = this.keys;
        lArray = this.values;
        while (n4 <= n3) {
            n = nArray[n4];
            if (n != 0 && intLongPredicate.apply(n, lArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && intPredicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0L;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            int n4 = nArray[n2];
            if (n4 != 0 && intPredicate.apply(n4)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        int[] nArray = this.keys;
        long[] lArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            do {
                if ((n4 = nArray[n5 = n + (n3 = n6 + 1) & n2]) == 0) {
                    nArray[n] = 0;
                    lArray[n] = 0L;
                    --this.assigned;
                    return;
                }
                n6 = n3;
            } while ((n5 - this.hashKey(n4) & n2) < n3);
            nArray[n] = n4;
            lArray[n] = lArray[n5];
            n = n5;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<IntLongCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            IntLongCursor intLongCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(intLongCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(intLongCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public LongCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<IntLongCursor> {
        private final IntLongCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntLongCursor();
        }

        @Override
        protected IntLongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntLongHashMap.this.keys;
                    int n2 = this.slot;
                    n = nArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = n;
                        this.cursor.value = IntLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && IntLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntLongCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntLongHashMap owner;

        public KeysContainer() {
            this.owner = IntLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            return this.owner.containsKey(n);
        }

        @Override
        public <T extends IntPredicate> T forEach(final T t) {
            this.owner.forEach(new IntLongPredicate(){

                @Override
                public boolean apply(int n, long l) {
                    return t.apply(n);
                }
            });
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(final T t) {
            this.owner.forEach(new IntLongProcedure(){

                @Override
                public void apply(int n, long l) {
                    t.apply(n);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(int n) {
            if (this.owner.containsKey(n)) {
                this.owner.remove(n);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(IntPredicate intPredicate) {
            return this.owner.removeAll(intPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntLongHashMap.this.keys;
                    n = this.slot;
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        this.cursor.index = n;
                        this.cursor.value = n2;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final IntLongHashMap owner;

        private ValuesContainer() {
            this.owner = IntLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            Iterator<IntLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != l) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongPredicate> T forEach(T t) {
            Iterator<IntLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(T t) {
            Iterator<IntLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final long l) {
            return this.owner.removeAll(new IntLongPredicate(){

                @Override
                public boolean apply(int n, long l2) {
                    boolean bl = l2 == l;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final LongPredicate longPredicate) {
            return this.owner.removeAll(new IntLongPredicate(){

                @Override
                public boolean apply(int n, long l) {
                    return longPredicate.apply(l);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntLongHashMap.this.keys;
                    n = this.slot;
                    if (nArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = IntLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

