/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntObjectAssociativeContainer;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class IntObjectHashMap<VType>
implements IntObjectMap<VType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public int[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public Object[] values;

    public IntObjectHashMap() {
        this(4);
    }

    public IntObjectHashMap(int n) {
        this(n, 0.75);
    }

    public IntObjectHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public IntObjectHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public IntObjectHashMap(IntObjectAssociativeContainer<? extends VType> intObjectAssociativeContainer) {
        this(intObjectAssociativeContainer.size());
        this.putAll(intObjectAssociativeContainer);
    }

    public static <VType> IntObjectHashMap<VType> from(int[] nArray, VType[] VTypeArray) {
        if (nArray.length == VTypeArray.length) {
            IntObjectHashMap<VType> intObjectHashMap = new IntObjectHashMap<VType>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                intObjectHashMap.put(nArray[i], VTypeArray[i]);
            }
            return intObjectHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new int[n3];
            this.values = new Object[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = nArray;
            this.values = objectArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, int n2, VType VType) {
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        nArray[n] = n2;
        objectArray[n] = VType;
        this.rehash(nArray, objectArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
    }

    public IntObjectHashMap<VType> clone() {
        try {
            IntObjectHashMap intObjectHashMap = (IntObjectHashMap)super.clone();
            intObjectHashMap.keys = (int[])this.keys.clone();
            intObjectHashMap.values = (Object[])this.values.clone();
            intObjectHashMap.hasEmptyKey = intObjectHashMap.hasEmptyKey;
            intObjectHashMap.orderMixer = this.orderMixer.clone();
            return intObjectHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(int n) {
        int n2;
        if (n == 0) {
            return this.hasEmptyKey;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return true;
            }
            n4 = n2 + 1;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            int[] nArray = this.keys;
            Object[] objectArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (nArray != null && !this.isEmpty()) {
                this.rehash(nArray, objectArray);
            }
        }
    }

    protected boolean equalElements(IntObjectHashMap<?> object) {
        if (((IntObjectHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((IntObjectHashMap)object).iterator();
        while (object.hasNext()) {
            IntObjectCursor intObjectCursor = (IntObjectCursor)object.next();
            int n = intObjectCursor.key;
            if (this.containsKey(n) && Objects.equals(this.get(n), intObjectCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntObjectHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntObjectPredicate<? super VType>> T forEach(T t) {
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply(0, (Object)objectArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (nArray[i] == 0 || t.apply(nArray[i], (Object)objectArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends IntObjectProcedure<? super VType>> T forEach(T t) {
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply(0, (Object)objectArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (nArray[n] != 0) {
                t.apply(nArray[n], (Object)objectArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public VType get(int n) {
        int n2;
        Object object = null;
        if (n == 0) {
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return (VType)object;
        }
        object = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n4 = object[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return (VType)this.values[n2];
            }
            n4 = n2 + 1;
        }
        return null;
    }

    @Override
    public VType getOrDefault(int n, VType object) {
        int n2;
        if (n == 0) {
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return object;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return (VType)this.values[n4];
            }
            ++n4;
        }
        return object;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (IntObjectCursor<VType> intObjectCursor : this) {
            n += BitMixer.mix(intObjectCursor.key) + BitMixer.mix(intObjectCursor.value);
        }
        return n;
    }

    protected int hashKey(int n) {
        return BitMixer.mix(n, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public VType indexGet(int n) {
        return (VType)this.values[n];
    }

    @Override
    public void indexInsert(int n, int n2, VType VType) {
        if (n2 == 0) {
            this.values[n] = VType;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, n2, VType);
            } else {
                this.keys[n] = n2;
                this.values[n] = VType;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            n = n3 + 1;
            if (!bl) {
                // empty if block
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n4 = nArray[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                return n2;
            }
            n4 = n2 + 1;
        }
        return n2;
    }

    @Override
    public VType indexReplace(int n, VType VType) {
        Object[] objectArray = this.values;
        Object object = objectArray[n];
        objectArray[n] = VType;
        return (VType)object;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public VType put(int n, VType VType) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = true;
            Object[] objectArray = this.values;
            n = n3 + 1;
            Object object = objectArray[n];
            objectArray[n] = VType;
            return (VType)object;
        }
        Object object = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = object[n4 &= n3]) != 0) {
            if (n2 == n) {
                Object[] objectArray = this.values;
                object = objectArray[n4];
                objectArray[n4] = VType;
                return (VType)object;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, n, VType);
        } else {
            object[n4] = n;
            this.values[n4] = VType;
        }
        ++this.assigned;
        return null;
    }

    @Override
    public int putAll(IntObjectAssociativeContainer<? extends VType> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntObjectCursor intObjectCursor = (IntObjectCursor)object.next();
            this.put(intObjectCursor.key, intObjectCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends IntObjectCursor<? extends VType>> object) {
        int n = this.size();
        Iterator<IntObjectCursor<VType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((IntObjectCursor)object).key, ((IntObjectCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(int n, VType VType) {
        int n2 = this.indexOf(n);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, n, VType);
            return true;
        }
        return false;
    }

    protected void rehash(int[] nArray, VType[] VTypeArray) {
        int n;
        int[] nArray2 = this.keys;
        Object[] objectArray = this.values;
        int n2 = this.mask;
        int n3 = nArray.length - 1;
        nArray2[nArray2.length - 1] = nArray[n3];
        objectArray[objectArray.length - 1] = VTypeArray[n3];
        while ((n = n3 - 1) >= 0) {
            int n4 = nArray[n];
            n3 = n;
            if (n4 == 0) continue;
            n3 = this.hashKey(n4);
            while (nArray2[n3 &= n2] != 0) {
                ++n3;
            }
            nArray2[n3] = n4;
            objectArray[n3] = VTypeArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public VType remove(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = false;
            Object[] objectArray = this.values;
            n = n3 + 1;
            Object object = objectArray[n];
            objectArray[n] = null;
            return (VType)object;
        }
        Object object = this.keys;
        int n4 = this.hashKey(n);
        while ((n4 = object[n2 = n4 & n3]) != 0) {
            if (n4 == n) {
                object = this.values[n2];
                this.shiftConflictingKeys(n2);
                return (VType)object;
            }
            n4 = n2 + 1;
        }
        return null;
    }

    @Override
    public int removeAll(IntContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof IntLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = null;
            }
            int[] nArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                int n4 = nArray[n2];
                if (n4 != 0 && object.contains(n4)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((IntCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntObjectPredicate<? super VType> intObjectPredicate) {
        Object object;
        Object[] objectArray;
        int n = this.size();
        int n2 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n3 = 0;
        if (bl && intObjectPredicate.apply(0, (objectArray = this.values)[object = n2 + 1])) {
            this.hasEmptyKey = false;
            this.values[object] = null;
        }
        objectArray = this.keys;
        Object[] objectArray2 = this.values;
        while (n3 <= n2) {
            object = objectArray[n3];
            if (object != 0 && intObjectPredicate.apply((int)object, objectArray2[n3])) {
                this.shiftConflictingKeys(n3);
                continue;
            }
            ++n3;
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && intPredicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = null;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            int n4 = nArray[n2];
            if (n4 != 0 && intPredicate.apply(n4)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            do {
                if ((n4 = nArray[n5 = n + (n3 = n6 + 1) & n2]) == 0) {
                    nArray[n] = 0;
                    objectArray[n] = null;
                    --this.assigned;
                    return;
                }
                n6 = n3;
            } while ((n5 - this.hashKey(n4) & n2) < n3);
            nArray[n] = n4;
            objectArray[n] = objectArray[n5];
            n = n5;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<IntObjectCursor<VType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            IntObjectCursor<VType> intObjectCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(intObjectCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(intObjectCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ObjectCollection<VType> values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<IntObjectCursor<VType>> {
        private final IntObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntObjectCursor();
        }

        @Override
        protected IntObjectCursor<VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntObjectHashMap.this.keys;
                    int n2 = this.slot;
                    n = nArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = n;
                        this.cursor.value = IntObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && IntObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntObjectCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntObjectHashMap<VType> owner;

        public KeysContainer() {
            this.owner = IntObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            return this.owner.containsKey(n);
        }

        @Override
        public <T extends IntPredicate> T forEach(final T t) {
            this.owner.forEach(new IntObjectPredicate<VType>(){

                @Override
                public boolean apply(int n, VType VType) {
                    return t.apply(n);
                }
            });
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(final T t) {
            this.owner.forEach(new IntObjectProcedure<VType>(){

                @Override
                public void apply(int n, VType VType) {
                    t.apply(n);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(int n) {
            if (this.owner.containsKey(n)) {
                this.owner.remove(n);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(IntPredicate intPredicate) {
            return this.owner.removeAll(intPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntObjectHashMap.this.keys;
                    n = this.slot;
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        this.cursor.index = n;
                        this.cursor.value = n2;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final IntObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = IntObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(VType VType) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (!Objects.equals(iterator.next().value, VType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ObjectPredicate<? super VType> objectPredicate) {
            return this.owner.removeAll(new IntObjectPredicate<VType>(){

                @Override
                public boolean apply(int n, VType VType) {
                    return objectPredicate.apply(VType);
                }
            });
        }

        @Override
        public int removeAll(final VType VType) {
            return this.owner.removeAll(new IntObjectPredicate<VType>(){

                @Override
                public boolean apply(int n, VType VType2) {
                    return Objects.equals(VType2, VType);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntObjectHashMap.this.keys;
                    n = this.slot;
                    if (nArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = IntObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

