/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntShortAssociativeContainer;
import com.carrotsearch.hppc.IntShortMap;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntShortCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.IntShortPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.IntShortProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntShortHashMap
implements IntShortMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public int[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public short[] values;

    public IntShortHashMap() {
        this(4);
    }

    public IntShortHashMap(int n) {
        this(n, 0.75);
    }

    public IntShortHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public IntShortHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public IntShortHashMap(IntShortAssociativeContainer intShortAssociativeContainer) {
        this(intShortAssociativeContainer.size());
        this.putAll(intShortAssociativeContainer);
    }

    public static IntShortHashMap from(int[] nArray, short[] sArray) {
        if (nArray.length == sArray.length) {
            IntShortHashMap intShortHashMap = new IntShortHashMap(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                intShortHashMap.put(nArray[i], sArray[i]);
            }
            return intShortHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public short addTo(int n, short s) {
        return this.putOrAdd(n, s, s);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        int[] nArray = this.keys;
        short[] sArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new int[n3];
            this.values = new short[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = nArray;
            this.values = sArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, int n2, short s) {
        int[] nArray = this.keys;
        short[] sArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        nArray[n] = n2;
        sArray[n] = s;
        this.rehash(nArray, sArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public IntShortHashMap clone() {
        try {
            IntShortHashMap intShortHashMap = (IntShortHashMap)super.clone();
            intShortHashMap.keys = (int[])this.keys.clone();
            intShortHashMap.values = (short[])this.values.clone();
            intShortHashMap.hasEmptyKey = intShortHashMap.hasEmptyKey;
            intShortHashMap.orderMixer = this.orderMixer.clone();
            return intShortHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(int n) {
        int n2;
        if (n == 0) {
            return this.hasEmptyKey;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            int[] nArray = this.keys;
            short[] sArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (nArray != null && !this.isEmpty()) {
                this.rehash(nArray, sArray);
            }
        }
    }

    protected boolean equalElements(IntShortHashMap object) {
        if (((IntShortHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((IntShortHashMap)object).iterator();
        while (object.hasNext()) {
            IntShortCursor intShortCursor = (IntShortCursor)object.next();
            int n = intShortCursor.key;
            if (this.containsKey(n) && this.get(n) == intShortCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((IntShortHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends IntShortPredicate> T forEach(T t) {
        int[] nArray = this.keys;
        short[] sArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply(0, sArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (nArray[i] == 0 || t.apply(nArray[i], sArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends IntShortProcedure> T forEach(T t) {
        int[] nArray = this.keys;
        short[] sArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply(0, sArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (nArray[n] != 0) {
                t.apply(nArray[n], sArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public short get(int n) {
        int n2;
        int n3 = 0;
        if (n == 0) {
            int n4 = n3;
            if (this.hasEmptyKey) {
                n4 = n = this.values[this.mask + 1];
            }
            return (short)n4;
        }
        int[] nArray = this.keys;
        int n5 = this.mask;
        n3 = this.hashKey(n);
        while ((n2 = nArray[n3 &= n5]) != 0) {
            if (n2 == n) {
                return this.values[n3];
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public short getOrDefault(int n, short s) {
        int n2;
        if (n == 0) {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
                s = (short)n;
            }
            return s;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return this.values[n4];
            }
            ++n4;
        }
        return s;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (IntShortCursor intShortCursor : this) {
            n += BitMixer.mix(intShortCursor.key) + BitMixer.mix(intShortCursor.value);
        }
        return n;
    }

    protected int hashKey(int n) {
        return BitMixer.mix(n, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public short indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, int n2, short s) {
        if (n2 == 0) {
            this.values[n] = s;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, n2, s);
            } else {
                this.keys[n] = n2;
                this.values[n] = s;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            boolean bl = this.hasEmptyKey;
            n = n3 + 1;
            if (!bl) {
                // empty if block
            }
            return n;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                return n4;
            }
            ++n4;
        }
        return n4;
    }

    @Override
    public short indexReplace(int n, short s) {
        short[] sArray = this.values;
        short s2 = sArray[n];
        sArray[n] = s;
        return s2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<IntShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public short put(int n, short s) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = true;
            short[] sArray = this.values;
            n = n3 + 1;
            short s2 = sArray[n];
            sArray[n] = s;
            return s2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = objectArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                objectArray = this.values;
                short s3 = objectArray[n4];
                objectArray[n4] = s;
                return s3;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, n, s);
        } else {
            objectArray[n4] = n;
            this.values[n4] = s;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(IntShortAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            IntShortCursor intShortCursor = (IntShortCursor)object.next();
            this.put(intShortCursor.key, intShortCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends IntShortCursor> object) {
        int n = this.size();
        Iterator<? extends IntShortCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((IntShortCursor)object).key, ((IntShortCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(int n, short s) {
        int n2 = this.indexOf(n);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, n, s);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(int n, short s, short s2) {
        int n2 = this.indexOf(n);
        if (this.indexExists(n2)) {
            s = (short)(this.values[n2] + s2);
            this.indexReplace(n2, s);
        } else {
            this.indexInsert(n2, n, s);
        }
        return s;
    }

    protected void rehash(int[] nArray, short[] sArray) {
        int n;
        int[] nArray2 = this.keys;
        short[] sArray2 = this.values;
        int n2 = this.mask;
        int n3 = nArray.length - 1;
        nArray2[nArray2.length - 1] = nArray[n3];
        sArray2[sArray2.length - 1] = sArray[n3];
        while ((n = n3 - 1) >= 0) {
            int n4 = nArray[n];
            n3 = n;
            if (n4 == 0) continue;
            n3 = this.hashKey(n4);
            while (nArray2[n3 &= n2] != 0) {
                ++n3;
            }
            nArray2[n3] = n4;
            sArray2[n3] = sArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public short remove(int n) {
        int n2;
        int n3 = this.mask;
        if (n == 0) {
            this.hasEmptyKey = false;
            short[] sArray = this.values;
            n = n3 + 1;
            short s = sArray[n];
            sArray[n] = (short)0;
            return s;
        }
        int[] nArray = this.keys;
        int n4 = this.hashKey(n);
        while ((n2 = nArray[n4 &= n3]) != 0) {
            if (n2 == n) {
                short s = this.values[n4];
                this.shiftConflictingKeys(n4);
                return s;
            }
            ++n4;
        }
        return 0;
    }

    @Override
    public int removeAll(IntContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof IntLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (short)0;
            }
            int[] nArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                int n4 = nArray[n2];
                if (n4 != 0 && object.contains(n4)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((IntCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntPredicate intPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && intPredicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (short)0;
        }
        int[] nArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            int n4 = nArray[n2];
            if (n4 != 0 && intPredicate.apply(n4)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    @Override
    public int removeAll(IntShortPredicate intShortPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && intShortPredicate.apply(0, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (short)0;
        }
        objectArray = this.keys;
        short[] sArray = this.values;
        while (n4 <= n3) {
            n = objectArray[n4];
            if (n != 0 && intShortPredicate.apply(n, sArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        int[] nArray = this.keys;
        short[] sArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            do {
                if ((n4 = nArray[n5 = n + (n3 = n6 + 1) & n2]) == 0) {
                    nArray[n] = 0;
                    sArray[n] = (short)0;
                    --this.assigned;
                    return;
                }
                n6 = n3;
            } while ((n5 - this.hashKey(n4) & n2) < n3);
            nArray[n] = n4;
            sArray[n] = sArray[n5];
            n = n5;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<IntShortCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            IntShortCursor intShortCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(intShortCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(intShortCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ShortCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<IntShortCursor> {
        private final IntShortCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntShortCursor();
        }

        @Override
        protected IntShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntShortHashMap.this.keys;
                    int n2 = this.slot;
                    n = nArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = n;
                        this.cursor.value = IntShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && IntShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntShortCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntShortHashMap owner;

        public KeysContainer() {
            this.owner = IntShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            return this.owner.containsKey(n);
        }

        @Override
        public <T extends IntPredicate> T forEach(final T t) {
            this.owner.forEach(new IntShortPredicate(){

                @Override
                public boolean apply(int n, short s) {
                    return t.apply(n);
                }
            });
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(final T t) {
            this.owner.forEach(new IntShortProcedure(){

                @Override
                public void apply(int n, short s) {
                    t.apply(n);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(int n) {
            if (this.owner.containsKey(n)) {
                this.owner.remove(n);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(IntPredicate intPredicate) {
            return this.owner.removeAll(intPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntShortHashMap.this.keys;
                    n = this.slot;
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        this.cursor.index = n;
                        this.cursor.value = n2;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final IntShortHashMap owner;

        private ValuesContainer() {
            this.owner = IntShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            Iterator<IntShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != s) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T t) {
            Iterator<IntShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T t) {
            Iterator<IntShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ShortPredicate shortPredicate) {
            return this.owner.removeAll(new IntShortPredicate(){

                @Override
                public boolean apply(int n, short s) {
                    return shortPredicate.apply(s);
                }
            });
        }

        @Override
        public int removeAll(final short s) {
            return this.owner.removeAll(new IntShortPredicate(){

                @Override
                public boolean apply(int n, short s2) {
                    boolean bl = s2 == s;
                    return bl;
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    int[] nArray = IntShortHashMap.this.keys;
                    n = this.slot;
                    if (nArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = IntShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && IntShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

