/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongArrayDeque
extends AbstractLongCollection
implements LongDeque,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public long[] buffer = LongArrayList.EMPTY_ARRAY;
    public int head;
    protected final ArraySizingStrategy resizer;
    public int tail;

    public LongArrayDeque() {
        this(4);
    }

    public LongArrayDeque(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public LongArrayDeque(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public LongArrayDeque(LongContainer longContainer) {
        this(longContainer.size());
        this.addLast(longContainer);
    }

    private void descendingForEach(LongPredicate longPredicate, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        long[] lArray = this.buffer;
        while (longPredicate.apply(lArray[n3 = LongArrayDeque.oneLeft(n2, lArray.length)])) {
            n2 = n3;
            if (n3 != n) continue;
        }
    }

    private void descendingForEach(LongProcedure longProcedure, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        long[] lArray = this.buffer;
        do {
            n3 = LongArrayDeque.oneLeft(n2, lArray.length);
            longProcedure.apply(lArray[n3]);
            n2 = n3;
        } while (n3 != n);
    }

    private void forEach(LongProcedure longProcedure, int n, int n2) {
        long[] lArray = this.buffer;
        while (n != n2) {
            longProcedure.apply(lArray[n]);
            n = LongArrayDeque.oneRight(n, lArray.length);
        }
    }

    public static LongArrayDeque from(long ... lArray) {
        LongArrayDeque longArrayDeque = new LongArrayDeque(lArray.length);
        longArrayDeque.addLast(lArray);
        return longArrayDeque;
    }

    protected static int oneLeft(int n, int n2) {
        if (n >= 1) {
            return n - 1;
        }
        return n2 - 1;
    }

    protected static int oneRight(int n, int n2) {
        int n3;
        n = n3 = n + 1;
        if (n3 == n2) {
            n = 0;
        }
        return n;
    }

    public int addFirst(LongContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addFirst(((LongCursor)object.next()).value);
        }
        return n;
    }

    public int addFirst(Iterable<? extends LongCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addFirst(((LongCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addFirst(long l) {
        int n;
        int n2 = n = LongArrayDeque.oneLeft(this.head, this.buffer.length);
        if (n == this.tail) {
            this.ensureBufferSpace(1);
            n2 = LongArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        long[] lArray = this.buffer;
        this.head = n2;
        lArray[n2] = l;
    }

    public final void addFirst(long ... lArray) {
        this.ensureBufferSpace(lArray.length);
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            this.addFirst(lArray[i]);
        }
    }

    public int addLast(LongContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addLast(((LongCursor)object.next()).value);
        }
        return n;
    }

    public int addLast(Iterable<? extends LongCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addLast(((LongCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addLast(long l) {
        int n;
        int n2 = n = LongArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == n) {
            this.ensureBufferSpace(1);
            n2 = LongArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = l;
        this.tail = n2;
    }

    public final void addLast(long ... lArray) {
        this.ensureBufferSpace(1);
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            this.addLast(lArray[i]);
        }
    }

    public int bufferIndexOf(long l) {
        int n = this.tail;
        int n2 = this.buffer.length;
        int n3 = this.head;
        while (n3 != n) {
            if (this.buffer[n3] == l) {
                return n3;
            }
            n3 = LongArrayDeque.oneRight(n3, n2);
        }
        return -1;
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            Arrays.fill(this.buffer, n, n2, 0L);
        } else {
            Arrays.fill(this.buffer, 0, n2, 0L);
            long[] lArray = this.buffer;
            Arrays.fill(lArray, this.head, lArray.length, 0L);
        }
        this.tail = 0;
        this.head = 0;
    }

    public LongArrayDeque clone() {
        try {
            LongArrayDeque longArrayDeque = (LongArrayDeque)super.clone();
            longArrayDeque.buffer = (long[])this.buffer.clone();
            return longArrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(long l) {
        int n = this.head;
        int n2 = this.tail;
        long[] lArray = this.buffer;
        while (n != n2) {
            if (lArray[n] == l) {
                return true;
            }
            n = LongArrayDeque.oneRight(n, lArray.length);
        }
        return false;
    }

    @Override
    public <T extends LongPredicate> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public <T extends LongProcedure> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public Iterator<LongCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureBufferSpace(int n) {
        int n2 = this.buffer.length;
        int n3 = this.size();
        if (n3 + n < n2) return;
        n = this.resizer.grow(n2, n3 + 1, n);
        try {
            long[] lArray = new long[n];
            if (n2 > 0) {
                this.toArray(lArray);
                this.tail = n3;
                this.head = 0;
            }
            this.buffer = lArray;
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensureBufferSpace(n - this.size());
    }

    protected boolean equalElements(LongArrayDeque object) {
        int n = this.size();
        int n2 = ((LongArrayDeque)object).size();
        boolean bl = false;
        if (n2 != n) {
            return false;
        }
        Iterator<LongCursor> iterator = this.iterator();
        object = ((LongArrayDeque)object).iterator();
        while (iterator.hasNext() && object.hasNext()) {
            if (((LongCursor)object.next()).value == iterator.next().value) continue;
            return false;
        }
        boolean bl2 = bl;
        if (!iterator.hasNext()) {
            bl2 = bl;
            if (!object.hasNext()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongArrayDeque)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongPredicate> T forEach(T t) {
        int n = this.head;
        int n2 = this.tail;
        long[] lArray = this.buffer;
        while (n != n2 && t.apply(lArray[n])) {
            n = LongArrayDeque.oneRight(n, lArray.length);
        }
        return t;
    }

    @Override
    public <T extends LongProcedure> T forEach(T t) {
        this.forEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public long getFirst() {
        return this.buffer[this.head];
    }

    @Override
    public long getLast() {
        long[] lArray = this.buffer;
        return lArray[LongArrayDeque.oneLeft(this.tail, lArray.length)];
    }

    public int hashCode() {
        int n = this.head;
        int n2 = this.tail;
        long[] lArray = this.buffer;
        int n3 = 1;
        while (n != n2) {
            n3 = n3 * 31 + BitMixer.mix(this.buffer[n]);
            n = LongArrayDeque.oneRight(n, lArray.length);
        }
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new ValueIterator();
    }

    public int lastBufferIndexOf(long l) {
        int n;
        int n2 = this.buffer.length;
        int n3 = LongArrayDeque.oneLeft(this.head, n2);
        int n4 = this.tail;
        while ((n = LongArrayDeque.oneLeft(n4, n2)) != n3) {
            n4 = n;
            if (this.buffer[n] != l) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = LongArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public int removeAll(long l) {
        int n;
        int n2 = this.tail;
        int n3 = this.buffer.length;
        int n4 = n = this.head;
        int n5 = 0;
        while (n != n2) {
            long[] lArray = this.buffer;
            if (lArray[n] == l) {
                lArray[n] = 0L;
                ++n5;
            } else {
                if (n4 != n) {
                    lArray[n4] = lArray[n];
                    lArray[n] = 0L;
                }
                n4 = LongArrayDeque.oneRight(n4, n3);
            }
            n = LongArrayDeque.oneRight(n, n3);
        }
        this.tail = n4;
        return n5;
    }

    /*
     * Loose catch block
     */
    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        long[] lArray;
        block10: {
            int n6;
            lArray = this.buffer;
            n5 = this.tail;
            n4 = lArray.length;
            int n7 = n6 = this.head;
            n3 = 0;
            while (true) {
                n2 = n6;
                n = n7;
                if (n6 == n5) break block10;
                n2 = n7;
                if (longPredicate.apply(lArray[n6])) {
                    lArray[n6] = 0L;
                    ++n3;
                    break block11;
                }
                if (n7 == n6) break block12;
                break;
            }
            catch (Throwable throwable) {
                while (n6 != n5) {
                    if (n2 != n6) {
                        lArray[n2] = lArray[n6];
                        lArray[n6] = 0L;
                    }
                    n2 = LongArrayDeque.oneRight(n2, n4);
                    n6 = LongArrayDeque.oneRight(n6, n4);
                }
                this.tail = n2;
                throw throwable;
            }
            {
                block11: {
                    block12: {
                        lArray[n7] = lArray[n6];
                        lArray[n6] = 0L;
                    }
                    n2 = n7;
                    n7 = LongArrayDeque.oneRight(n7, n4);
                }
                n2 = n7;
                n6 = n = LongArrayDeque.oneRight(n6, n4);
                continue;
            }
        }
        while (n2 != n5) {
            if (n != n2) {
                lArray[n] = lArray[n2];
                lArray[n2] = 0L;
            }
            n = LongArrayDeque.oneRight(n, n4);
            n2 = LongArrayDeque.oneRight(n2, n4);
        }
        this.tail = n;
        return n3;
    }

    public void removeAtBufferIndex(int n) {
        int n2;
        long[] lArray = this.buffer;
        int n3 = lArray.length;
        int n4 = n3 - 1;
        int n5 = this.head;
        int n6 = this.tail;
        int n7 = Math.abs(n - n5) % n3;
        if (n7 < (n2 = Math.abs(n6 - n) % n3)) {
            if (n >= n5) {
                System.arraycopy(lArray, n5, lArray, n5 + 1, n7);
            } else {
                System.arraycopy(lArray, 0, lArray, 1, n);
                lArray[0] = lArray[n4];
                System.arraycopy(lArray, n5, lArray, n5 + 1, n4 - n5);
            }
            lArray[n5] = 0L;
            this.head = LongArrayDeque.oneRight(n5, n3);
        } else {
            if (n < n6) {
                System.arraycopy(lArray, n + 1, lArray, n, n2);
            } else {
                System.arraycopy(lArray, n + 1, lArray, n, n4 - n);
                lArray[n4] = lArray[0];
                System.arraycopy(lArray, 1, lArray, 0, n6);
            }
            lArray[n6] = 0L;
            this.tail = LongArrayDeque.oneLeft(n6, n3);
        }
    }

    @Override
    public int removeFirst(long l) {
        int n = this.bufferIndexOf(l);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public long removeFirst() {
        long[] lArray = this.buffer;
        int n = this.head;
        long l = lArray[n];
        lArray[n] = 0L;
        this.head = LongArrayDeque.oneRight(n, lArray.length);
        return l;
    }

    @Override
    public int removeLast(long l) {
        int n = this.lastBufferIndexOf(l);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public long removeLast() {
        int n;
        this.tail = n = LongArrayDeque.oneLeft(this.tail, this.buffer.length);
        long[] lArray = this.buffer;
        long l = lArray[n];
        lArray[n] = 0L;
        return l;
    }

    @Override
    public int size() {
        int n = this.head;
        int n2 = this.tail;
        if (n <= n2) {
            return n2 - n;
        }
        return n2 - n + this.buffer.length;
    }

    @Override
    public long[] toArray() {
        return this.toArray(new long[this.size()]);
    }

    public long[] toArray(long[] lArray) {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            System.arraycopy(this.buffer, n, lArray, 0, this.size());
        } else if (n > n2) {
            long[] lArray2 = this.buffer;
            n2 = lArray2.length - n;
            System.arraycopy(lArray2, n, lArray, 0, n2);
            System.arraycopy(this.buffer, 0, lArray, n2, this.tail);
        }
        return lArray;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private int remaining;

        public DescendingValueIterator() {
            LongCursor longCursor;
            this.cursor = longCursor = new LongCursor();
            longCursor.index = LongArrayDeque.this.tail;
            this.remaining = LongArrayDeque.this.size();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (LongCursor)this.done();
            }
            this.remaining = n - 1;
            LongCursor longCursor = this.cursor;
            long[] lArray = LongArrayDeque.this.buffer;
            LongCursor longCursor2 = this.cursor;
            longCursor2.index = n = LongArrayDeque.oneLeft(longCursor2.index, LongArrayDeque.this.buffer.length);
            longCursor.value = lArray[n];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private int remaining;

        public ValueIterator() {
            LongCursor longCursor;
            this.cursor = longCursor = new LongCursor();
            longCursor.index = LongArrayDeque.oneLeft(LongArrayDeque.this.head, LongArrayDeque.this.buffer.length);
            this.remaining = LongArrayDeque.this.size();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (LongCursor)this.done();
            }
            this.remaining = n - 1;
            LongCursor longCursor = this.cursor;
            long[] lArray = LongArrayDeque.this.buffer;
            LongCursor longCursor2 = this.cursor;
            longCursor2.index = n = LongArrayDeque.oneRight(longCursor2.index, LongArrayDeque.this.buffer.length);
            longCursor.value = lArray[n];
            return this.cursor;
        }
    }
}

