/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongIndexedContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongArrayList
extends AbstractLongCollection
implements LongIndexedContainer,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final long[] EMPTY_ARRAY = new long[0];
    public long[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public LongArrayList() {
        this(4);
    }

    public LongArrayList(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public LongArrayList(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public LongArrayList(LongContainer longContainer) {
        this(longContainer.size());
        this.addAll(longContainer);
    }

    public static LongArrayList from(long ... lArray) {
        LongArrayList longArrayList = new LongArrayList(lArray.length);
        longArrayList.add(lArray);
        return longArrayList;
    }

    @Override
    public void add(long l) {
        this.ensureBufferSpace(1);
        long[] lArray = this.buffer;
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        lArray[n] = l;
    }

    public void add(long l, long l2) {
        int n;
        this.ensureBufferSpace(2);
        long[] lArray = this.buffer;
        int n2 = this.elementsCount;
        this.elementsCount = n = n2 + 1;
        lArray[n2] = l;
        this.elementsCount = n + 1;
        lArray[n] = l2;
    }

    public final void add(long ... lArray) {
        this.add(lArray, 0, lArray.length);
    }

    public void add(long[] lArray, int n, int n2) {
        this.ensureBufferSpace(n2);
        System.arraycopy(lArray, n, this.buffer, this.elementsCount, n2);
        this.elementsCount += n2;
    }

    public int addAll(LongContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.add(((LongCursor)object.next()).value);
        }
        return n;
    }

    public int addAll(Iterable<? extends LongCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.add(((LongCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0L);
        this.elementsCount = 0;
    }

    public LongArrayList clone() {
        try {
            LongArrayList longArrayList = (LongArrayList)super.clone();
            longArrayList.buffer = (long[])this.buffer.clone();
            return longArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(long l) {
        boolean bl = this.indexOf(l) >= 0;
        return bl;
    }

    protected void ensureBufferSpace(int n) {
        int n2 = this.elementsCount;
        long[] lArray = this.buffer;
        int n3 = lArray == null ? 0 : lArray.length;
        if (n2 + n > n3) {
            n = this.resizer.grow(n3, n2, n);
            this.buffer = Arrays.copyOf(this.buffer, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        long[] lArray = this.buffer;
        int n2 = lArray == null ? 0 : lArray.length;
        if (n > n2) {
            this.ensureBufferSpace(n - this.size());
        }
    }

    protected boolean equalElements(LongArrayList longArrayList) {
        int n = this.size();
        if (longArrayList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (longArrayList.get(i) == this.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongArrayList)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongPredicate> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends LongPredicate> T forEach(T t, int n, int n2) {
        long[] lArray = this.buffer;
        while (n < n2 && t.apply(lArray[n])) {
            ++n;
        }
        return t;
    }

    @Override
    public <T extends LongProcedure> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends LongProcedure> T forEach(T t, int n, int n2) {
        long[] lArray = this.buffer;
        while (n < n2) {
            t.apply(lArray[n]);
            ++n;
        }
        return t;
    }

    @Override
    public long get(int n) {
        return this.buffer[n];
    }

    public int hashCode() {
        int n = this.elementsCount;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + BitMixer.mix(this.buffer[i]);
        }
        return n2;
    }

    @Override
    public int indexOf(long l) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (this.buffer[i] != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insert(int n, long l) {
        this.ensureBufferSpace(1);
        long[] lArray = this.buffer;
        System.arraycopy(lArray, n, lArray, n + 1, this.elementsCount - n);
        this.buffer[n] = l;
        ++this.elementsCount;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.elementsCount == 0;
        return bl;
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public int lastIndexOf(long l) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (this.buffer[i] != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public long remove(int n) {
        long[] lArray = this.buffer;
        long l = lArray[n];
        int n2 = n + 1;
        int n3 = this.elementsCount;
        if (n2 < n3) {
            System.arraycopy(lArray, n2, lArray, n, n3 - n - 1);
        }
        this.elementsCount = n = this.elementsCount - 1;
        this.buffer[n] = 0L;
        return l;
    }

    @Override
    public int removeAll(long l) {
        int n;
        int n2 = 0;
        for (int i = 0; i < (n = this.elementsCount); ++i) {
            long[] lArray = this.buffer;
            if (lArray[i] == l) {
                lArray[i] = 0L;
                continue;
            }
            if (n2 != i) {
                lArray[n2] = lArray[i];
                lArray[i] = 0L;
            }
            ++n2;
        }
        this.elementsCount = n2;
        return n - n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n;
        int n2;
        long[] lArray = this.buffer;
        int n3 = this.elementsCount;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            n2 = ++n4;
            n = ++n5;
            if (n4 >= n3) break;
            try {
                if (longPredicate.apply(lArray[n4])) {
                    lArray[n4] = 0L;
                    continue;
                }
                if (n5 == n4) continue;
            }
            catch (Throwable throwable) {
                while (true) {
                    if (n4 >= n3) {
                        this.elementsCount = n5;
                        throw throwable;
                    }
                    if (n5 != n4) {
                        lArray[n5] = lArray[n4];
                        lArray[n4] = 0L;
                    }
                    ++n5;
                    ++n4;
                }
            }
            lArray[n5] = lArray[n4];
            lArray[n4] = 0L;
        }
        while (true) {
            if (n2 >= n3) {
                this.elementsCount = n;
                return n3 - n;
            }
            if (n != n2) {
                lArray[n] = lArray[n2];
                lArray[n2] = 0L;
            }
            ++n;
            ++n2;
        }
    }

    @Override
    public int removeFirst(long l) {
        int n = this.indexOf(l);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public int removeLast(long l) {
        int n = this.lastIndexOf(l);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public void removeRange(int n, int n2) {
        long[] lArray = this.buffer;
        System.arraycopy(lArray, n2, lArray, n, this.elementsCount - n2);
        n2 -= n;
        this.elementsCount = n = this.elementsCount - n2;
        Arrays.fill(this.buffer, n, n2 + n, 0L);
    }

    public void resize(int n) {
        long[] lArray = this.buffer;
        if (n <= lArray.length) {
            int n2 = this.elementsCount;
            if (n < n2) {
                Arrays.fill(lArray, n, n2, 0L);
            } else {
                Arrays.fill(lArray, n2, n, 0L);
            }
        } else {
            this.ensureCapacity(n);
        }
        this.elementsCount = n;
    }

    @Override
    public long set(int n, long l) {
        long[] lArray = this.buffer;
        long l2 = lArray[n];
        lArray[n] = l;
        return l2;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public long[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    static final class ValueIterator
    extends AbstractIterator<LongCursor> {
        private final long[] buffer;
        private final LongCursor cursor;
        private final int size;

        public ValueIterator(long[] lArray, int n) {
            LongCursor longCursor;
            this.cursor = longCursor = new LongCursor();
            longCursor.index = -1;
            this.size = n;
            this.buffer = lArray;
        }

        @Override
        protected LongCursor fetch() {
            int n;
            if (this.cursor.index + 1 == this.size) {
                return (LongCursor)this.done();
            }
            LongCursor longCursor = this.cursor;
            long[] lArray = this.buffer;
            longCursor.index = n = longCursor.index + 1;
            longCursor.value = lArray[n];
            return this.cursor;
        }
    }
}

