/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongByteAssociativeContainer;
import com.carrotsearch.hppc.LongByteMap;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.LongByteCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.LongBytePredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.LongByteProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongByteHashMap
implements LongByteMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public long[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public byte[] values;

    public LongByteHashMap() {
        this(4);
    }

    public LongByteHashMap(int n) {
        this(n, 0.75);
    }

    public LongByteHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public LongByteHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public LongByteHashMap(LongByteAssociativeContainer longByteAssociativeContainer) {
        this(longByteAssociativeContainer.size());
        this.putAll(longByteAssociativeContainer);
    }

    public static LongByteHashMap from(long[] lArray, byte[] byArray) {
        if (lArray.length == byArray.length) {
            LongByteHashMap longByteHashMap = new LongByteHashMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longByteHashMap.put(lArray[i], byArray[i]);
            }
            return longByteHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public byte addTo(long l, byte by) {
        return this.putOrAdd(l, by, by);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        long[] lArray = this.keys;
        byte[] byArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new long[n3];
            this.values = new byte[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = lArray;
            this.values = byArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, long l, byte by) {
        long[] lArray = this.keys;
        byte[] byArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        lArray[n] = l;
        byArray[n] = by;
        this.rehash(lArray, byArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    public LongByteHashMap clone() {
        try {
            LongByteHashMap longByteHashMap = (LongByteHashMap)super.clone();
            longByteHashMap.keys = (long[])this.keys.clone();
            longByteHashMap.values = (byte[])this.values.clone();
            longByteHashMap.hasEmptyKey = longByteHashMap.hasEmptyKey;
            longByteHashMap.orderMixer = this.orderMixer.clone();
            return longByteHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(long l) {
        long l2;
        if (l == 0L) {
            return this.hasEmptyKey;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            long[] lArray = this.keys;
            byte[] byArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (lArray != null && !this.isEmpty()) {
                this.rehash(lArray, byArray);
            }
        }
    }

    protected boolean equalElements(LongByteHashMap object) {
        if (((LongByteHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((LongByteHashMap)object).iterator();
        while (object.hasNext()) {
            LongByteCursor longByteCursor = (LongByteCursor)object.next();
            long l = longByteCursor.key;
            if (this.containsKey(l) && this.get(l) == longByteCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongByteHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongBytePredicate> T forEach(T t) {
        long[] lArray = this.keys;
        byte[] byArray = this.values;
        if (this.hasEmptyKey && !t.apply(0L, byArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (lArray[i] == 0L || t.apply(lArray[i], byArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends LongByteProcedure> T forEach(T t) {
        long[] lArray = this.keys;
        byte[] byArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(0L, byArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (lArray[i] == 0L) continue;
            t.apply(lArray[i], byArray[i]);
        }
        return t;
    }

    @Override
    public byte get(long l) {
        long l2;
        int n = 0;
        if (l == 0L) {
            int n2 = n;
            if (this.hasEmptyKey) {
                n2 = n = this.values[this.mask + 1];
            }
            return (byte)n2;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        n = this.hashKey(l);
        while ((l2 = lArray[n &= n3]) != 0L) {
            if (l2 == l) {
                return this.values[n];
            }
            ++n;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(long l, byte by) {
        long l2;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                byte by2;
                by = by2 = this.values[this.mask + 1];
            }
            return by;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return this.values[n2];
            }
            ++n2;
        }
        return by;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (LongByteCursor longByteCursor : this) {
            n += BitMixer.mix(longByteCursor.key) + BitMixer.mix(longByteCursor.value);
        }
        return n;
    }

    protected int hashKey(long l) {
        return BitMixer.mix(l, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public byte indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, long l, byte by) {
        if (l == 0L) {
            this.values[n] = by;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, l, by);
            } else {
                this.keys[n] = l;
                this.values[n] = by;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public byte indexReplace(int n, byte by) {
        byte[] byArray = this.values;
        byte by2 = byArray[n];
        byArray[n] = by;
        return by2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public byte put(long l, byte by) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = true;
            byte[] byArray = this.values;
            int n2 = n + 1;
            byte by2 = byArray[n2];
            byArray[n2] = by;
            return by2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = objectArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                objectArray = this.values;
                long l3 = objectArray[n3];
                objectArray[n3] = by;
                return (byte)l3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, l, by);
        } else {
            objectArray[n3] = l;
            this.values[n3] = by;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(LongByteAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            LongByteCursor longByteCursor = (LongByteCursor)object.next();
            this.put(longByteCursor.key, longByteCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends LongByteCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            LongByteCursor longByteCursor = (LongByteCursor)object.next();
            this.put(longByteCursor.key, longByteCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(long l, byte by) {
        int n = this.indexOf(l);
        if (!this.indexExists(n)) {
            this.indexInsert(n, l, by);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(long l, byte by, byte by2) {
        int n = this.indexOf(l);
        if (this.indexExists(n)) {
            by = (byte)(this.values[n] + by2);
            this.indexReplace(n, by);
        } else {
            this.indexInsert(n, l, by);
        }
        return by;
    }

    protected void rehash(long[] lArray, byte[] byArray) {
        int n;
        long[] lArray2 = this.keys;
        byte[] byArray2 = this.values;
        int n2 = this.mask;
        int n3 = lArray.length - 1;
        lArray2[lArray2.length - 1] = lArray[n3];
        byArray2[byArray2.length - 1] = byArray[n3];
        while ((n = n3 - 1) >= 0) {
            long l = lArray[n];
            n3 = n;
            if (l == 0L) continue;
            n3 = this.hashKey(l);
            while (lArray2[n3 &= n2] != 0L) {
                ++n3;
            }
            lArray2[n3] = l;
            byArray2[n3] = byArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public byte remove(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = false;
            byte[] byArray = this.values;
            int n2 = n + 1;
            byte by = byArray[n2];
            byArray[n2] = (byte)0;
            return by;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                byte by = this.values[n3];
                this.shiftConflictingKeys(n3);
                return by;
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int removeAll(LongContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof LongLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (byte)0;
            }
            long[] lArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                long l = lArray[n2];
                if (l != 0L && object.contains(l)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((LongCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(LongBytePredicate longBytePredicate) {
        int n;
        byte[] byArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && longBytePredicate.apply(0L, (byArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (byte)0;
        }
        long[] lArray = this.keys;
        byArray = this.values;
        while (n4 <= n3) {
            long l = lArray[n4];
            if (l != 0L && longBytePredicate.apply(l, byArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && longPredicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (byte)0;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            long l = lArray[n2];
            if (l != 0L && longPredicate.apply(l)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        long[] lArray = this.keys;
        byte[] byArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            long l;
            int n4;
            int n5 = 0;
            do {
                if ((l = lArray[n4 = n + (n3 = n5 + 1) & n2]) == 0L) {
                    lArray[n] = 0L;
                    byArray[n] = (byte)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(l) & n2) < n3);
            lArray[n] = l;
            byArray[n] = byArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<LongByteCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            LongByteCursor longByteCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(longByteCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(longByteCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<LongByteCursor> {
        private final LongByteCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongByteCursor();
        }

        @Override
        protected LongByteCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongByteHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.key = l;
                        this.cursor.value = LongByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongByteCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongByteHashMap owner;

        public KeysContainer() {
            this.owner = LongByteHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            return this.owner.containsKey(l);
        }

        @Override
        public <T extends LongPredicate> T forEach(final T t) {
            this.owner.forEach(new LongBytePredicate(){

                @Override
                public boolean apply(long l, byte by) {
                    return t.apply(l);
                }
            });
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(final T t) {
            this.owner.forEach(new LongByteProcedure(){

                @Override
                public void apply(long l, byte by) {
                    t.apply(l);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(long l) {
            if (this.owner.containsKey(l)) {
                this.owner.remove(l);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(LongPredicate longPredicate) {
            return this.owner.removeAll(longPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongByteHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = l;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final LongByteHashMap owner;

        private ValuesContainer() {
            this.owner = LongByteHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(byte by) {
            Iterator<LongByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != by) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends BytePredicate> T forEach(T t) {
            Iterator<LongByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T t) {
            Iterator<LongByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final byte by) {
            return this.owner.removeAll(new LongBytePredicate(){

                @Override
                public boolean apply(long l, byte by2) {
                    boolean bl = by2 == by;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final BytePredicate bytePredicate) {
            return this.owner.removeAll(new LongBytePredicate(){

                @Override
                public boolean apply(long l, byte by) {
                    return bytePredicate.apply(by);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongByteHashMap.this.keys;
                    n = this.slot;
                    if (lArray[n] != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = LongByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }
}

