/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongByteHashMap;

public class LongByteScatterMap
extends LongByteHashMap {
    public LongByteScatterMap() {
        this(4);
    }

    public LongByteScatterMap(int n) {
        this(n, 0.75);
    }

    public LongByteScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static LongByteScatterMap from(long[] lArray, byte[] byArray) {
        if (lArray.length == byArray.length) {
            LongByteScatterMap longByteScatterMap = new LongByteScatterMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longByteScatterMap.put(lArray[i], byArray[i]);
            }
            return longByteScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(long l) {
        return BitMixer.mixPhi(l);
    }
}

