/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongCharAssociativeContainer;
import com.carrotsearch.hppc.LongCharMap;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.LongCharCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.LongCharPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.LongCharProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongCharHashMap
implements LongCharMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public long[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public char[] values;

    public LongCharHashMap() {
        this(4);
    }

    public LongCharHashMap(int n) {
        this(n, 0.75);
    }

    public LongCharHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public LongCharHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public LongCharHashMap(LongCharAssociativeContainer longCharAssociativeContainer) {
        this(longCharAssociativeContainer.size());
        this.putAll(longCharAssociativeContainer);
    }

    public static LongCharHashMap from(long[] lArray, char[] cArray) {
        if (lArray.length == cArray.length) {
            LongCharHashMap longCharHashMap = new LongCharHashMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longCharHashMap.put(lArray[i], cArray[i]);
            }
            return longCharHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public char addTo(long l, char c) {
        return this.putOrAdd(l, c, c);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        long[] lArray = this.keys;
        char[] cArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new long[n3];
            this.values = new char[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = lArray;
            this.values = cArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, long l, char c) {
        long[] lArray = this.keys;
        char[] cArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        lArray[n] = l;
        cArray[n] = c;
        this.rehash(lArray, cArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    public LongCharHashMap clone() {
        try {
            LongCharHashMap longCharHashMap = (LongCharHashMap)super.clone();
            longCharHashMap.keys = (long[])this.keys.clone();
            longCharHashMap.values = (char[])this.values.clone();
            longCharHashMap.hasEmptyKey = longCharHashMap.hasEmptyKey;
            longCharHashMap.orderMixer = this.orderMixer.clone();
            return longCharHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(long l) {
        long l2;
        if (l == 0L) {
            return this.hasEmptyKey;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            long[] lArray = this.keys;
            char[] cArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (lArray != null && !this.isEmpty()) {
                this.rehash(lArray, cArray);
            }
        }
    }

    protected boolean equalElements(LongCharHashMap object) {
        if (((LongCharHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((LongCharHashMap)object).iterator();
        while (object.hasNext()) {
            LongCharCursor longCharCursor = (LongCharCursor)object.next();
            long l = longCharCursor.key;
            if (this.containsKey(l) && this.get(l) == longCharCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongCharHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongCharPredicate> T forEach(T t) {
        long[] lArray = this.keys;
        char[] cArray = this.values;
        if (this.hasEmptyKey && !t.apply(0L, cArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (lArray[i] == 0L || t.apply(lArray[i], cArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends LongCharProcedure> T forEach(T t) {
        long[] lArray = this.keys;
        char[] cArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(0L, cArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (lArray[i] == 0L) continue;
            t.apply(lArray[i], cArray[i]);
        }
        return t;
    }

    @Override
    public char get(long l) {
        long l2;
        int n = 0;
        if (l == 0L) {
            int n2 = n;
            if (this.hasEmptyKey) {
                n2 = n = this.values[this.mask + 1];
            }
            return (char)n2;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        n = this.hashKey(l);
        while ((l2 = lArray[n &= n3]) != 0L) {
            if (l2 == l) {
                return this.values[n];
            }
            ++n;
        }
        return '\u0000';
    }

    @Override
    public char getOrDefault(long l, char c) {
        long l2;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                char c2;
                c = c2 = this.values[this.mask + 1];
            }
            return c;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return this.values[n2];
            }
            ++n2;
        }
        return c;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (LongCharCursor longCharCursor : this) {
            n += BitMixer.mix(longCharCursor.key) + BitMixer.mix(longCharCursor.value);
        }
        return n;
    }

    protected int hashKey(long l) {
        return BitMixer.mix(l, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public char indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, long l, char c) {
        if (l == 0L) {
            this.values[n] = c;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, l, c);
            } else {
                this.keys[n] = l;
                this.values[n] = c;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public char indexReplace(int n, char c) {
        char[] cArray = this.values;
        char c2 = cArray[n];
        cArray[n] = c;
        return c2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongCharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public char put(long l, char c) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = true;
            char[] cArray = this.values;
            int n2 = n + 1;
            char c2 = cArray[n2];
            cArray[n2] = c;
            return c2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = objectArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                objectArray = this.values;
                long l3 = objectArray[n3];
                objectArray[n3] = c;
                return (char)l3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, l, c);
        } else {
            objectArray[n3] = l;
            this.values[n3] = c;
        }
        ++this.assigned;
        return '\u0000';
    }

    @Override
    public int putAll(LongCharAssociativeContainer object) {
        int n = this.size();
        Iterator<LongCharCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((LongCharCursor)object).key, ((LongCharCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends LongCharCursor> object) {
        int n = this.size();
        Iterator<? extends LongCharCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((LongCharCursor)object).key, ((LongCharCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(long l, char c) {
        int n = this.indexOf(l);
        if (!this.indexExists(n)) {
            this.indexInsert(n, l, c);
            return true;
        }
        return false;
    }

    @Override
    public char putOrAdd(long l, char c, char c2) {
        int n = this.indexOf(l);
        if (this.indexExists(n)) {
            c = (char)(this.values[n] + c2);
            this.indexReplace(n, c);
        } else {
            this.indexInsert(n, l, c);
        }
        return c;
    }

    protected void rehash(long[] lArray, char[] cArray) {
        int n;
        long[] lArray2 = this.keys;
        char[] cArray2 = this.values;
        int n2 = this.mask;
        int n3 = lArray.length - 1;
        lArray2[lArray2.length - 1] = lArray[n3];
        cArray2[cArray2.length - 1] = cArray[n3];
        while ((n = n3 - 1) >= 0) {
            long l = lArray[n];
            n3 = n;
            if (l == 0L) continue;
            n3 = this.hashKey(l);
            while (lArray2[n3 &= n2] != 0L) {
                ++n3;
            }
            lArray2[n3] = l;
            cArray2[n3] = cArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public char remove(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = false;
            char[] cArray = this.values;
            int n2 = n + 1;
            char c = cArray[n2];
            cArray[n2] = (char)0;
            return c;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                char c = this.values[n3];
                this.shiftConflictingKeys(n3);
                return c;
            }
            ++n3;
        }
        return '\u0000';
    }

    @Override
    public int removeAll(LongContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof LongLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (char)0;
            }
            long[] lArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                long l = lArray[n2];
                if (l != 0L && object.contains(l)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((LongCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(LongCharPredicate longCharPredicate) {
        int n;
        char[] cArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && longCharPredicate.apply(0L, (cArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (char)0;
        }
        long[] lArray = this.keys;
        cArray = this.values;
        while (n4 <= n3) {
            long l = lArray[n4];
            if (l != 0L && longCharPredicate.apply(l, cArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && longPredicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (char)0;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            long l = lArray[n2];
            if (l != 0L && longPredicate.apply(l)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        long[] lArray = this.keys;
        char[] cArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            long l;
            int n4;
            int n5 = 0;
            do {
                if ((l = lArray[n4 = n + (n3 = n5 + 1) & n2]) == 0L) {
                    lArray[n] = 0L;
                    cArray[n] = (char)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(l) & n2) < n3);
            lArray[n] = l;
            cArray[n] = cArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<LongCharCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            LongCharCursor longCharCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(longCharCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(longCharCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public CharCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<LongCharCursor> {
        private final LongCharCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCharCursor();
        }

        @Override
        protected LongCharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongCharHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.key = l;
                        this.cursor.value = LongCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongCharCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongCharHashMap owner;

        public KeysContainer() {
            this.owner = LongCharHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            return this.owner.containsKey(l);
        }

        @Override
        public <T extends LongPredicate> T forEach(final T t) {
            this.owner.forEach(new LongCharPredicate(){

                @Override
                public boolean apply(long l, char c) {
                    return t.apply(l);
                }
            });
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(final T t) {
            this.owner.forEach(new LongCharProcedure(){

                @Override
                public void apply(long l, char c) {
                    t.apply(l);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(long l) {
            if (this.owner.containsKey(l)) {
                this.owner.remove(l);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(LongPredicate longPredicate) {
            return this.owner.removeAll(longPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongCharHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = l;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final LongCharHashMap owner;

        private ValuesContainer() {
            this.owner = LongCharHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            Iterator<LongCharCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != c) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharPredicate> T forEach(T t) {
            Iterator<LongCharCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(T t) {
            Iterator<LongCharCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final char c) {
            return this.owner.removeAll(new LongCharPredicate(){

                @Override
                public boolean apply(long l, char c2) {
                    boolean bl = c2 == c;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final CharPredicate charPredicate) {
            return this.owner.removeAll(new LongCharPredicate(){

                @Override
                public boolean apply(long l, char c) {
                    return charPredicate.apply(c);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongCharHashMap.this.keys;
                    n = this.slot;
                    if (lArray[n] != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = LongCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

