/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongCharHashMap;

public class LongCharScatterMap
extends LongCharHashMap {
    public LongCharScatterMap() {
        this(4);
    }

    public LongCharScatterMap(int n) {
        this(n, 0.75);
    }

    public LongCharScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static LongCharScatterMap from(long[] lArray, char[] cArray) {
        if (lArray.length == cArray.length) {
            LongCharScatterMap longCharScatterMap = new LongCharScatterMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longCharScatterMap.put(lArray[i], cArray[i]);
            }
            return longCharScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(long l) {
        return BitMixer.mixPhi(l);
    }
}

