/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.DoubleCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongDoubleAssociativeContainer;
import com.carrotsearch.hppc.LongDoubleMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.LongDoublePredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.LongDoubleProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongDoubleHashMap
implements LongDoubleMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public long[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public double[] values;

    public LongDoubleHashMap() {
        this(4);
    }

    public LongDoubleHashMap(int n) {
        this(n, 0.75);
    }

    public LongDoubleHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public LongDoubleHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public LongDoubleHashMap(LongDoubleAssociativeContainer longDoubleAssociativeContainer) {
        this(longDoubleAssociativeContainer.size());
        this.putAll(longDoubleAssociativeContainer);
    }

    public static LongDoubleHashMap from(long[] lArray, double[] dArray) {
        if (lArray.length == dArray.length) {
            LongDoubleHashMap longDoubleHashMap = new LongDoubleHashMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longDoubleHashMap.put(lArray[i], dArray[i]);
            }
            return longDoubleHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public double addTo(long l, double d) {
        return this.putOrAdd(l, d, d);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        long[] lArray = this.keys;
        double[] dArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new long[n3];
            this.values = new double[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = lArray;
            this.values = dArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, long l, double d) {
        long[] lArray = this.keys;
        double[] dArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        lArray[n] = l;
        dArray[n] = d;
        this.rehash(lArray, dArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    public LongDoubleHashMap clone() {
        try {
            LongDoubleHashMap longDoubleHashMap = (LongDoubleHashMap)super.clone();
            longDoubleHashMap.keys = (long[])this.keys.clone();
            longDoubleHashMap.values = (double[])this.values.clone();
            longDoubleHashMap.hasEmptyKey = longDoubleHashMap.hasEmptyKey;
            longDoubleHashMap.orderMixer = this.orderMixer.clone();
            return longDoubleHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(long l) {
        long l2;
        if (l == 0L) {
            return this.hasEmptyKey;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            long[] lArray = this.keys;
            double[] dArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (lArray != null && !this.isEmpty()) {
                this.rehash(lArray, dArray);
            }
        }
    }

    protected boolean equalElements(LongDoubleHashMap object) {
        if (((LongDoubleHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((LongDoubleHashMap)object).iterator();
        while (object.hasNext()) {
            LongDoubleCursor longDoubleCursor = (LongDoubleCursor)object.next();
            long l = longDoubleCursor.key;
            if (this.containsKey(l) && Double.doubleToLongBits(this.get(l)) == Double.doubleToLongBits(longDoubleCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongDoubleHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongDoublePredicate> T forEach(T t) {
        long[] lArray = this.keys;
        double[] dArray = this.values;
        if (this.hasEmptyKey && !t.apply(0L, dArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (lArray[i] == 0L || t.apply(lArray[i], dArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends LongDoubleProcedure> T forEach(T t) {
        long[] lArray = this.keys;
        double[] dArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(0L, dArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (lArray[i] == 0L) continue;
            t.apply(lArray[i], dArray[i]);
        }
        return t;
    }

    @Override
    public double get(long l) {
        long l2;
        double d = 0.0;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0.0;
    }

    @Override
    public double getOrDefault(long l, double d) {
        long l2;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return this.values[n2];
            }
            ++n2;
        }
        return d;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (LongDoubleCursor longDoubleCursor : this) {
            n += BitMixer.mix(longDoubleCursor.key) + BitMixer.mix(longDoubleCursor.value);
        }
        return n;
    }

    protected int hashKey(long l) {
        return BitMixer.mix(l, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public double indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, long l, double d) {
        if (l == 0L) {
            this.values[n] = d;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, l, d);
            } else {
                this.keys[n] = l;
                this.values[n] = d;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public double indexReplace(int n, double d) {
        double[] dArray = this.values;
        double d2 = dArray[n];
        dArray[n] = d;
        return d2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongDoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public double put(long l, double d) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = true;
            double[] dArray = this.values;
            int n2 = n + 1;
            double d2 = dArray[n2];
            dArray[n2] = d;
            return d2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = objectArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                objectArray = this.values;
                long l3 = objectArray[n3];
                objectArray[n3] = (long)d;
                return l3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, l, d);
        } else {
            objectArray[n3] = l;
            this.values[n3] = d;
        }
        ++this.assigned;
        return 0.0;
    }

    @Override
    public int putAll(LongDoubleAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            LongDoubleCursor longDoubleCursor = (LongDoubleCursor)object.next();
            this.put(longDoubleCursor.key, longDoubleCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends LongDoubleCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            LongDoubleCursor longDoubleCursor = (LongDoubleCursor)object.next();
            this.put(longDoubleCursor.key, longDoubleCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(long l, double d) {
        int n = this.indexOf(l);
        if (!this.indexExists(n)) {
            this.indexInsert(n, l, d);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(long l, double d, double d2) {
        int n = this.indexOf(l);
        if (this.indexExists(n)) {
            d = this.values[n] + d2;
            this.indexReplace(n, d);
        } else {
            this.indexInsert(n, l, d);
        }
        return d;
    }

    protected void rehash(long[] lArray, double[] dArray) {
        int n;
        long[] lArray2 = this.keys;
        double[] dArray2 = this.values;
        int n2 = this.mask;
        int n3 = lArray.length - 1;
        lArray2[lArray2.length - 1] = lArray[n3];
        dArray2[dArray2.length - 1] = dArray[n3];
        while ((n = n3 - 1) >= 0) {
            long l = lArray[n];
            n3 = n;
            if (l == 0L) continue;
            n3 = this.hashKey(l);
            while (lArray2[n3 &= n2] != 0L) {
                ++n3;
            }
            lArray2[n3] = l;
            dArray2[n3] = dArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public double remove(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = false;
            double[] dArray = this.values;
            int n2 = n + 1;
            double d = dArray[n2];
            dArray[n2] = 0.0;
            return d;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                double d = this.values[n3];
                this.shiftConflictingKeys(n3);
                return d;
            }
            ++n3;
        }
        return 0.0;
    }

    @Override
    public int removeAll(LongContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof LongLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0;
            }
            long[] lArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                long l = lArray[n2];
                if (l != 0L && object.contains(l)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((LongCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(LongDoublePredicate longDoublePredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && longDoublePredicate.apply(0L, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0;
        }
        objectArray = this.keys;
        double[] dArray = this.values;
        while (n4 <= n3) {
            double d = objectArray[n4];
            if (d != 0L && longDoublePredicate.apply((long)d, dArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && longPredicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            long l = lArray[n2];
            if (l != 0L && longPredicate.apply(l)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        long[] lArray = this.keys;
        double[] dArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            long l;
            int n4;
            int n5 = 0;
            do {
                if ((l = lArray[n4 = n + (n3 = n5 + 1) & n2]) == 0L) {
                    lArray[n] = 0L;
                    dArray[n] = 0.0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(l) & n2) < n3);
            lArray[n] = l;
            dArray[n] = dArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<LongDoubleCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            LongDoubleCursor longDoubleCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(longDoubleCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(longDoubleCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public DoubleCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<LongDoubleCursor> {
        private final LongDoubleCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongDoubleCursor();
        }

        @Override
        protected LongDoubleCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongDoubleHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.key = l;
                        this.cursor.value = LongDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongDoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongDoubleHashMap owner;

        public KeysContainer() {
            this.owner = LongDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            return this.owner.containsKey(l);
        }

        @Override
        public <T extends LongPredicate> T forEach(final T t) {
            this.owner.forEach(new LongDoublePredicate(){

                @Override
                public boolean apply(long l, double d) {
                    return t.apply(l);
                }
            });
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(final T t) {
            this.owner.forEach(new LongDoubleProcedure(){

                @Override
                public void apply(long l, double d) {
                    t.apply(l);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(long l) {
            if (this.owner.containsKey(l)) {
                this.owner.remove(l);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(LongPredicate longPredicate) {
            return this.owner.removeAll(longPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongDoubleHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = l;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final LongDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = LongDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(double d) {
            Iterator<LongDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Double.doubleToLongBits(iterator.next().value) != Double.doubleToLongBits(d)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T t) {
            Iterator<LongDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T t) {
            Iterator<LongDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final double d) {
            return this.owner.removeAll(new LongDoublePredicate(){

                @Override
                public boolean apply(long l, double d2) {
                    boolean bl = Double.doubleToLongBits(d2) == Double.doubleToLongBits(d);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final DoublePredicate doublePredicate) {
            return this.owner.removeAll(new LongDoublePredicate(){

                @Override
                public boolean apply(long l, double d) {
                    return doublePredicate.apply(d);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongDoubleHashMap.this.keys;
                    n = this.slot;
                    if (lArray[n] != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = LongDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }
}

