/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongDoubleHashMap;

public class LongDoubleScatterMap
extends LongDoubleHashMap {
    public LongDoubleScatterMap() {
        this(4);
    }

    public LongDoubleScatterMap(int n) {
        this(n, 0.75);
    }

    public LongDoubleScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static LongDoubleScatterMap from(long[] lArray, double[] dArray) {
        if (lArray.length == dArray.length) {
            LongDoubleScatterMap longDoubleScatterMap = new LongDoubleScatterMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longDoubleScatterMap.put(lArray[i], dArray[i]);
            }
            return longDoubleScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(long l) {
        return BitMixer.mixPhi(l);
    }
}

