/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongFloatAssociativeContainer;
import com.carrotsearch.hppc.LongFloatMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.LongFloatPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.LongFloatProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongFloatHashMap
implements LongFloatMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public long[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public float[] values;

    public LongFloatHashMap() {
        this(4);
    }

    public LongFloatHashMap(int n) {
        this(n, 0.75);
    }

    public LongFloatHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public LongFloatHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public LongFloatHashMap(LongFloatAssociativeContainer longFloatAssociativeContainer) {
        this(longFloatAssociativeContainer.size());
        this.putAll(longFloatAssociativeContainer);
    }

    public static LongFloatHashMap from(long[] lArray, float[] fArray) {
        if (lArray.length == fArray.length) {
            LongFloatHashMap longFloatHashMap = new LongFloatHashMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longFloatHashMap.put(lArray[i], fArray[i]);
            }
            return longFloatHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public float addTo(long l, float f) {
        return this.putOrAdd(l, f, f);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        long[] lArray = this.keys;
        float[] fArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new long[n3];
            this.values = new float[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = lArray;
            this.values = fArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, long l, float f) {
        long[] lArray = this.keys;
        float[] fArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        lArray[n] = l;
        fArray[n] = f;
        this.rehash(lArray, fArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    public LongFloatHashMap clone() {
        try {
            LongFloatHashMap longFloatHashMap = (LongFloatHashMap)super.clone();
            longFloatHashMap.keys = (long[])this.keys.clone();
            longFloatHashMap.values = (float[])this.values.clone();
            longFloatHashMap.hasEmptyKey = longFloatHashMap.hasEmptyKey;
            longFloatHashMap.orderMixer = this.orderMixer.clone();
            return longFloatHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(long l) {
        long l2;
        if (l == 0L) {
            return this.hasEmptyKey;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            long[] lArray = this.keys;
            float[] fArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (lArray != null && !this.isEmpty()) {
                this.rehash(lArray, fArray);
            }
        }
    }

    protected boolean equalElements(LongFloatHashMap object) {
        if (((LongFloatHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<LongFloatCursor> iterator = ((LongFloatHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            long l = ((LongFloatCursor)object).key;
            if (this.containsKey(l) && Float.floatToIntBits(this.get(l)) == Float.floatToIntBits(((LongFloatCursor)object).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongFloatHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongFloatPredicate> T forEach(T t) {
        long[] lArray = this.keys;
        float[] fArray = this.values;
        if (this.hasEmptyKey && !t.apply(0L, fArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (lArray[i] == 0L || t.apply(lArray[i], fArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends LongFloatProcedure> T forEach(T t) {
        long[] lArray = this.keys;
        float[] fArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(0L, fArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (lArray[i] == 0L) continue;
            t.apply(lArray[i], fArray[i]);
        }
        return t;
    }

    @Override
    public float get(long l) {
        long l2;
        float f = 0.0f;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0.0f;
    }

    @Override
    public float getOrDefault(long l, float f) {
        long l2;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return this.values[n2];
            }
            ++n2;
        }
        return f;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (LongFloatCursor longFloatCursor : this) {
            n += BitMixer.mix(longFloatCursor.key) + BitMixer.mix(longFloatCursor.value);
        }
        return n;
    }

    protected int hashKey(long l) {
        return BitMixer.mix(l, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public float indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, long l, float f) {
        if (l == 0L) {
            this.values[n] = f;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, l, f);
            } else {
                this.keys[n] = l;
                this.values[n] = f;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public float indexReplace(int n, float f) {
        float[] fArray = this.values;
        float f2 = fArray[n];
        fArray[n] = f;
        return f2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongFloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public float put(long l, float f) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = true;
            float[] fArray = this.values;
            int n2 = n + 1;
            float f2 = fArray[n2];
            fArray[n2] = f;
            return f2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = objectArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                objectArray = this.values;
                long l3 = objectArray[n3];
                objectArray[n3] = (long)f;
                return l3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, l, f);
        } else {
            objectArray[n3] = l;
            this.values[n3] = f;
        }
        ++this.assigned;
        return 0.0f;
    }

    @Override
    public int putAll(LongFloatAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            LongFloatCursor longFloatCursor = (LongFloatCursor)object.next();
            this.put(longFloatCursor.key, longFloatCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends LongFloatCursor> object) {
        int n = this.size();
        Iterator<? extends LongFloatCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((LongFloatCursor)object).key, ((LongFloatCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(long l, float f) {
        int n = this.indexOf(l);
        if (!this.indexExists(n)) {
            this.indexInsert(n, l, f);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(long l, float f, float f2) {
        int n = this.indexOf(l);
        if (this.indexExists(n)) {
            f = this.values[n] + f2;
            this.indexReplace(n, f);
        } else {
            this.indexInsert(n, l, f);
        }
        return f;
    }

    protected void rehash(long[] lArray, float[] fArray) {
        int n;
        long[] lArray2 = this.keys;
        float[] fArray2 = this.values;
        int n2 = this.mask;
        int n3 = lArray.length - 1;
        lArray2[lArray2.length - 1] = lArray[n3];
        fArray2[fArray2.length - 1] = fArray[n3];
        while ((n = n3 - 1) >= 0) {
            long l = lArray[n];
            n3 = n;
            if (l == 0L) continue;
            n3 = this.hashKey(l);
            while (lArray2[n3 &= n2] != 0L) {
                ++n3;
            }
            lArray2[n3] = l;
            fArray2[n3] = fArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public float remove(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = false;
            float[] fArray = this.values;
            int n2 = n + 1;
            float f = fArray[n2];
            fArray[n2] = 0.0f;
            return f;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                float f = this.values[n3];
                this.shiftConflictingKeys(n3);
                return f;
            }
            ++n3;
        }
        return 0.0f;
    }

    @Override
    public int removeAll(LongContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof LongLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0f;
            }
            long[] lArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                long l = lArray[n2];
                if (l != 0L && object.contains(l)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((LongCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(LongFloatPredicate longFloatPredicate) {
        int n;
        float[] fArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && longFloatPredicate.apply(0L, (fArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0f;
        }
        long[] lArray = this.keys;
        fArray = this.values;
        while (n4 <= n3) {
            long l = lArray[n4];
            if (l != 0L && longFloatPredicate.apply(l, fArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && longPredicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0f;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            long l = lArray[n2];
            if (l != 0L && longPredicate.apply(l)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        long[] lArray = this.keys;
        float[] fArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            long l;
            int n4;
            int n5 = 0;
            do {
                if ((l = lArray[n4 = n + (n3 = n5 + 1) & n2]) == 0L) {
                    lArray[n] = 0L;
                    fArray[n] = 0.0f;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(l) & n2) < n3);
            lArray[n] = l;
            fArray[n] = fArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<LongFloatCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            LongFloatCursor longFloatCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(longFloatCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(longFloatCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public FloatCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<LongFloatCursor> {
        private final LongFloatCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongFloatCursor();
        }

        @Override
        protected LongFloatCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongFloatHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.key = l;
                        this.cursor.value = LongFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongFloatCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongFloatHashMap owner;

        public KeysContainer() {
            this.owner = LongFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            return this.owner.containsKey(l);
        }

        @Override
        public <T extends LongPredicate> T forEach(final T t) {
            this.owner.forEach(new LongFloatPredicate(){

                @Override
                public boolean apply(long l, float f) {
                    return t.apply(l);
                }
            });
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(final T t) {
            this.owner.forEach(new LongFloatProcedure(){

                @Override
                public void apply(long l, float f) {
                    t.apply(l);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(long l) {
            if (this.owner.containsKey(l)) {
                this.owner.remove(l);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(LongPredicate longPredicate) {
            return this.owner.removeAll(longPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongFloatHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = l;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final LongFloatHashMap owner;

        private ValuesContainer() {
            this.owner = LongFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(float f) {
            Iterator<LongFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Float.floatToIntBits(iterator.next().value) != Float.floatToIntBits(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T t) {
            Iterator<LongFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T t) {
            Iterator<LongFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final float f) {
            return this.owner.removeAll(new LongFloatPredicate(){

                @Override
                public boolean apply(long l, float f2) {
                    boolean bl = Float.floatToIntBits(f2) == Float.floatToIntBits(f);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final FloatPredicate floatPredicate) {
            return this.owner.removeAll(new LongFloatPredicate(){

                @Override
                public boolean apply(long l, float f) {
                    return floatPredicate.apply(f);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new FloatCursor();
        }

        @Override
        protected FloatCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongFloatHashMap.this.keys;
                    n = this.slot;
                    if (lArray[n] != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = LongFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }
}

