/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongFloatHashMap;

public class LongFloatScatterMap
extends LongFloatHashMap {
    public LongFloatScatterMap() {
        this(4);
    }

    public LongFloatScatterMap(int n) {
        this(n, 0.75);
    }

    public LongFloatScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static LongFloatScatterMap from(long[] lArray, float[] fArray) {
        if (lArray.length == fArray.length) {
            LongFloatScatterMap longFloatScatterMap = new LongFloatScatterMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longFloatScatterMap.put(lArray[i], fArray[i]);
            }
            return longFloatScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(long l) {
        return BitMixer.mixPhi(l);
    }
}

