/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongHashSet
extends AbstractLongCollection
implements LongLookupContainer,
LongSet,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public long[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;

    public LongHashSet() {
        this(4, 0.75);
    }

    public LongHashSet(int n) {
        this(n, 0.75);
    }

    public LongHashSet(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public LongHashSet(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public LongHashSet(LongContainer longContainer) {
        this(longContainer.size());
        this.addAll(longContainer);
    }

    public static LongHashSet from(long ... lArray) {
        LongHashSet longHashSet = new LongHashSet(lArray.length);
        longHashSet.addAll(lArray);
        return longHashSet;
    }

    private boolean sameKeys(LongSet object) {
        if (object.size() != this.size()) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (this.contains(((LongCursor)object.next()).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(long l) {
        long l2;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = true;
            return bl ^ true;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return false;
            }
            ++n2;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n2, l);
        } else {
            lArray[n2] = l;
        }
        ++this.assigned;
        return true;
    }

    public int addAll(LongContainer longContainer) {
        this.ensureCapacity(longContainer.size());
        return this.addAll((Iterable<? extends LongCursor>)longContainer);
    }

    public int addAll(Iterable<? extends LongCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            if (!this.add(((LongCursor)object.next()).value)) continue;
            ++n;
        }
        return n;
    }

    public final int addAll(long ... lArray) {
        this.ensureCapacity(lArray.length);
        int n = lArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = n2;
            if (this.add(lArray[i])) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        long[] lArray = this.keys;
        try {
            this.keys = new long[n + 1];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = lArray;
            n2 = this.keys == null ? 0 : this.size();
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, long l) {
        long[] lArray = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        lArray[n] = l;
        this.rehash(lArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    public LongHashSet clone() {
        try {
            LongHashSet longHashSet = (LongHashSet)super.clone();
            longHashSet.keys = (long[])this.keys.clone();
            longHashSet.hasEmptyKey = longHashSet.hasEmptyKey;
            longHashSet.orderMixer = this.orderMixer.clone();
            return longHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(long l) {
        long l2;
        if (l == 0L) {
            return this.hasEmptyKey;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            long[] lArray = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (lArray != null && !this.isEmpty()) {
                this.rehash(lArray);
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.sameKeys((LongSet)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongPredicate> T forEach(T t) {
        long l;
        if (this.hasEmptyKey && !t.apply(0L)) {
            return t;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        for (int i = 0; i <= n && ((l = lArray[i]) == 0L || t.apply(l)); ++i) {
        }
        return t;
    }

    @Override
    public <T extends LongProcedure> T forEach(T t) {
        if (this.hasEmptyKey) {
            t.apply(0L);
        }
        long[] lArray = this.keys;
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            t.apply(l);
        }
        return t;
    }

    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        long[] lArray = this.keys;
        int n2 = n;
        for (int i = this.mask; i >= 0; --i) {
            long l = lArray[i];
            n = n2;
            if (l != 0L) {
                n = n2 + BitMixer.mix(l);
            }
            n2 = n;
        }
        return n2;
    }

    protected int hashKey(long l) {
        return BitMixer.mix(l, this.keyMixer);
    }

    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    public long indexGet(int n) {
        return this.keys[n];
    }

    public void indexInsert(int n, long l) {
        if (l == 0L) {
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, l);
            } else {
                this.keys[n] = l;
            }
            ++this.assigned;
        }
    }

    public int indexOf(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    public long indexReplace(int n, long l) {
        long[] lArray = this.keys;
        long l2 = lArray[n];
        lArray[n] = l;
        return l2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new EntryIterator();
    }

    protected void rehash(long[] lArray) {
        int n;
        long[] lArray2 = this.keys;
        int n2 = this.mask;
        int n3 = lArray.length - 1;
        while ((n = n3 - 1) >= 0) {
            long l = lArray[n];
            n3 = n;
            if (l == 0L) continue;
            n3 = this.hashKey(l);
            while (lArray2[n3 &= n2] != 0L) {
                ++n3;
            }
            lArray2[n3] = l;
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    public boolean remove(long l) {
        long l2;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return bl;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                this.shiftConflictingKeys(n2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int removeAll(long l) {
        return this.remove(l) ? 1 : 0;
    }

    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && longPredicate.apply(0L)) {
            this.hasEmptyKey = false;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            long l = lArray[n2];
            if (l != 0L && longPredicate.apply(l)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        long[] lArray = this.keys;
        int n2 = this.mask;
        while (true) {
            int n3;
            long l;
            int n4;
            int n5 = 0;
            do {
                if ((l = lArray[n4 = n + (n3 = n5 + 1) & n2]) == 0L) {
                    lArray[n] = 0L;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(l) & n2) < n3);
            lArray[n] = l;
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    @Override
    public long[] toArray() {
        int n;
        long[] lArray = new long[this.size()];
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl) {
            lArray[0] = 0L;
            n = 1;
        } else {
            n = 0;
        }
        long[] lArray2 = this.keys;
        int n3 = this.mask;
        int n4 = n;
        while (n2 <= n3) {
            long l = lArray2[n2];
            n = n4;
            if (l != 0L) {
                lArray[n4] = l;
                n = n4 + 1;
            }
            ++n2;
            n4 = n;
        }
        return lArray;
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    protected final class EntryIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongHashSet.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = l;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

