/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongIntAssociativeContainer;
import com.carrotsearch.hppc.LongIntMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.LongIntPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.LongIntProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongIntHashMap
implements LongIntMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public long[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public int[] values;

    public LongIntHashMap() {
        this(4);
    }

    public LongIntHashMap(int n) {
        this(n, 0.75);
    }

    public LongIntHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public LongIntHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public LongIntHashMap(LongIntAssociativeContainer longIntAssociativeContainer) {
        this(longIntAssociativeContainer.size());
        this.putAll(longIntAssociativeContainer);
    }

    public static LongIntHashMap from(long[] lArray, int[] nArray) {
        if (lArray.length == nArray.length) {
            LongIntHashMap longIntHashMap = new LongIntHashMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longIntHashMap.put(lArray[i], nArray[i]);
            }
            return longIntHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public int addTo(long l, int n) {
        return this.putOrAdd(l, n, n);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        long[] lArray = this.keys;
        int[] nArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new long[n3];
            this.values = new int[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = lArray;
            this.values = nArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, long l, int n2) {
        long[] lArray = this.keys;
        int[] nArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        lArray[n] = l;
        nArray[n] = n2;
        this.rehash(lArray, nArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    public LongIntHashMap clone() {
        try {
            LongIntHashMap longIntHashMap = (LongIntHashMap)super.clone();
            longIntHashMap.keys = (long[])this.keys.clone();
            longIntHashMap.values = (int[])this.values.clone();
            longIntHashMap.hasEmptyKey = longIntHashMap.hasEmptyKey;
            longIntHashMap.orderMixer = this.orderMixer.clone();
            return longIntHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(long l) {
        long l2;
        if (l == 0L) {
            return this.hasEmptyKey;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            long[] lArray = this.keys;
            int[] nArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (lArray != null && !this.isEmpty()) {
                this.rehash(lArray, nArray);
            }
        }
    }

    protected boolean equalElements(LongIntHashMap object) {
        if (((LongIntHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((LongIntHashMap)object).iterator();
        while (object.hasNext()) {
            LongIntCursor longIntCursor = (LongIntCursor)object.next();
            long l = longIntCursor.key;
            if (this.containsKey(l) && this.get(l) == longIntCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongIntHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongIntPredicate> T forEach(T t) {
        long[] lArray = this.keys;
        int[] nArray = this.values;
        if (this.hasEmptyKey && !t.apply(0L, nArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (lArray[i] == 0L || t.apply(lArray[i], nArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends LongIntProcedure> T forEach(T t) {
        long[] lArray = this.keys;
        int[] nArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(0L, nArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (lArray[i] == 0L) continue;
            t.apply(lArray[i], nArray[i]);
        }
        return t;
    }

    @Override
    public int get(long l) {
        long l2;
        int n = 0;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
            }
            return n;
        }
        long[] lArray = this.keys;
        int n2 = this.mask;
        n = this.hashKey(l);
        while ((l2 = lArray[n &= n2]) != 0L) {
            if (l2 == l) {
                return this.values[n];
            }
            ++n;
        }
        return 0;
    }

    @Override
    public int getOrDefault(long l, int n) {
        long l2;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
            }
            return n;
        }
        long[] lArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n2]) != 0L) {
            if (l2 == l) {
                return this.values[n3];
            }
            ++n3;
        }
        return n;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (LongIntCursor longIntCursor : this) {
            n += BitMixer.mix(longIntCursor.key) + BitMixer.mix(longIntCursor.value);
        }
        return n;
    }

    protected int hashKey(long l) {
        return BitMixer.mix(l, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public int indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, long l, int n2) {
        if (l == 0L) {
            this.values[n] = n2;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, l, n2);
            } else {
                this.keys[n] = l;
                this.values[n] = n2;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public int indexReplace(int n, int n2) {
        int[] nArray = this.values;
        int n3 = nArray[n];
        nArray[n] = n2;
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public int put(long l, int n) {
        long l2;
        int n2 = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = true;
            int[] nArray = this.values;
            int n3 = nArray[++n2];
            nArray[n2] = n;
            return n3;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(l);
        while ((l2 = objectArray[n4 &= n2]) != 0L) {
            if (l2 == l) {
                objectArray = this.values;
                n2 = (int)objectArray[n4];
                objectArray[n4] = n;
                return n2;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, l, n);
        } else {
            objectArray[n4] = l;
            this.values[n4] = n;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(LongIntAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            LongIntCursor longIntCursor = (LongIntCursor)object.next();
            this.put(longIntCursor.key, longIntCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends LongIntCursor> object) {
        int n = this.size();
        Iterator<? extends LongIntCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((LongIntCursor)object).key, ((LongIntCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(long l, int n) {
        int n2 = this.indexOf(l);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, l, n);
            return true;
        }
        return false;
    }

    @Override
    public int putOrAdd(long l, int n, int n2) {
        int n3 = this.indexOf(l);
        if (this.indexExists(n3)) {
            n = this.values[n3] + n2;
            this.indexReplace(n3, n);
        } else {
            this.indexInsert(n3, l, n);
        }
        return n;
    }

    protected void rehash(long[] lArray, int[] nArray) {
        int n;
        long[] lArray2 = this.keys;
        int[] nArray2 = this.values;
        int n2 = this.mask;
        int n3 = lArray.length - 1;
        lArray2[lArray2.length - 1] = lArray[n3];
        nArray2[nArray2.length - 1] = nArray[n3];
        while ((n = n3 - 1) >= 0) {
            long l = lArray[n];
            n3 = n;
            if (l == 0L) continue;
            n3 = this.hashKey(l);
            while (lArray2[n3 &= n2] != 0L) {
                ++n3;
            }
            lArray2[n3] = l;
            nArray2[n3] = nArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int remove(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = false;
            int[] nArray = this.values;
            int n2 = nArray[++n];
            nArray[n] = 0;
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                n = this.values[n3];
                this.shiftConflictingKeys(n3);
                return n;
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int removeAll(LongContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof LongLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            long[] lArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                long l = lArray[n2];
                if (l != 0L && object.contains(l)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((LongCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(LongIntPredicate longIntPredicate) {
        int n;
        int[] nArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && longIntPredicate.apply(0L, (nArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0;
        }
        long[] lArray = this.keys;
        nArray = this.values;
        while (n4 <= n3) {
            long l = lArray[n4];
            if (l != 0L && longIntPredicate.apply(l, nArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && longPredicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            long l = lArray[n2];
            if (l != 0L && longPredicate.apply(l)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        long[] lArray = this.keys;
        int[] nArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            long l;
            int n4;
            int n5 = 0;
            do {
                if ((l = lArray[n4 = n + (n3 = n5 + 1) & n2]) == 0L) {
                    lArray[n] = 0L;
                    nArray[n] = 0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(l) & n2) < n3);
            lArray[n] = l;
            nArray[n] = nArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<LongIntCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            LongIntCursor longIntCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(longIntCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(longIntCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public IntCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<LongIntCursor> {
        private final LongIntCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongIntCursor();
        }

        @Override
        protected LongIntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongIntHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.key = l;
                        this.cursor.value = LongIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongIntCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongIntHashMap owner;

        public KeysContainer() {
            this.owner = LongIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            return this.owner.containsKey(l);
        }

        @Override
        public <T extends LongPredicate> T forEach(final T t) {
            this.owner.forEach(new LongIntPredicate(){

                @Override
                public boolean apply(long l, int n) {
                    return t.apply(l);
                }
            });
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(final T t) {
            this.owner.forEach(new LongIntProcedure(){

                @Override
                public void apply(long l, int n) {
                    t.apply(l);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(long l) {
            if (this.owner.containsKey(l)) {
                this.owner.remove(l);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(LongPredicate longPredicate) {
            return this.owner.removeAll(longPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongIntHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = l;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final LongIntHashMap owner;

        private ValuesContainer() {
            this.owner = LongIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            Iterator<LongIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != n) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntPredicate> T forEach(T t) {
            Iterator<LongIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(T t) {
            Iterator<LongIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final int n) {
            return this.owner.removeAll(new LongIntPredicate(){

                @Override
                public boolean apply(long l, int n2) {
                    boolean bl = n2 == n;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final IntPredicate intPredicate) {
            return this.owner.removeAll(new LongIntPredicate(){

                @Override
                public boolean apply(long l, int n) {
                    return intPredicate.apply(n);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongIntHashMap.this.keys;
                    n = this.slot;
                    if (lArray[n] != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = LongIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

