/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongIntHashMap;

public class LongIntScatterMap
extends LongIntHashMap {
    public LongIntScatterMap() {
        this(4);
    }

    public LongIntScatterMap(int n) {
        this(n, 0.75);
    }

    public LongIntScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static LongIntScatterMap from(long[] lArray, int[] nArray) {
        if (lArray.length == nArray.length) {
            LongIntScatterMap longIntScatterMap = new LongIntScatterMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longIntScatterMap.put(lArray[i], nArray[i]);
            }
            return longIntScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(long l) {
        return BitMixer.mixPhi(l);
    }
}

