/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLongAssociativeContainer;
import com.carrotsearch.hppc.LongLongMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongLongCursor;
import com.carrotsearch.hppc.predicates.LongLongPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.LongLongProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongLongHashMap
implements LongLongMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public long[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public long[] values;

    public LongLongHashMap() {
        this(4);
    }

    public LongLongHashMap(int n) {
        this(n, 0.75);
    }

    public LongLongHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public LongLongHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public LongLongHashMap(LongLongAssociativeContainer longLongAssociativeContainer) {
        this(longLongAssociativeContainer.size());
        this.putAll(longLongAssociativeContainer);
    }

    public static LongLongHashMap from(long[] lArray, long[] lArray2) {
        if (lArray.length == lArray2.length) {
            LongLongHashMap longLongHashMap = new LongLongHashMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longLongHashMap.put(lArray[i], lArray2[i]);
            }
            return longLongHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public long addTo(long l, long l2) {
        return this.putOrAdd(l, l2, l2);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        long[] lArray = this.keys;
        long[] lArray2 = this.values;
        int n3 = n + 1;
        try {
            this.keys = new long[n3];
            this.values = new long[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = lArray;
            this.values = lArray2;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, long l, long l2) {
        long[] lArray = this.keys;
        long[] lArray2 = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        lArray[n] = l;
        lArray2[n] = l2;
        this.rehash(lArray, lArray2);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    public LongLongHashMap clone() {
        try {
            LongLongHashMap longLongHashMap = (LongLongHashMap)super.clone();
            longLongHashMap.keys = (long[])this.keys.clone();
            longLongHashMap.values = (long[])this.values.clone();
            longLongHashMap.hasEmptyKey = longLongHashMap.hasEmptyKey;
            longLongHashMap.orderMixer = this.orderMixer.clone();
            return longLongHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(long l) {
        long l2;
        if (l == 0L) {
            return this.hasEmptyKey;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            long[] lArray = this.keys;
            long[] lArray2 = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (lArray != null && !this.isEmpty()) {
                this.rehash(lArray, lArray2);
            }
        }
    }

    protected boolean equalElements(LongLongHashMap object) {
        if (((LongLongHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((LongLongHashMap)object).iterator();
        while (object.hasNext()) {
            LongLongCursor longLongCursor = (LongLongCursor)object.next();
            long l = longLongCursor.key;
            if (this.containsKey(l) && this.get(l) == longLongCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongLongHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongLongPredicate> T forEach(T t) {
        long[] lArray = this.keys;
        long[] lArray2 = this.values;
        if (this.hasEmptyKey && !t.apply(0L, lArray2[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (lArray[i] == 0L || t.apply(lArray[i], lArray2[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends LongLongProcedure> T forEach(T t) {
        long[] lArray = this.keys;
        long[] lArray2 = this.values;
        if (this.hasEmptyKey) {
            t.apply(0L, lArray2[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (lArray[i] == 0L) continue;
            t.apply(lArray[i], lArray2[i]);
        }
        return t;
    }

    @Override
    public long get(long l) {
        long l2 = 0L;
        if (l == 0L) {
            l = l2;
            if (this.hasEmptyKey) {
                l = this.values[this.mask + 1];
            }
            return l;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0L;
    }

    @Override
    public long getOrDefault(long l, long l2) {
        long l3;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                l2 = this.values[this.mask + 1];
            }
            return l2;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l3 = lArray[n2 &= n]) != 0L) {
            if (l3 == l) {
                return this.values[n2];
            }
            ++n2;
        }
        return l2;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (LongLongCursor longLongCursor : this) {
            n += BitMixer.mix(longLongCursor.key) + BitMixer.mix(longLongCursor.value);
        }
        return n;
    }

    protected int hashKey(long l) {
        return BitMixer.mix(l, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public long indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, long l, long l2) {
        if (l == 0L) {
            this.values[n] = l2;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, l, l2);
            } else {
                this.keys[n] = l;
                this.values[n] = l2;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public long indexReplace(int n, long l) {
        long[] lArray = this.values;
        long l2 = lArray[n];
        lArray[n] = l;
        return l2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongLongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public long put(long l, long l2) {
        long l3;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = true;
            long[] lArray = this.values;
            int n2 = n + 1;
            l = lArray[n2];
            lArray[n2] = l2;
            return l;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l3 = lArray[n3 &= n]) != 0L) {
            if (l3 == l) {
                lArray = this.values;
                l = lArray[n3];
                lArray[n3] = l2;
                return l;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, l, l2);
        } else {
            lArray[n3] = l;
            this.values[n3] = l2;
        }
        ++this.assigned;
        return 0L;
    }

    @Override
    public int putAll(LongLongAssociativeContainer object) {
        int n = this.size();
        Iterator<LongLongCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((LongLongCursor)object).key, ((LongLongCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends LongLongCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            LongLongCursor longLongCursor = (LongLongCursor)object.next();
            this.put(longLongCursor.key, longLongCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(long l, long l2) {
        int n = this.indexOf(l);
        if (!this.indexExists(n)) {
            this.indexInsert(n, l, l2);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(long l, long l2, long l3) {
        int n = this.indexOf(l);
        if (this.indexExists(n)) {
            l2 = this.values[n] + l3;
            this.indexReplace(n, l2);
        } else {
            this.indexInsert(n, l, l2);
        }
        return l2;
    }

    protected void rehash(long[] lArray, long[] lArray2) {
        int n;
        long[] lArray3 = this.keys;
        long[] lArray4 = this.values;
        int n2 = this.mask;
        int n3 = lArray.length - 1;
        lArray3[lArray3.length - 1] = lArray[n3];
        lArray4[lArray4.length - 1] = lArray2[n3];
        while ((n = n3 - 1) >= 0) {
            long l = lArray[n];
            n3 = n;
            if (l == 0L) continue;
            n3 = this.hashKey(l);
            while (lArray3[n3 &= n2] != 0L) {
                ++n3;
            }
            lArray3[n3] = l;
            lArray4[n3] = lArray2[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public long remove(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = false;
            long[] lArray = this.values;
            int n2 = n + 1;
            l = lArray[n2];
            lArray[n2] = 0L;
            return l;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                l = this.values[n3];
                this.shiftConflictingKeys(n3);
                return l;
            }
            ++n3;
        }
        return 0L;
    }

    @Override
    public int removeAll(LongContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof LongLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0L;
            }
            long[] lArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                long l = lArray[n2];
                if (l != 0L && object.contains(l)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((LongCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(LongLongPredicate longLongPredicate) {
        int n;
        long[] lArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && longLongPredicate.apply(0L, (lArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0L;
        }
        lArray = this.keys;
        long[] lArray2 = this.values;
        while (n4 <= n3) {
            long l = lArray[n4];
            if (l != 0L && longLongPredicate.apply(l, lArray2[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && longPredicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0L;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            long l = lArray[n2];
            if (l != 0L && longPredicate.apply(l)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        long[] lArray = this.keys;
        long[] lArray2 = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            long l;
            int n4;
            int n5 = 0;
            do {
                if ((l = lArray[n4 = n + (n3 = n5 + 1) & n2]) == 0L) {
                    lArray[n] = 0L;
                    lArray2[n] = 0L;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(l) & n2) < n3);
            lArray[n] = l;
            lArray2[n] = lArray2[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<LongLongCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            LongLongCursor longLongCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(longLongCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(longLongCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public LongCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<LongLongCursor> {
        private final LongLongCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongLongCursor();
        }

        @Override
        protected LongLongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongLongHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.key = l;
                        this.cursor.value = LongLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongLongCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongLongHashMap owner;

        public KeysContainer() {
            this.owner = LongLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            return this.owner.containsKey(l);
        }

        @Override
        public <T extends LongPredicate> T forEach(final T t) {
            this.owner.forEach(new LongLongPredicate(){

                @Override
                public boolean apply(long l, long l2) {
                    return t.apply(l);
                }
            });
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(final T t) {
            this.owner.forEach(new LongLongProcedure(){

                @Override
                public void apply(long l, long l2) {
                    t.apply(l);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(long l) {
            if (this.owner.containsKey(l)) {
                this.owner.remove(l);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(LongPredicate longPredicate) {
            return this.owner.removeAll(longPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongLongHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = l;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final LongLongHashMap owner;

        private ValuesContainer() {
            this.owner = LongLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            Iterator<LongLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != l) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongPredicate> T forEach(T t) {
            Iterator<LongLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(T t) {
            Iterator<LongLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final long l) {
            return this.owner.removeAll(new LongLongPredicate(){

                @Override
                public boolean apply(long l3, long l2) {
                    boolean bl = l2 == l;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final LongPredicate longPredicate) {
            return this.owner.removeAll(new LongLongPredicate(){

                @Override
                public boolean apply(long l, long l2) {
                    return longPredicate.apply(l2);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongLongHashMap.this.keys;
                    n = this.slot;
                    if (lArray[n] != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = LongLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

