/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.LongObjectAssociativeContainer;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.LongObjectPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.LongObjectProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class LongObjectHashMap<VType>
implements LongObjectMap<VType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public long[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public Object[] values;

    public LongObjectHashMap() {
        this(4);
    }

    public LongObjectHashMap(int n) {
        this(n, 0.75);
    }

    public LongObjectHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public LongObjectHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public LongObjectHashMap(LongObjectAssociativeContainer<? extends VType> longObjectAssociativeContainer) {
        this(longObjectAssociativeContainer.size());
        this.putAll(longObjectAssociativeContainer);
    }

    public static <VType> LongObjectHashMap<VType> from(long[] lArray, VType[] VTypeArray) {
        if (lArray.length == VTypeArray.length) {
            LongObjectHashMap<VType> longObjectHashMap = new LongObjectHashMap<VType>(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longObjectHashMap.put(lArray[i], VTypeArray[i]);
            }
            return longObjectHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new long[n3];
            this.values = new Object[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = lArray;
            this.values = objectArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, long l, VType VType) {
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        lArray[n] = l;
        objectArray[n] = VType;
        this.rehash(lArray, objectArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, null);
    }

    public LongObjectHashMap<VType> clone() {
        try {
            LongObjectHashMap longObjectHashMap = (LongObjectHashMap)super.clone();
            longObjectHashMap.keys = (long[])this.keys.clone();
            longObjectHashMap.values = (Object[])this.values.clone();
            longObjectHashMap.hasEmptyKey = longObjectHashMap.hasEmptyKey;
            longObjectHashMap.orderMixer = this.orderMixer.clone();
            return longObjectHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(long l) {
        long l2;
        if (l == 0L) {
            return this.hasEmptyKey;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            long[] lArray = this.keys;
            Object[] objectArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (lArray != null && !this.isEmpty()) {
                this.rehash(lArray, objectArray);
            }
        }
    }

    protected boolean equalElements(LongObjectHashMap<?> object) {
        if (((LongObjectHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((LongObjectHashMap)object).iterator();
        while (object.hasNext()) {
            LongObjectCursor longObjectCursor = (LongObjectCursor)object.next();
            long l = longObjectCursor.key;
            if (this.containsKey(l) && Objects.equals(this.get(l), longObjectCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongObjectHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongObjectPredicate<? super VType>> T forEach(T t) {
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        if (this.hasEmptyKey && !t.apply(0L, (Object)objectArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (lArray[i] == 0L || t.apply(lArray[i], (Object)objectArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends LongObjectProcedure<? super VType>> T forEach(T t) {
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(0L, (Object)objectArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (lArray[i] == 0L) continue;
            t.apply(lArray[i], (Object)objectArray[i]);
        }
        return t;
    }

    @Override
    public VType get(long l) {
        long l2;
        Object object = null;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return (VType)object;
        }
        object = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = object[n2 &= n]) != 0L) {
            if (l2 == l) {
                return (VType)this.values[n2];
            }
            ++n2;
        }
        return null;
    }

    @Override
    public VType getOrDefault(long l, VType object) {
        long l2;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return object;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return (VType)this.values[n2];
            }
            ++n2;
        }
        return object;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (LongObjectCursor<VType> longObjectCursor : this) {
            n += BitMixer.mix(longObjectCursor.key) + BitMixer.mix(longObjectCursor.value);
        }
        return n;
    }

    protected int hashKey(long l) {
        return BitMixer.mix(l, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public VType indexGet(int n) {
        return (VType)this.values[n];
    }

    @Override
    public void indexInsert(int n, long l, VType VType) {
        if (l == 0L) {
            this.values[n] = VType;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, l, VType);
            } else {
                this.keys[n] = l;
                this.values[n] = VType;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public VType indexReplace(int n, VType VType) {
        Object[] objectArray = this.values;
        Object object = objectArray[n];
        objectArray[n] = VType;
        return (VType)object;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public VType put(long l, VType VType) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = true;
            Object[] objectArray = this.values;
            int n2 = n + 1;
            Object object = objectArray[n2];
            objectArray[n2] = VType;
            return (VType)object;
        }
        Object object = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = object[n3 &= n]) != 0L) {
            if (l2 == l) {
                Object[] objectArray = this.values;
                object = objectArray[n3];
                objectArray[n3] = VType;
                return (VType)object;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, l, VType);
        } else {
            object[n3] = l;
            this.values[n3] = VType;
        }
        ++this.assigned;
        return null;
    }

    @Override
    public int putAll(LongObjectAssociativeContainer<? extends VType> object) {
        int n = this.size();
        Iterator<LongObjectCursor<VType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((LongObjectCursor)object).key, ((LongObjectCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends LongObjectCursor<? extends VType>> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            LongObjectCursor longObjectCursor = (LongObjectCursor)object.next();
            this.put(longObjectCursor.key, longObjectCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(long l, VType VType) {
        int n = this.indexOf(l);
        if (!this.indexExists(n)) {
            this.indexInsert(n, l, VType);
            return true;
        }
        return false;
    }

    protected void rehash(long[] lArray, VType[] VTypeArray) {
        int n;
        long[] lArray2 = this.keys;
        Object[] objectArray = this.values;
        int n2 = this.mask;
        int n3 = lArray.length - 1;
        lArray2[lArray2.length - 1] = lArray[n3];
        objectArray[objectArray.length - 1] = VTypeArray[n3];
        while ((n = n3 - 1) >= 0) {
            long l = lArray[n];
            n3 = n;
            if (l == 0L) continue;
            n3 = this.hashKey(l);
            while (lArray2[n3 &= n2] != 0L) {
                ++n3;
            }
            lArray2[n3] = l;
            objectArray[n3] = VTypeArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public VType remove(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = false;
            Object[] objectArray = this.values;
            int n2 = n + 1;
            Object object = objectArray[n2];
            objectArray[n2] = null;
            return (VType)object;
        }
        Object object = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = object[n3 &= n]) != 0L) {
            if (l2 == l) {
                object = this.values[n3];
                this.shiftConflictingKeys(n3);
                return (VType)object;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public int removeAll(LongContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof LongLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = null;
            }
            long[] lArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                long l = lArray[n2];
                if (l != 0L && object.contains(l)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((LongCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(LongObjectPredicate<? super VType> longObjectPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && longObjectPredicate.apply(0L, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = null;
        }
        objectArray = this.keys;
        Object[] objectArray2 = this.values;
        while (n4 <= n3) {
            Object object = objectArray[n4];
            if (object != 0L && longObjectPredicate.apply((long)object, objectArray2[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && longPredicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = null;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            long l = lArray[n2];
            if (l != 0L && longPredicate.apply(l)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            long l;
            int n4;
            int n5 = 0;
            do {
                if ((l = lArray[n4 = n + (n3 = n5 + 1) & n2]) == 0L) {
                    lArray[n] = 0L;
                    objectArray[n] = null;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(l) & n2) < n3);
            lArray[n] = l;
            objectArray[n] = objectArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<LongObjectCursor<VType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            LongObjectCursor<VType> longObjectCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(longObjectCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(longObjectCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ObjectCollection<VType> values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<LongObjectCursor<VType>> {
        private final LongObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongObjectCursor();
        }

        @Override
        protected LongObjectCursor<VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongObjectHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.key = l;
                        this.cursor.value = LongObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongObjectCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongObjectHashMap<VType> owner;

        public KeysContainer() {
            this.owner = LongObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            return this.owner.containsKey(l);
        }

        @Override
        public <T extends LongPredicate> T forEach(final T t) {
            this.owner.forEach(new LongObjectPredicate<VType>(){

                @Override
                public boolean apply(long l, VType VType) {
                    return t.apply(l);
                }
            });
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(final T t) {
            this.owner.forEach(new LongObjectProcedure<VType>(){

                @Override
                public void apply(long l, VType VType) {
                    t.apply(l);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(long l) {
            if (this.owner.containsKey(l)) {
                this.owner.remove(l);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(LongPredicate longPredicate) {
            return this.owner.removeAll(longPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongObjectHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = l;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final LongObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = LongObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(VType VType) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (!Objects.equals(iterator.next().value, VType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ObjectPredicate<? super VType> objectPredicate) {
            return this.owner.removeAll(new LongObjectPredicate<VType>(){

                @Override
                public boolean apply(long l, VType VType) {
                    return objectPredicate.apply(VType);
                }
            });
        }

        @Override
        public int removeAll(final VType VType) {
            return this.owner.removeAll(new LongObjectPredicate<VType>(){

                @Override
                public boolean apply(long l, VType VType2) {
                    return Objects.equals(VType2, VType);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongObjectHashMap.this.keys;
                    n = this.slot;
                    if (lArray[n] != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = LongObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

