/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.LongShortAssociativeContainer;
import com.carrotsearch.hppc.LongShortMap;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongShortCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.predicates.LongShortPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.procedures.LongShortProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongShortHashMap
implements LongShortMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public long[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public short[] values;

    public LongShortHashMap() {
        this(4);
    }

    public LongShortHashMap(int n) {
        this(n, 0.75);
    }

    public LongShortHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public LongShortHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public LongShortHashMap(LongShortAssociativeContainer longShortAssociativeContainer) {
        this(longShortAssociativeContainer.size());
        this.putAll(longShortAssociativeContainer);
    }

    public static LongShortHashMap from(long[] lArray, short[] sArray) {
        if (lArray.length == sArray.length) {
            LongShortHashMap longShortHashMap = new LongShortHashMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longShortHashMap.put(lArray[i], sArray[i]);
            }
            return longShortHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public short addTo(long l, short s) {
        return this.putOrAdd(l, s, s);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        long[] lArray = this.keys;
        short[] sArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new long[n3];
            this.values = new short[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = lArray;
            this.values = sArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, long l, short s) {
        long[] lArray = this.keys;
        short[] sArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        lArray[n] = l;
        sArray[n] = s;
        this.rehash(lArray, sArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    public LongShortHashMap clone() {
        try {
            LongShortHashMap longShortHashMap = (LongShortHashMap)super.clone();
            longShortHashMap.keys = (long[])this.keys.clone();
            longShortHashMap.values = (short[])this.values.clone();
            longShortHashMap.hasEmptyKey = longShortHashMap.hasEmptyKey;
            longShortHashMap.orderMixer = this.orderMixer.clone();
            return longShortHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(long l) {
        long l2;
        if (l == 0L) {
            return this.hasEmptyKey;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            long[] lArray = this.keys;
            short[] sArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (lArray != null && !this.isEmpty()) {
                this.rehash(lArray, sArray);
            }
        }
    }

    protected boolean equalElements(LongShortHashMap object) {
        if (((LongShortHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<LongShortCursor> iterator = ((LongShortHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            long l = ((LongShortCursor)object).key;
            if (this.containsKey(l) && this.get(l) == ((LongShortCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((LongShortHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends LongShortPredicate> T forEach(T t) {
        long[] lArray = this.keys;
        short[] sArray = this.values;
        if (this.hasEmptyKey && !t.apply(0L, sArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (lArray[i] == 0L || t.apply(lArray[i], sArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends LongShortProcedure> T forEach(T t) {
        long[] lArray = this.keys;
        short[] sArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(0L, sArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (lArray[i] == 0L) continue;
            t.apply(lArray[i], sArray[i]);
        }
        return t;
    }

    @Override
    public short get(long l) {
        long l2;
        int n = 0;
        if (l == 0L) {
            int n2 = n;
            if (this.hasEmptyKey) {
                n2 = n = this.values[this.mask + 1];
            }
            return (short)n2;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        n = this.hashKey(l);
        while ((l2 = lArray[n &= n3]) != 0L) {
            if (l2 == l) {
                return this.values[n];
            }
            ++n;
        }
        return 0;
    }

    @Override
    public short getOrDefault(long l, short s) {
        long l2;
        if (l == 0L) {
            if (this.hasEmptyKey) {
                short s2;
                s = s2 = this.values[this.mask + 1];
            }
            return s;
        }
        long[] lArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(l);
        while ((l2 = lArray[n2 &= n]) != 0L) {
            if (l2 == l) {
                return this.values[n2];
            }
            ++n2;
        }
        return s;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (LongShortCursor longShortCursor : this) {
            n += BitMixer.mix(longShortCursor.key) + BitMixer.mix(longShortCursor.value);
        }
        return n;
    }

    protected int hashKey(long l) {
        return BitMixer.mix(l, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public short indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, long l, short s) {
        if (l == 0L) {
            this.values[n] = s;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, l, s);
            } else {
                this.keys[n] = l;
                this.values[n] = s;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public short indexReplace(int n, short s) {
        short[] sArray = this.values;
        short s2 = sArray[n];
        sArray[n] = s;
        return s2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<LongShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public short put(long l, short s) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = true;
            short[] sArray = this.values;
            int n2 = n + 1;
            short s2 = sArray[n2];
            sArray[n2] = s;
            return s2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = objectArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                objectArray = this.values;
                long l3 = objectArray[n3];
                objectArray[n3] = s;
                return (short)l3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, l, s);
        } else {
            objectArray[n3] = l;
            this.values[n3] = s;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(LongShortAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            LongShortCursor longShortCursor = (LongShortCursor)object.next();
            this.put(longShortCursor.key, longShortCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends LongShortCursor> object) {
        int n = this.size();
        Iterator<? extends LongShortCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((LongShortCursor)object).key, ((LongShortCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(long l, short s) {
        int n = this.indexOf(l);
        if (!this.indexExists(n)) {
            this.indexInsert(n, l, s);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(long l, short s, short s2) {
        int n = this.indexOf(l);
        if (this.indexExists(n)) {
            s = (short)(this.values[n] + s2);
            this.indexReplace(n, s);
        } else {
            this.indexInsert(n, l, s);
        }
        return s;
    }

    protected void rehash(long[] lArray, short[] sArray) {
        int n;
        long[] lArray2 = this.keys;
        short[] sArray2 = this.values;
        int n2 = this.mask;
        int n3 = lArray.length - 1;
        lArray2[lArray2.length - 1] = lArray[n3];
        sArray2[sArray2.length - 1] = sArray[n3];
        while ((n = n3 - 1) >= 0) {
            long l = lArray[n];
            n3 = n;
            if (l == 0L) continue;
            n3 = this.hashKey(l);
            while (lArray2[n3 &= n2] != 0L) {
                ++n3;
            }
            lArray2[n3] = l;
            sArray2[n3] = sArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public short remove(long l) {
        long l2;
        int n = this.mask;
        if (l == 0L) {
            this.hasEmptyKey = false;
            short[] sArray = this.values;
            int n2 = n + 1;
            short s = sArray[n2];
            sArray[n2] = (short)0;
            return s;
        }
        long[] lArray = this.keys;
        int n3 = this.hashKey(l);
        while ((l2 = lArray[n3 &= n]) != 0L) {
            if (l2 == l) {
                short s = this.values[n3];
                this.shiftConflictingKeys(n3);
                return s;
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int removeAll(LongContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof LongLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (short)0;
            }
            long[] lArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                long l = lArray[n2];
                if (l != 0L && object.contains(l)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((LongCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(LongPredicate longPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && longPredicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (short)0;
        }
        long[] lArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            long l = lArray[n2];
            if (l != 0L && longPredicate.apply(l)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    @Override
    public int removeAll(LongShortPredicate longShortPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && longShortPredicate.apply(0L, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (short)0;
        }
        objectArray = this.keys;
        short[] sArray = this.values;
        while (n4 <= n3) {
            short s = objectArray[n4];
            if (s != 0L && longShortPredicate.apply(s, sArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        long[] lArray = this.keys;
        short[] sArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            long l;
            int n4;
            int n5 = 0;
            do {
                if ((l = lArray[n4 = n + (n3 = n5 + 1) & n2]) == 0L) {
                    lArray[n] = 0L;
                    sArray[n] = (short)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(l) & n2) < n3);
            lArray[n] = l;
            sArray[n] = sArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<LongShortCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            LongShortCursor longShortCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(longShortCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(longShortCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ShortCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<LongShortCursor> {
        private final LongShortCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongShortCursor();
        }

        @Override
        protected LongShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongShortHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.key = l;
                        this.cursor.value = LongShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongShortCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongShortHashMap owner;

        public KeysContainer() {
            this.owner = LongShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            return this.owner.containsKey(l);
        }

        @Override
        public <T extends LongPredicate> T forEach(final T t) {
            this.owner.forEach(new LongShortPredicate(){

                @Override
                public boolean apply(long l, short s) {
                    return t.apply(l);
                }
            });
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(final T t) {
            this.owner.forEach(new LongShortProcedure(){

                @Override
                public void apply(long l, short s) {
                    t.apply(l);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(long l) {
            if (this.owner.containsKey(l)) {
                this.owner.remove(l);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(LongPredicate longPredicate) {
            return this.owner.removeAll(longPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongShortHashMap.this.keys;
                    n = this.slot;
                    long l = lArray[n];
                    if (l != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = l;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final LongShortHashMap owner;

        private ValuesContainer() {
            this.owner = LongShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            Iterator<LongShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != s) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T t) {
            Iterator<LongShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T t) {
            Iterator<LongShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ShortPredicate shortPredicate) {
            return this.owner.removeAll(new LongShortPredicate(){

                @Override
                public boolean apply(long l, short s) {
                    return shortPredicate.apply(s);
                }
            });
        }

        @Override
        public int removeAll(final short s) {
            return this.owner.removeAll(new LongShortPredicate(){

                @Override
                public boolean apply(long l, short s2) {
                    boolean bl = s2 == s;
                    return bl;
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    long[] lArray = LongShortHashMap.this.keys;
                    n = this.slot;
                    if (lArray[n] != 0L) {
                        this.cursor.index = n;
                        this.cursor.value = LongShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && LongShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

