/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongShortHashMap;

public class LongShortScatterMap
extends LongShortHashMap {
    public LongShortScatterMap() {
        this(4);
    }

    public LongShortScatterMap(int n) {
        this(n, 0.75);
    }

    public LongShortScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static LongShortScatterMap from(long[] lArray, short[] sArray) {
        if (lArray.length == sArray.length) {
            LongShortScatterMap longShortScatterMap = new LongShortScatterMap(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                longShortScatterMap.put(lArray[i], sArray[i]);
            }
            return longShortScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(long l) {
        return BitMixer.mixPhi(l);
    }
}

