/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ObjectArrayList;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectArrayDeque<KType>
extends AbstractObjectCollection<KType>
implements ObjectDeque<KType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public Object[] buffer = ObjectArrayList.EMPTY_ARRAY;
    public int head;
    protected final ArraySizingStrategy resizer;
    public int tail;

    public ObjectArrayDeque() {
        this(4);
    }

    public ObjectArrayDeque(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayDeque(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public ObjectArrayDeque(ObjectContainer<? extends KType> objectContainer) {
        this(objectContainer.size());
        this.addLast(objectContainer);
    }

    private void descendingForEach(ObjectPredicate<? super KType> objectPredicate, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        Object[] objectArray = this.buffer;
        while (objectPredicate.apply(objectArray[n3 = ObjectArrayDeque.oneLeft(n2, objectArray.length)])) {
            n2 = n3;
            if (n3 != n) continue;
        }
    }

    private void descendingForEach(ObjectProcedure<? super KType> objectProcedure, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        Object[] objectArray = this.buffer;
        do {
            n3 = ObjectArrayDeque.oneLeft(n2, objectArray.length);
            objectProcedure.apply(objectArray[n3]);
            n2 = n3;
        } while (n3 != n);
    }

    private void forEach(ObjectProcedure<? super KType> objectProcedure, int n, int n2) {
        Object[] objectArray = this.buffer;
        while (n != n2) {
            objectProcedure.apply(objectArray[n]);
            n = ObjectArrayDeque.oneRight(n, objectArray.length);
        }
    }

    @SafeVarargs
    public static <KType> ObjectArrayDeque<KType> from(KType ... KTypeArray) {
        ObjectArrayDeque<KType> objectArrayDeque = new ObjectArrayDeque<KType>(KTypeArray.length);
        objectArrayDeque.addLast(KTypeArray);
        return objectArrayDeque;
    }

    protected static int oneLeft(int n, int n2) {
        if (n >= 1) {
            return n - 1;
        }
        return n2 - 1;
    }

    protected static int oneRight(int n, int n2) {
        int n3;
        n = n3 = n + 1;
        if (n3 == n2) {
            n = 0;
        }
        return n;
    }

    public int addFirst(ObjectContainer<? extends KType> object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addFirst((KType)((ObjectCursor)object.next()).value);
        }
        return n;
    }

    public int addFirst(Iterable<? extends ObjectCursor<? extends KType>> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addFirst((KType)((ObjectCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addFirst(KType KType) {
        int n;
        int n2 = n = ObjectArrayDeque.oneLeft(this.head, this.buffer.length);
        if (n == this.tail) {
            this.ensureBufferSpace(1);
            n2 = ObjectArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        Object[] objectArray = this.buffer;
        this.head = n2;
        objectArray[n2] = KType;
    }

    @Override
    @SafeVarargs
    public final void addFirst(KType ... KTypeArray) {
        this.ensureBufferSpace(KTypeArray.length);
        int n = KTypeArray.length;
        for (int i = 0; i < n; ++i) {
            this.addFirst(KTypeArray[i]);
        }
    }

    public int addLast(ObjectContainer<? extends KType> object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addLast((KType)((ObjectCursor)object.next()).value);
        }
        return n;
    }

    public int addLast(Iterable<? extends ObjectCursor<? extends KType>> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addLast((KType)((ObjectCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addLast(KType KType) {
        int n;
        int n2 = n = ObjectArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == n) {
            this.ensureBufferSpace(1);
            n2 = ObjectArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = KType;
        this.tail = n2;
    }

    @Override
    @SafeVarargs
    public final void addLast(KType ... KTypeArray) {
        this.ensureBufferSpace(1);
        int n = KTypeArray.length;
        for (int i = 0; i < n; ++i) {
            this.addLast(KTypeArray[i]);
        }
    }

    public int bufferIndexOf(KType KType) {
        int n = this.tail;
        int n2 = this.buffer.length;
        int n3 = this.head;
        while (n3 != n) {
            if (this.equals(this.buffer[n3], KType)) {
                return n3;
            }
            n3 = ObjectArrayDeque.oneRight(n3, n2);
        }
        return -1;
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            Arrays.fill(this.buffer, n, n2, null);
        } else {
            Arrays.fill(this.buffer, 0, n2, null);
            Object[] objectArray = this.buffer;
            Arrays.fill(objectArray, this.head, objectArray.length, null);
        }
        this.tail = 0;
        this.head = 0;
    }

    public ObjectArrayDeque<KType> clone() {
        try {
            ObjectArrayDeque objectArrayDeque = (ObjectArrayDeque)super.clone();
            objectArrayDeque.buffer = (Object[])this.buffer.clone();
            return objectArrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(KType KType) {
        int n = this.head;
        int n2 = this.tail;
        Object[] objectArray = this.buffer;
        while (n != n2) {
            if (this.equals(objectArray[n], KType)) {
                return true;
            }
            n = ObjectArrayDeque.oneRight(n, objectArray.length);
        }
        return false;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public Iterator<ObjectCursor<KType>> descendingIterator() {
        return new DescendingValueIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureBufferSpace(int n) {
        int n2 = this.buffer.length;
        int n3 = this.size();
        if (n3 + n < n2) return;
        n = this.resizer.grow(n2, n3 + 1, n);
        try {
            Object[] objectArray = new Object[n];
            if (n2 > 0) {
                this.toArray(objectArray);
                this.tail = n3;
                this.head = 0;
            }
            this.buffer = objectArray;
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensureBufferSpace(n - this.size());
    }

    protected boolean equalElements(ObjectArrayDeque<?> object) {
        int n = this.size();
        int n2 = ((ObjectArrayDeque)object).size();
        boolean bl = false;
        if (n2 != n) {
            return false;
        }
        Iterator<ObjectCursor<KType>> iterator = this.iterator();
        object = ((ObjectArrayDeque)object).iterator();
        while (iterator.hasNext() && object.hasNext()) {
            if (this.equals(((ObjectCursor)object.next()).value, iterator.next().value)) continue;
            return false;
        }
        boolean bl2 = bl;
        if (!iterator.hasNext()) {
            bl2 = bl;
            if (!object.hasNext()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ObjectArrayDeque)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T t) {
        int n = this.head;
        int n2 = this.tail;
        Object[] objectArray = this.buffer;
        while (n != n2 && t.apply((Object)objectArray[n])) {
            n = ObjectArrayDeque.oneRight(n, objectArray.length);
        }
        return t;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T t) {
        this.forEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public KType getFirst() {
        return (KType)this.buffer[this.head];
    }

    @Override
    public KType getLast() {
        Object[] objectArray = this.buffer;
        return (KType)objectArray[ObjectArrayDeque.oneLeft(this.tail, objectArray.length)];
    }

    public int hashCode() {
        int n = this.head;
        int n2 = this.tail;
        Object[] objectArray = this.buffer;
        int n3 = 1;
        while (n != n2) {
            n3 = n3 * 31 + BitMixer.mix(this.buffer[n]);
            n = ObjectArrayDeque.oneRight(n, objectArray.length);
        }
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new ValueIterator();
    }

    public int lastBufferIndexOf(KType KType) {
        int n;
        int n2 = this.buffer.length;
        int n3 = ObjectArrayDeque.oneLeft(this.head, n2);
        int n4 = this.tail;
        while ((n = ObjectArrayDeque.oneLeft(n4, n2)) != n3) {
            n4 = n;
            if (!this.equals(this.buffer[n], KType)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = ObjectArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    /*
     * Loose catch block
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object[] objectArray;
        block10: {
            int n6;
            objectArray = this.buffer;
            n5 = this.tail;
            n4 = objectArray.length;
            int n7 = n6 = this.head;
            n3 = 0;
            while (true) {
                n2 = n6;
                n = n7;
                if (n6 == n5) break block10;
                n2 = n7;
                if (objectPredicate.apply(objectArray[n6])) {
                    objectArray[n6] = null;
                    ++n3;
                    break block11;
                }
                if (n7 == n6) break block12;
                break;
            }
            catch (Throwable throwable) {
                while (n6 != n5) {
                    if (n2 != n6) {
                        objectArray[n2] = objectArray[n6];
                        objectArray[n6] = null;
                    }
                    n2 = ObjectArrayDeque.oneRight(n2, n4);
                    n6 = ObjectArrayDeque.oneRight(n6, n4);
                }
                this.tail = n2;
                throw throwable;
            }
            {
                block11: {
                    block12: {
                        objectArray[n7] = objectArray[n6];
                        objectArray[n6] = null;
                    }
                    n2 = n7;
                    n7 = ObjectArrayDeque.oneRight(n7, n4);
                }
                n2 = n7;
                n6 = n = ObjectArrayDeque.oneRight(n6, n4);
                continue;
            }
        }
        while (n2 != n5) {
            if (n != n2) {
                objectArray[n] = objectArray[n2];
                objectArray[n2] = null;
            }
            n = ObjectArrayDeque.oneRight(n, n4);
            n2 = ObjectArrayDeque.oneRight(n2, n4);
        }
        this.tail = n;
        return n3;
    }

    @Override
    public int removeAll(KType KType) {
        int n;
        int n2 = this.tail;
        int n3 = this.buffer.length;
        int n4 = n = this.head;
        int n5 = 0;
        while (n != n2) {
            if (this.equals(this.buffer[n], KType)) {
                this.buffer[n] = null;
                ++n5;
            } else {
                if (n4 != n) {
                    Object[] objectArray = this.buffer;
                    objectArray[n4] = objectArray[n];
                    objectArray[n] = null;
                }
                n4 = ObjectArrayDeque.oneRight(n4, n3);
            }
            n = ObjectArrayDeque.oneRight(n, n3);
        }
        this.tail = n4;
        return n5;
    }

    public void removeAtBufferIndex(int n) {
        int n2;
        Object[] objectArray = this.buffer;
        int n3 = objectArray.length;
        int n4 = n3 - 1;
        int n5 = this.head;
        int n6 = this.tail;
        int n7 = Math.abs(n - n5) % n3;
        if (n7 < (n2 = Math.abs(n6 - n) % n3)) {
            if (n >= n5) {
                System.arraycopy(objectArray, n5, objectArray, n5 + 1, n7);
            } else {
                System.arraycopy(objectArray, 0, objectArray, 1, n);
                objectArray[0] = objectArray[n4];
                System.arraycopy(objectArray, n5, objectArray, n5 + 1, n4 - n5);
            }
            objectArray[n5] = null;
            this.head = ObjectArrayDeque.oneRight(n5, n3);
        } else {
            if (n < n6) {
                System.arraycopy(objectArray, n + 1, objectArray, n, n2);
            } else {
                System.arraycopy(objectArray, n + 1, objectArray, n, n4 - n);
                objectArray[n4] = objectArray[0];
                System.arraycopy(objectArray, 1, objectArray, 0, n6);
            }
            objectArray[n6] = null;
            this.tail = ObjectArrayDeque.oneLeft(n6, n3);
        }
    }

    @Override
    public int removeFirst(KType KType) {
        int n = this.bufferIndexOf(KType);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public KType removeFirst() {
        Object[] objectArray = this.buffer;
        int n = this.head;
        Object object = objectArray[n];
        objectArray[n] = null;
        this.head = ObjectArrayDeque.oneRight(n, objectArray.length);
        return (KType)object;
    }

    @Override
    public int removeLast(KType KType) {
        int n = this.lastBufferIndexOf(KType);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public KType removeLast() {
        int n;
        this.tail = n = ObjectArrayDeque.oneLeft(this.tail, this.buffer.length);
        Object[] objectArray = this.buffer;
        Object object = objectArray[n];
        objectArray[n] = null;
        return (KType)object;
    }

    @Override
    public int size() {
        int n = this.head;
        int n2 = this.tail;
        if (n <= n2) {
            return n2 - n;
        }
        return n2 - n + this.buffer.length;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public KType[] toArray(KType[] KTypeArray) {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            System.arraycopy(this.buffer, n, KTypeArray, 0, this.size());
        } else if (n > n2) {
            Object[] objectArray = this.buffer;
            n2 = objectArray.length - n;
            System.arraycopy(objectArray, n, KTypeArray, 0, n2);
            System.arraycopy(this.buffer, 0, KTypeArray, n2, this.tail);
        }
        return KTypeArray;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private int remaining;

        public DescendingValueIterator() {
            ObjectCursor objectCursor = new ObjectCursor();
            this.cursor = objectCursor;
            objectCursor.index = ObjectArrayDeque.this.tail;
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (ObjectCursor)this.done();
            }
            this.remaining = n - 1;
            ObjectCursor objectCursor = this.cursor;
            Object[] objectArray = ObjectArrayDeque.this.buffer;
            ObjectCursor objectCursor2 = this.cursor;
            objectCursor2.index = n = ObjectArrayDeque.oneLeft(objectCursor2.index, ObjectArrayDeque.this.buffer.length);
            objectCursor.value = objectArray[n];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private int remaining;

        public ValueIterator() {
            ObjectCursor objectCursor = new ObjectCursor();
            this.cursor = objectCursor;
            objectCursor.index = ObjectArrayDeque.oneLeft(ObjectArrayDeque.this.head, ObjectArrayDeque.this.buffer.length);
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (ObjectCursor)this.done();
            }
            this.remaining = n - 1;
            ObjectCursor objectCursor = this.cursor;
            Object[] objectArray = ObjectArrayDeque.this.buffer;
            ObjectCursor objectCursor2 = this.cursor;
            objectCursor2.index = n = ObjectArrayDeque.oneRight(objectCursor2.index, ObjectArrayDeque.this.buffer.length);
            objectCursor.value = objectArray[n];
            return this.cursor;
        }
    }
}

