/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectIndexedContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectArrayList<KType>
extends AbstractObjectCollection<KType>
implements ObjectIndexedContainer<KType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public Object[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public ObjectArrayList() {
        this(4);
    }

    public ObjectArrayList(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayList(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public ObjectArrayList(ObjectContainer<? extends KType> objectContainer) {
        this(objectContainer.size());
        this.addAll(objectContainer);
    }

    @SafeVarargs
    public static <KType> ObjectArrayList<KType> from(KType ... KTypeArray) {
        ObjectArrayList<KType> objectArrayList = new ObjectArrayList<KType>(KTypeArray.length);
        objectArrayList.add(KTypeArray);
        return objectArrayList;
    }

    @Override
    public void add(KType KType) {
        this.ensureBufferSpace(1);
        Object[] objectArray = this.buffer;
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        objectArray[n] = KType;
    }

    public void add(KType KType, KType KType2) {
        int n;
        this.ensureBufferSpace(2);
        Object[] objectArray = this.buffer;
        int n2 = this.elementsCount;
        this.elementsCount = n = n2 + 1;
        objectArray[n2] = KType;
        this.elementsCount = n + 1;
        objectArray[n] = KType2;
    }

    @Override
    @SafeVarargs
    public final void add(KType ... KTypeArray) {
        this.add(KTypeArray, 0, KTypeArray.length);
    }

    public void add(KType[] KTypeArray, int n, int n2) {
        this.ensureBufferSpace(n2);
        System.arraycopy(KTypeArray, n, this.buffer, this.elementsCount, n2);
        this.elementsCount += n2;
    }

    public int addAll(ObjectContainer<? extends KType> object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.add((KType)((ObjectCursor)object.next()).value);
        }
        return n;
    }

    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.add((KType)((ObjectCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, null);
        this.elementsCount = 0;
    }

    public ObjectArrayList<KType> clone() {
        try {
            ObjectArrayList objectArrayList = (ObjectArrayList)super.clone();
            objectArrayList.buffer = (Object[])this.buffer.clone();
            return objectArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(KType KType) {
        boolean bl = this.indexOf(KType) >= 0;
        return bl;
    }

    protected void ensureBufferSpace(int n) {
        int n2 = this.elementsCount;
        Object[] objectArray = this.buffer;
        int n3 = objectArray == null ? 0 : objectArray.length;
        if (n2 + n > n3) {
            n = this.resizer.grow(n3, n2, n);
            this.buffer = Arrays.copyOf(this.buffer, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        Object[] objectArray = this.buffer;
        int n2 = objectArray == null ? 0 : objectArray.length;
        if (n > n2) {
            this.ensureBufferSpace(n - this.size());
        }
    }

    protected boolean equalElements(ObjectArrayList<?> objectArrayList) {
        int n = this.size();
        if (objectArrayList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.equals(objectArrayList.get(i), this.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ObjectArrayList)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends ObjectPredicate<? super KType>> T forEach(T t, int n, int n2) {
        Object[] objectArray = this.buffer;
        while (n < n2 && t.apply((Object)objectArray[n])) {
            ++n;
        }
        return t;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends ObjectProcedure<? super KType>> T forEach(T t, int n, int n2) {
        Object[] objectArray = this.buffer;
        while (n < n2) {
            t.apply((Object)objectArray[n]);
            ++n;
        }
        return t;
    }

    @Override
    public KType get(int n) {
        return (KType)this.buffer[n];
    }

    public int hashCode() {
        int n = this.elementsCount;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + BitMixer.mix(this.buffer[i]);
        }
        return n2;
    }

    @Override
    public int indexOf(KType KType) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (!this.equals(this.buffer[i], KType)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insert(int n, KType KType) {
        this.ensureBufferSpace(1);
        Object[] objectArray = this.buffer;
        System.arraycopy(objectArray, n, objectArray, n + 1, this.elementsCount - n);
        this.buffer[n] = KType;
        ++this.elementsCount;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.elementsCount == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new ValueIterator<Object>(this.buffer, this.size());
    }

    @Override
    public int lastIndexOf(KType KType) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (!this.equals(this.buffer[i], KType)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public KType remove(int n) {
        Object[] objectArray = this.buffer;
        Object object = objectArray[n];
        int n2 = n + 1;
        int n3 = this.elementsCount;
        if (n2 < n3) {
            System.arraycopy(objectArray, n2, objectArray, n, n3 - n - 1);
        }
        this.elementsCount = n = this.elementsCount - 1;
        this.buffer[n] = null;
        return (KType)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n;
        int n2;
        Object[] objectArray = this.buffer;
        int n3 = this.elementsCount;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            n2 = ++n4;
            n = ++n5;
            if (n4 >= n3) break;
            try {
                if (objectPredicate.apply(objectArray[n4])) {
                    objectArray[n4] = null;
                    continue;
                }
                if (n5 == n4) continue;
            }
            catch (Throwable throwable) {
                while (true) {
                    if (n4 >= n3) {
                        this.elementsCount = n5;
                        throw throwable;
                    }
                    if (n5 != n4) {
                        objectArray[n5] = objectArray[n4];
                        objectArray[n4] = null;
                    }
                    ++n5;
                    ++n4;
                }
            }
            objectArray[n5] = objectArray[n4];
            objectArray[n4] = null;
        }
        while (true) {
            if (n2 >= n3) {
                this.elementsCount = n;
                return n3 - n;
            }
            if (n != n2) {
                objectArray[n] = objectArray[n2];
                objectArray[n2] = null;
            }
            ++n;
            ++n2;
        }
    }

    @Override
    public int removeAll(KType KType) {
        int n;
        int n2 = 0;
        for (int i = 0; i < (n = this.elementsCount); ++i) {
            if (this.equals(this.buffer[i], KType)) {
                this.buffer[i] = null;
                continue;
            }
            if (n2 != i) {
                Object[] objectArray = this.buffer;
                objectArray[n2] = objectArray[i];
                objectArray[i] = null;
            }
            ++n2;
        }
        this.elementsCount = n2;
        return n - n2;
    }

    @Override
    public int removeFirst(KType KType) {
        int n = this.indexOf(KType);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public int removeLast(KType KType) {
        int n = this.lastIndexOf(KType);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public void removeRange(int n, int n2) {
        Object[] objectArray = this.buffer;
        System.arraycopy(objectArray, n2, objectArray, n, this.elementsCount - n2);
        n = n2 - n;
        this.elementsCount = n2 = this.elementsCount - n;
        Arrays.fill(this.buffer, n2, n + n2, null);
    }

    public void resize(int n) {
        Object[] objectArray = this.buffer;
        if (n <= objectArray.length) {
            int n2 = this.elementsCount;
            if (n < n2) {
                Arrays.fill(objectArray, n, n2, null);
            } else {
                Arrays.fill(objectArray, n2, n, null);
            }
        } else {
            this.ensureCapacity(n);
        }
        this.elementsCount = n;
    }

    @Override
    public KType set(int n, KType KType) {
        Object[] objectArray = this.buffer;
        Object object = objectArray[n];
        objectArray[n] = KType;
        return (KType)object;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    static final class ValueIterator<KType>
    extends AbstractIterator<ObjectCursor<KType>> {
        private final KType[] buffer;
        private final ObjectCursor<KType> cursor;
        private final int size;

        public ValueIterator(KType[] KTypeArray, int n) {
            ObjectCursor objectCursor = new ObjectCursor();
            this.cursor = objectCursor;
            objectCursor.index = -1;
            this.size = n;
            this.buffer = KTypeArray;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n;
            if (this.cursor.index + 1 == this.size) {
                return (ObjectCursor)this.done();
            }
            ObjectCursor<KType> objectCursor = this.cursor;
            KType[] KTypeArray = this.buffer;
            objectCursor.index = n = objectCursor.index + 1;
            objectCursor.value = KTypeArray[n];
            return this.cursor;
        }
    }
}

