/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectCharAssociativeContainer;
import com.carrotsearch.hppc.ObjectCharMap;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.ObjectCharCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.ObjectCharPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.ObjectCharProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectCharHashMap<KType>
implements ObjectCharMap<KType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public Object[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public char[] values;

    public ObjectCharHashMap() {
        this(4);
    }

    public ObjectCharHashMap(int n) {
        this(n, 0.75);
    }

    public ObjectCharHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ObjectCharHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ObjectCharHashMap(ObjectCharAssociativeContainer<? extends KType> objectCharAssociativeContainer) {
        this(objectCharAssociativeContainer.size());
        this.putAll(objectCharAssociativeContainer);
    }

    public static <KType> ObjectCharHashMap<KType> from(KType[] KTypeArray, char[] cArray) {
        if (KTypeArray.length == cArray.length) {
            ObjectCharHashMap<KType> objectCharHashMap = new ObjectCharHashMap<KType>(KTypeArray.length);
            for (int i = 0; i < KTypeArray.length; ++i) {
                objectCharHashMap.put(KTypeArray[i], cArray[i]);
            }
            return objectCharHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public char addTo(KType KType, char c) {
        return this.putOrAdd(KType, c, c);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        Object[] objectArray = this.keys;
        char[] cArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new Object[n3];
            this.values = new char[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = objectArray;
            this.values = cArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, KType KType, char c) {
        Object[] objectArray = this.keys;
        char[] cArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        objectArray[n] = KType;
        cArray[n] = c;
        this.rehash(objectArray, cArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    public ObjectCharHashMap<KType> clone() {
        try {
            ObjectCharHashMap objectCharHashMap = (ObjectCharHashMap)super.clone();
            objectCharHashMap.keys = (Object[])this.keys.clone();
            objectCharHashMap.values = (char[])this.values.clone();
            objectCharHashMap.hasEmptyKey = objectCharHashMap.hasEmptyKey;
            objectCharHashMap.orderMixer = this.orderMixer.clone();
            return objectCharHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(KType KType) {
        Object object;
        if (KType == null) {
            return this.hasEmptyKey;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            Object[] objectArray = this.keys;
            char[] cArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (objectArray != null && !this.isEmpty()) {
                this.rehash(objectArray, cArray);
            }
        }
    }

    protected boolean equalElements(ObjectCharHashMap<?> objectCharHashMap) {
        if (objectCharHashMap.size() != this.size()) {
            return false;
        }
        for (ObjectCharCursor<?> objectCharCursor : objectCharHashMap) {
            objectCharHashMap = objectCharCursor.key;
            if (this.containsKey(objectCharHashMap) && this.get(objectCharHashMap) == objectCharCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ObjectCharHashMap)this.getClass().cast(object));
        return bl;
    }

    protected boolean equals(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    @Override
    public <T extends ObjectCharPredicate<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        char[] cArray = this.values;
        if (this.hasEmptyKey && !t.apply(null, cArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (objectArray[i] == null || t.apply((Object)objectArray[i], cArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ObjectCharProcedure<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        char[] cArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(null, cArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (objectArray[i] == null) continue;
            t.apply((Object)objectArray[i], cArray[i]);
        }
        return t;
    }

    @Override
    public char get(KType KType) {
        Object object;
        int n = 0;
        if (KType == null) {
            int n2 = n;
            if (this.hasEmptyKey) {
                n2 = n = this.values[this.mask + 1];
            }
            return (char)n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        n = this.hashKey(KType);
        while ((object = objectArray[n &= n3]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n];
            }
            ++n;
        }
        return '\u0000';
    }

    @Override
    public char getOrDefault(KType KType, char c) {
        Object object;
        if (KType == null) {
            if (this.hasEmptyKey) {
                char c2;
                c = c2 = this.values[this.mask + 1];
            }
            return c;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n2];
            }
            ++n2;
        }
        return c;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectCharCursor<KType> objectCharCursor : this) {
            n += BitMixer.mix(objectCharCursor.key) + BitMixer.mix(objectCharCursor.value);
        }
        return n;
    }

    protected int hashKey(KType KType) {
        return BitMixer.mix(KType, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public char indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, KType KType, char c) {
        if (KType == null) {
            this.values[n] = c;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, KType, c);
            } else {
                this.keys[n] = KType;
                this.values[n] = c;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(KType KType) {
        Object object;
        int n = this.mask;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(KType);
        while ((object = objectArray[n3 &= n]) != null) {
            if (this.equals(object, KType)) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public char indexReplace(int n, char c) {
        char[] cArray = this.values;
        char c2 = cArray[n];
        cArray[n] = c;
        return c2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectCharCursor<KType>> iterator() {
        return new EntryIterator();
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public char put(KType object, char c) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = true;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = c;
            return (char)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                object = this.values;
                KType KType = object[n3];
                object[n3] = c;
                return (char)KType;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, object, c);
        } else {
            objectArray[n3] = object;
            this.values[n3] = c;
        }
        ++this.assigned;
        return '\u0000';
    }

    @Override
    public int putAll(ObjectCharAssociativeContainer<? extends KType> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ObjectCharCursor objectCharCursor = (ObjectCharCursor)object.next();
            this.put(objectCharCursor.key, objectCharCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ObjectCharCursor<? extends KType>> object) {
        int n = this.size();
        Iterator<ObjectCharCursor<KType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ObjectCharCursor)object).key, ((ObjectCharCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(KType KType, char c) {
        int n = this.indexOf(KType);
        if (!this.indexExists(n)) {
            this.indexInsert(n, KType, c);
            return true;
        }
        return false;
    }

    @Override
    public char putOrAdd(KType KType, char c, char c2) {
        int n = this.indexOf(KType);
        if (this.indexExists(n)) {
            c = (char)(this.values[n] + c2);
            this.indexReplace(n, c);
        } else {
            this.indexInsert(n, KType, c);
        }
        return c;
    }

    protected void rehash(KType[] KTypeArray, char[] cArray) {
        int n;
        Object[] objectArray = this.keys;
        char[] cArray2 = this.values;
        int n2 = this.mask;
        int n3 = KTypeArray.length - 1;
        objectArray[objectArray.length - 1] = KTypeArray[n3];
        cArray2[cArray2.length - 1] = cArray[n3];
        while ((n = n3 - 1) >= 0) {
            KType KType = KTypeArray[n];
            n3 = n;
            if (KType == null) continue;
            n3 = this.hashKey(KType);
            while (objectArray[n3 &= n2] != null) {
                ++n3;
            }
            objectArray[n3] = KType;
            cArray2[n3] = cArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public char remove(KType object) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = false;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = (char)0;
            return (char)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                char c = this.values[n3];
                this.shiftConflictingKeys(n3);
                return c;
            }
            ++n3;
        }
        return '\u0000';
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ObjectLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (char)0;
            }
            Object[] objectArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                Object object2 = objectArray[n2];
                if (object2 != null && object.contains(object2)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ObjectCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ObjectCharPredicate<? super KType> objectCharPredicate) {
        int n;
        char[] cArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && objectCharPredicate.apply(null, (cArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (char)0;
        }
        Object[] objectArray = this.keys;
        cArray = this.values;
        while (n4 <= n3) {
            Object object = objectArray[n4];
            if (object != null && objectCharPredicate.apply(object, cArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && objectPredicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (char)0;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            Object object = objectArray[n2];
            if (object != null && objectPredicate.apply(object)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        Object[] objectArray = this.keys;
        char[] cArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            Object object;
            int n4;
            int n5 = 0;
            do {
                if ((object = objectArray[n4 = n + (n3 = n5 + 1) & n2]) == null) {
                    objectArray[n] = null;
                    cArray[n] = (char)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(object) & n2) < n3);
            objectArray[n] = object;
            cArray[n] = cArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ObjectCharCursor<KType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ObjectCharCursor<KType> objectCharCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(objectCharCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(objectCharCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public CharCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectCharCursor<KType>> {
        private final ObjectCharCursor<KType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCharCursor();
        }

        @Override
        protected ObjectCharCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectCharHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.key = object;
                        this.cursor.value = ObjectCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCharCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectCharHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectCharHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(KType KType) {
            return this.owner.containsKey(KType);
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectCharPredicate<KType>(){

                @Override
                public boolean apply(KType KType, char c) {
                    return t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectCharProcedure<KType>(){

                @Override
                public void apply(KType KType, char c) {
                    t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
            return this.owner.removeAll(objectPredicate);
        }

        @Override
        public int removeAll(KType KType) {
            if (this.owner.containsKey(KType)) {
                this.owner.remove(KType);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectCharHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.value = object;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final ObjectCharHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = ObjectCharHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != c) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharPredicate> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final char c) {
            return this.owner.removeAll(new ObjectCharPredicate<KType>(){

                @Override
                public boolean apply(KType KType, char c2) {
                    boolean bl = c2 == c;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final CharPredicate charPredicate) {
            return this.owner.removeAll(new ObjectCharPredicate<KType>(){

                @Override
                public boolean apply(KType KType, char c) {
                    return charPredicate.apply(c);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object[] objectArray = ObjectCharHashMap.this.keys;
                    n = this.slot;
                    if (objectArray[n] != null) {
                        this.cursor.index = n;
                        this.cursor.value = ObjectCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

