/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.DoubleCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectDoubleAssociativeContainer;
import com.carrotsearch.hppc.ObjectDoubleMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectDoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.ObjectDoublePredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.ObjectDoubleProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectDoubleHashMap<KType>
implements ObjectDoubleMap<KType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public Object[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public double[] values;

    public ObjectDoubleHashMap() {
        this(4);
    }

    public ObjectDoubleHashMap(int n) {
        this(n, 0.75);
    }

    public ObjectDoubleHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ObjectDoubleHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ObjectDoubleHashMap(ObjectDoubleAssociativeContainer<? extends KType> objectDoubleAssociativeContainer) {
        this(objectDoubleAssociativeContainer.size());
        this.putAll(objectDoubleAssociativeContainer);
    }

    public static <KType> ObjectDoubleHashMap<KType> from(KType[] KTypeArray, double[] dArray) {
        if (KTypeArray.length == dArray.length) {
            ObjectDoubleHashMap<KType> objectDoubleHashMap = new ObjectDoubleHashMap<KType>(KTypeArray.length);
            for (int i = 0; i < KTypeArray.length; ++i) {
                objectDoubleHashMap.put(KTypeArray[i], dArray[i]);
            }
            return objectDoubleHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public double addTo(KType KType, double d) {
        return this.putOrAdd(KType, d, d);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        Object[] objectArray = this.keys;
        double[] dArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new Object[n3];
            this.values = new double[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = objectArray;
            this.values = dArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, KType KType, double d) {
        Object[] objectArray = this.keys;
        double[] dArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        objectArray[n] = KType;
        dArray[n] = d;
        this.rehash(objectArray, dArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    public ObjectDoubleHashMap<KType> clone() {
        try {
            ObjectDoubleHashMap objectDoubleHashMap = (ObjectDoubleHashMap)super.clone();
            objectDoubleHashMap.keys = (Object[])this.keys.clone();
            objectDoubleHashMap.values = (double[])this.values.clone();
            objectDoubleHashMap.hasEmptyKey = objectDoubleHashMap.hasEmptyKey;
            objectDoubleHashMap.orderMixer = this.orderMixer.clone();
            return objectDoubleHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(KType KType) {
        Object object;
        if (KType == null) {
            return this.hasEmptyKey;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            Object[] objectArray = this.keys;
            double[] dArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (objectArray != null && !this.isEmpty()) {
                this.rehash(objectArray, dArray);
            }
        }
    }

    protected boolean equalElements(ObjectDoubleHashMap<?> object) {
        if (((ObjectDoubleHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((ObjectDoubleHashMap)object).iterator();
        while (object.hasNext()) {
            ObjectDoubleCursor objectDoubleCursor = (ObjectDoubleCursor)object.next();
            Object KType = objectDoubleCursor.key;
            if (this.containsKey(KType) && Double.doubleToLongBits(this.get(KType)) == Double.doubleToLongBits(objectDoubleCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ObjectDoubleHashMap)this.getClass().cast(object));
        return bl;
    }

    protected boolean equals(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    @Override
    public <T extends ObjectDoublePredicate<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        double[] dArray = this.values;
        if (this.hasEmptyKey && !t.apply(null, dArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (objectArray[i] == null || t.apply((Object)objectArray[i], dArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ObjectDoubleProcedure<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        double[] dArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(null, dArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (objectArray[i] == null) continue;
            t.apply((Object)objectArray[i], dArray[i]);
        }
        return t;
    }

    @Override
    public double get(KType KType) {
        Object object;
        double d = 0.0;
        if (KType == null) {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0.0;
    }

    @Override
    public double getOrDefault(KType KType, double d) {
        Object object;
        if (KType == null) {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n2];
            }
            ++n2;
        }
        return d;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectDoubleCursor<KType> objectDoubleCursor : this) {
            n += BitMixer.mix(objectDoubleCursor.key) + BitMixer.mix(objectDoubleCursor.value);
        }
        return n;
    }

    protected int hashKey(KType KType) {
        return BitMixer.mix(KType, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public double indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, KType KType, double d) {
        if (KType == null) {
            this.values[n] = d;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, KType, d);
            } else {
                this.keys[n] = KType;
                this.values[n] = d;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(KType KType) {
        Object object;
        int n = this.mask;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(KType);
        while ((object = objectArray[n3 &= n]) != null) {
            if (this.equals(object, KType)) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public double indexReplace(int n, double d) {
        double[] dArray = this.values;
        double d2 = dArray[n];
        dArray[n] = d;
        return d2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectDoubleCursor<KType>> iterator() {
        return new EntryIterator();
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public double put(KType object, double d) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = true;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = d;
            return (double)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                object = this.values;
                KType KType = object[n3];
                object[n3] = d;
                return (double)KType;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, object, d);
        } else {
            objectArray[n3] = object;
            this.values[n3] = d;
        }
        ++this.assigned;
        return 0.0;
    }

    @Override
    public int putAll(ObjectDoubleAssociativeContainer<? extends KType> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ObjectDoubleCursor objectDoubleCursor = (ObjectDoubleCursor)object.next();
            this.put(objectDoubleCursor.key, objectDoubleCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ObjectDoubleCursor<? extends KType>> object) {
        int n = this.size();
        Iterator<ObjectDoubleCursor<KType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ObjectDoubleCursor)object).key, ((ObjectDoubleCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(KType KType, double d) {
        int n = this.indexOf(KType);
        if (!this.indexExists(n)) {
            this.indexInsert(n, KType, d);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(KType KType, double d, double d2) {
        int n = this.indexOf(KType);
        if (this.indexExists(n)) {
            d = this.values[n] + d2;
            this.indexReplace(n, d);
        } else {
            this.indexInsert(n, KType, d);
        }
        return d;
    }

    protected void rehash(KType[] KTypeArray, double[] dArray) {
        int n;
        Object[] objectArray = this.keys;
        double[] dArray2 = this.values;
        int n2 = this.mask;
        int n3 = KTypeArray.length - 1;
        objectArray[objectArray.length - 1] = KTypeArray[n3];
        dArray2[dArray2.length - 1] = dArray[n3];
        while ((n = n3 - 1) >= 0) {
            KType KType = KTypeArray[n];
            n3 = n;
            if (KType == null) continue;
            n3 = this.hashKey(KType);
            while (objectArray[n3 &= n2] != null) {
                ++n3;
            }
            objectArray[n3] = KType;
            dArray2[n3] = dArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public double remove(KType object) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = false;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = 0.0;
            return (double)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                double d = this.values[n3];
                this.shiftConflictingKeys(n3);
                return d;
            }
            ++n3;
        }
        return 0.0;
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ObjectLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0;
            }
            Object[] objectArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                Object object2 = objectArray[n2];
                if (object2 != null && object.contains(object2)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ObjectCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ObjectDoublePredicate<? super KType> objectDoublePredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && objectDoublePredicate.apply(null, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0;
        }
        objectArray = this.keys;
        double[] dArray = this.values;
        while (n4 <= n3) {
            double d = objectArray[n4];
            if (d != null && objectDoublePredicate.apply(d, dArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && objectPredicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            Object object = objectArray[n2];
            if (object != null && objectPredicate.apply(object)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        Object[] objectArray = this.keys;
        double[] dArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            Object object;
            int n4;
            int n5 = 0;
            do {
                if ((object = objectArray[n4 = n + (n3 = n5 + 1) & n2]) == null) {
                    objectArray[n] = null;
                    dArray[n] = 0.0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(object) & n2) < n3);
            objectArray[n] = object;
            dArray[n] = dArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ObjectDoubleCursor<KType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ObjectDoubleCursor<KType> objectDoubleCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(objectDoubleCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(objectDoubleCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public DoubleCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectDoubleCursor<KType>> {
        private final ObjectDoubleCursor<KType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectDoubleCursor();
        }

        @Override
        protected ObjectDoubleCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectDoubleHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.key = object;
                        this.cursor.value = ObjectDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectDoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectDoubleHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(KType KType) {
            return this.owner.containsKey(KType);
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectDoublePredicate<KType>(){

                @Override
                public boolean apply(KType KType, double d) {
                    return t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectDoubleProcedure<KType>(){

                @Override
                public void apply(KType KType, double d) {
                    t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
            return this.owner.removeAll(objectPredicate);
        }

        @Override
        public int removeAll(KType KType) {
            if (this.owner.containsKey(KType)) {
                this.owner.remove(KType);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectDoubleHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.value = object;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final ObjectDoubleHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = ObjectDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(double d) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Double.doubleToLongBits(iterator.next().value) != Double.doubleToLongBits(d)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final double d) {
            return this.owner.removeAll(new ObjectDoublePredicate<KType>(){

                @Override
                public boolean apply(KType KType, double d2) {
                    boolean bl = Double.doubleToLongBits(d2) == Double.doubleToLongBits(d);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final DoublePredicate doublePredicate) {
            return this.owner.removeAll(new ObjectDoublePredicate<KType>(){

                @Override
                public boolean apply(KType KType, double d) {
                    return doublePredicate.apply(d);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object[] objectArray = ObjectDoubleHashMap.this.keys;
                    n = this.slot;
                    if (objectArray[n] != null) {
                        this.cursor.index = n;
                        this.cursor.value = ObjectDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }
}

