/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectFloatAssociativeContainer;
import com.carrotsearch.hppc.ObjectFloatMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.ObjectFloatPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.ObjectFloatProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectFloatHashMap<KType>
implements ObjectFloatMap<KType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public Object[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public float[] values;

    public ObjectFloatHashMap() {
        this(4);
    }

    public ObjectFloatHashMap(int n) {
        this(n, 0.75);
    }

    public ObjectFloatHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ObjectFloatHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ObjectFloatHashMap(ObjectFloatAssociativeContainer<? extends KType> objectFloatAssociativeContainer) {
        this(objectFloatAssociativeContainer.size());
        this.putAll(objectFloatAssociativeContainer);
    }

    public static <KType> ObjectFloatHashMap<KType> from(KType[] KTypeArray, float[] fArray) {
        if (KTypeArray.length == fArray.length) {
            ObjectFloatHashMap<KType> objectFloatHashMap = new ObjectFloatHashMap<KType>(KTypeArray.length);
            for (int i = 0; i < KTypeArray.length; ++i) {
                objectFloatHashMap.put(KTypeArray[i], fArray[i]);
            }
            return objectFloatHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public float addTo(KType KType, float f) {
        return this.putOrAdd(KType, f, f);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        Object[] objectArray = this.keys;
        float[] fArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new Object[n3];
            this.values = new float[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = objectArray;
            this.values = fArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, KType KType, float f) {
        Object[] objectArray = this.keys;
        float[] fArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        objectArray[n] = KType;
        fArray[n] = f;
        this.rehash(objectArray, fArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    public ObjectFloatHashMap<KType> clone() {
        try {
            ObjectFloatHashMap objectFloatHashMap = (ObjectFloatHashMap)super.clone();
            objectFloatHashMap.keys = (Object[])this.keys.clone();
            objectFloatHashMap.values = (float[])this.values.clone();
            objectFloatHashMap.hasEmptyKey = objectFloatHashMap.hasEmptyKey;
            objectFloatHashMap.orderMixer = this.orderMixer.clone();
            return objectFloatHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(KType KType) {
        Object object;
        if (KType == null) {
            return this.hasEmptyKey;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            Object[] objectArray = this.keys;
            float[] fArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (objectArray != null && !this.isEmpty()) {
                this.rehash(objectArray, fArray);
            }
        }
    }

    protected boolean equalElements(ObjectFloatHashMap<?> object) {
        if (((ObjectFloatHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((ObjectFloatHashMap)object).iterator();
        while (object.hasNext()) {
            ObjectFloatCursor objectFloatCursor = (ObjectFloatCursor)object.next();
            Object KType = objectFloatCursor.key;
            if (this.containsKey(KType) && Float.floatToIntBits(this.get(KType)) == Float.floatToIntBits(objectFloatCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ObjectFloatHashMap)this.getClass().cast(object));
        return bl;
    }

    protected boolean equals(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    @Override
    public <T extends ObjectFloatPredicate<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        float[] fArray = this.values;
        if (this.hasEmptyKey && !t.apply(null, fArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (objectArray[i] == null || t.apply((Object)objectArray[i], fArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ObjectFloatProcedure<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        float[] fArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(null, fArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (objectArray[i] == null) continue;
            t.apply((Object)objectArray[i], fArray[i]);
        }
        return t;
    }

    @Override
    public float get(KType KType) {
        Object object;
        float f = 0.0f;
        if (KType == null) {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0.0f;
    }

    @Override
    public float getOrDefault(KType KType, float f) {
        Object object;
        if (KType == null) {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n2];
            }
            ++n2;
        }
        return f;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectFloatCursor<KType> objectFloatCursor : this) {
            n += BitMixer.mix(objectFloatCursor.key) + BitMixer.mix(objectFloatCursor.value);
        }
        return n;
    }

    protected int hashKey(KType KType) {
        return BitMixer.mix(KType, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public float indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, KType KType, float f) {
        if (KType == null) {
            this.values[n] = f;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, KType, f);
            } else {
                this.keys[n] = KType;
                this.values[n] = f;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(KType KType) {
        Object object;
        int n = this.mask;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(KType);
        while ((object = objectArray[n3 &= n]) != null) {
            if (this.equals(object, KType)) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public float indexReplace(int n, float f) {
        float[] fArray = this.values;
        float f2 = fArray[n];
        fArray[n] = f;
        return f2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectFloatCursor<KType>> iterator() {
        return new EntryIterator();
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public float put(KType object, float f) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = true;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = f;
            return (float)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                object = this.values;
                KType KType = object[n3];
                object[n3] = f;
                return (float)KType;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, object, f);
        } else {
            objectArray[n3] = object;
            this.values[n3] = f;
        }
        ++this.assigned;
        return 0.0f;
    }

    @Override
    public int putAll(ObjectFloatAssociativeContainer<? extends KType> object) {
        int n = this.size();
        Iterator<ObjectFloatCursor<KType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ObjectFloatCursor)object).key, ((ObjectFloatCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ObjectFloatCursor<? extends KType>> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ObjectFloatCursor objectFloatCursor = (ObjectFloatCursor)object.next();
            this.put(objectFloatCursor.key, objectFloatCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(KType KType, float f) {
        int n = this.indexOf(KType);
        if (!this.indexExists(n)) {
            this.indexInsert(n, KType, f);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(KType KType, float f, float f2) {
        int n = this.indexOf(KType);
        if (this.indexExists(n)) {
            f = this.values[n] + f2;
            this.indexReplace(n, f);
        } else {
            this.indexInsert(n, KType, f);
        }
        return f;
    }

    protected void rehash(KType[] KTypeArray, float[] fArray) {
        int n;
        Object[] objectArray = this.keys;
        float[] fArray2 = this.values;
        int n2 = this.mask;
        int n3 = KTypeArray.length - 1;
        objectArray[objectArray.length - 1] = KTypeArray[n3];
        fArray2[fArray2.length - 1] = fArray[n3];
        while ((n = n3 - 1) >= 0) {
            KType KType = KTypeArray[n];
            n3 = n;
            if (KType == null) continue;
            n3 = this.hashKey(KType);
            while (objectArray[n3 &= n2] != null) {
                ++n3;
            }
            objectArray[n3] = KType;
            fArray2[n3] = fArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public float remove(KType object) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = false;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = 0.0f;
            return (float)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                float f = this.values[n3];
                this.shiftConflictingKeys(n3);
                return f;
            }
            ++n3;
        }
        return 0.0f;
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ObjectLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0f;
            }
            Object[] objectArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                Object object2 = objectArray[n2];
                if (object2 != null && object.contains(object2)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ObjectCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ObjectFloatPredicate<? super KType> objectFloatPredicate) {
        int n;
        Object object;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && objectFloatPredicate.apply(null, (object = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0f;
        }
        Object[] objectArray = this.keys;
        float[] fArray = this.values;
        while (n4 <= n3) {
            object = objectArray[n4];
            if (object != null && objectFloatPredicate.apply(object, fArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && objectPredicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0f;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            Object object = objectArray[n2];
            if (object != null && objectPredicate.apply(object)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        Object[] objectArray = this.keys;
        float[] fArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            Object object;
            int n4;
            int n5 = 0;
            do {
                if ((object = objectArray[n4 = n + (n3 = n5 + 1) & n2]) == null) {
                    objectArray[n] = null;
                    fArray[n] = 0.0f;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(object) & n2) < n3);
            objectArray[n] = object;
            fArray[n] = fArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ObjectFloatCursor<KType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ObjectFloatCursor<KType> objectFloatCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(objectFloatCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(objectFloatCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public FloatCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectFloatCursor<KType>> {
        private final ObjectFloatCursor<KType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectFloatCursor();
        }

        @Override
        protected ObjectFloatCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectFloatHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.key = object;
                        this.cursor.value = ObjectFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectFloatCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectFloatHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(KType KType) {
            return this.owner.containsKey(KType);
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectFloatPredicate<KType>(){

                @Override
                public boolean apply(KType KType, float f) {
                    return t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectFloatProcedure<KType>(){

                @Override
                public void apply(KType KType, float f) {
                    t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
            return this.owner.removeAll(objectPredicate);
        }

        @Override
        public int removeAll(KType KType) {
            if (this.owner.containsKey(KType)) {
                this.owner.remove(KType);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectFloatHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.value = object;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final ObjectFloatHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = ObjectFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(float f) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Float.floatToIntBits(iterator.next().value) != Float.floatToIntBits(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final float f) {
            return this.owner.removeAll(new ObjectFloatPredicate<KType>(){

                @Override
                public boolean apply(KType KType, float f2) {
                    boolean bl = Float.floatToIntBits(f2) == Float.floatToIntBits(f);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final FloatPredicate floatPredicate) {
            return this.owner.removeAll(new ObjectFloatPredicate<KType>(){

                @Override
                public boolean apply(KType KType, float f) {
                    return floatPredicate.apply(f);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new FloatCursor();
        }

        @Override
        protected FloatCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object[] objectArray = ObjectFloatHashMap.this.keys;
                    n = this.slot;
                    if (objectArray[n] != null) {
                        this.cursor.index = n;
                        this.cursor.value = ObjectFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }
}

