/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectSet;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectHashSet<KType>
extends AbstractObjectCollection<KType>
implements ObjectLookupContainer<KType>,
ObjectSet<KType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public Object[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;

    public ObjectHashSet() {
        this(4, 0.75);
    }

    public ObjectHashSet(int n) {
        this(n, 0.75);
    }

    public ObjectHashSet(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ObjectHashSet(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ObjectHashSet(ObjectContainer<? extends KType> objectContainer) {
        this(objectContainer.size());
        this.addAll(objectContainer);
    }

    @SafeVarargs
    public static <KType> ObjectHashSet<KType> from(KType ... KTypeArray) {
        ObjectHashSet<KType> objectHashSet = new ObjectHashSet<KType>(KTypeArray.length);
        objectHashSet.addAll(KTypeArray);
        return objectHashSet;
    }

    private boolean sameKeys(ObjectSet<?> object) {
        if (object.size() != this.size()) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (this.contains(((ObjectCursor)object.next()).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(KType KType) {
        Object object;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = true;
            return bl ^ true;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return false;
            }
            ++n2;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n2, KType);
        } else {
            objectArray[n2] = KType;
        }
        ++this.assigned;
        return true;
    }

    public int addAll(ObjectContainer<? extends KType> objectContainer) {
        this.ensureCapacity(objectContainer.size());
        return this.addAll((Iterable<? extends ObjectCursor<? extends KType>>)objectContainer);
    }

    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            if (!this.add(((ObjectCursor)object.next()).value)) continue;
            ++n;
        }
        return n;
    }

    @SafeVarargs
    public final int addAll(KType ... KTypeArray) {
        this.ensureCapacity(KTypeArray.length);
        int n = KTypeArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = n2;
            if (this.add(KTypeArray[i])) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        Object[] objectArray = this.keys;
        try {
            this.keys = new Object[n + 1];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = objectArray;
            n2 = this.keys == null ? 0 : this.size();
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, KType KType) {
        Object[] objectArray = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        objectArray[n] = KType;
        this.rehash(objectArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    public ObjectHashSet<KType> clone() {
        try {
            ObjectHashSet objectHashSet = (ObjectHashSet)super.clone();
            objectHashSet.keys = (Object[])this.keys.clone();
            objectHashSet.hasEmptyKey = objectHashSet.hasEmptyKey;
            objectHashSet.orderMixer = this.orderMixer.clone();
            return objectHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(KType KType) {
        Object object;
        if (KType == null) {
            return this.hasEmptyKey;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            Object[] objectArray = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (objectArray != null && !this.isEmpty()) {
                this.rehash(objectArray);
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.sameKeys((ObjectSet)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T t) {
        Object object;
        if (this.hasEmptyKey && !t.apply(null)) {
            return t;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        for (int i = 0; i <= n && ((object = objectArray[i]) == null || t.apply((Object)object)); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T t) {
        if (this.hasEmptyKey) {
            t.apply(null);
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            t.apply((Object)object);
        }
        return t;
    }

    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        Object[] objectArray = this.keys;
        int n2 = n;
        for (int i = this.mask; i >= 0; --i) {
            Object object = objectArray[i];
            n = n2;
            if (object != null) {
                n = n2 + BitMixer.mix(object);
            }
            n2 = n;
        }
        return n2;
    }

    protected int hashKey(KType KType) {
        return BitMixer.mix(KType, this.keyMixer);
    }

    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    public KType indexGet(int n) {
        return (KType)this.keys[n];
    }

    public void indexInsert(int n, KType KType) {
        if (KType == null) {
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, KType);
            } else {
                this.keys[n] = KType;
            }
            ++this.assigned;
        }
    }

    public int indexOf(KType KType) {
        Object object;
        int n = this.mask;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(KType);
        while ((object = objectArray[n3 &= n]) != null) {
            if (this.equals(object, KType)) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    public KType indexReplace(int n, KType KType) {
        Object[] objectArray = this.keys;
        Object object = objectArray[n];
        objectArray[n] = KType;
        return (KType)object;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new EntryIterator();
    }

    protected void rehash(KType[] KTypeArray) {
        int n;
        Object[] objectArray = this.keys;
        int n2 = this.mask;
        int n3 = KTypeArray.length - 1;
        while ((n = n3 - 1) >= 0) {
            KType KType = KTypeArray[n];
            n3 = n;
            if (KType == null) continue;
            n3 = this.hashKey(KType);
            while (objectArray[n3 &= n2] != null) {
                ++n3;
            }
            objectArray[n3] = KType;
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    public boolean remove(KType KType) {
        Object object;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return bl;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                this.shiftConflictingKeys(n2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && objectPredicate.apply(null)) {
            this.hasEmptyKey = false;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            Object object = objectArray[n2];
            if (object != null && objectPredicate.apply(object)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    @Override
    public int removeAll(KType KType) {
        return this.remove(KType) ? 1 : 0;
    }

    protected void shiftConflictingKeys(int n) {
        Object[] objectArray = this.keys;
        int n2 = this.mask;
        while (true) {
            int n3;
            Object object;
            int n4;
            int n5 = 0;
            do {
                if ((object = objectArray[n4 = n + (n3 = n5 + 1) & n2]) == null) {
                    objectArray[n] = null;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(object) & n2) < n3);
            objectArray[n] = object;
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    @Override
    public Object[] toArray() {
        int n;
        Object[] objectArray = new Object[this.size()];
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl) {
            objectArray[0] = null;
            n = 1;
        } else {
            n = 0;
        }
        Object[] objectArray2 = this.keys;
        int n3 = this.mask;
        int n4 = n;
        while (n2 <= n3) {
            Object object = objectArray2[n2];
            n = n4;
            if (object != null) {
                objectArray[n4] = object;
                n = n4 + 1;
            }
            ++n2;
            n4 = n;
        }
        return objectArray;
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    protected final class EntryIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectHashSet.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.value = object;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

