/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectIntAssociativeContainer;
import com.carrotsearch.hppc.ObjectIntMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectIntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.ObjectIntPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.ObjectIntProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectIntHashMap<KType>
implements ObjectIntMap<KType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public Object[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public int[] values;

    public ObjectIntHashMap() {
        this(4);
    }

    public ObjectIntHashMap(int n) {
        this(n, 0.75);
    }

    public ObjectIntHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ObjectIntHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ObjectIntHashMap(ObjectIntAssociativeContainer<? extends KType> objectIntAssociativeContainer) {
        this(objectIntAssociativeContainer.size());
        this.putAll(objectIntAssociativeContainer);
    }

    public static <KType> ObjectIntHashMap<KType> from(KType[] KTypeArray, int[] nArray) {
        if (KTypeArray.length == nArray.length) {
            ObjectIntHashMap<KType> objectIntHashMap = new ObjectIntHashMap<KType>(KTypeArray.length);
            for (int i = 0; i < KTypeArray.length; ++i) {
                objectIntHashMap.put(KTypeArray[i], nArray[i]);
            }
            return objectIntHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public int addTo(KType KType, int n) {
        return this.putOrAdd(KType, n, n);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        Object[] objectArray = this.keys;
        int[] nArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new Object[n3];
            this.values = new int[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = objectArray;
            this.values = nArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, KType KType, int n2) {
        Object[] objectArray = this.keys;
        int[] nArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        objectArray[n] = KType;
        nArray[n] = n2;
        this.rehash(objectArray, nArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    public ObjectIntHashMap<KType> clone() {
        try {
            ObjectIntHashMap objectIntHashMap = (ObjectIntHashMap)super.clone();
            objectIntHashMap.keys = (Object[])this.keys.clone();
            objectIntHashMap.values = (int[])this.values.clone();
            objectIntHashMap.hasEmptyKey = objectIntHashMap.hasEmptyKey;
            objectIntHashMap.orderMixer = this.orderMixer.clone();
            return objectIntHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(KType KType) {
        Object object;
        if (KType == null) {
            return this.hasEmptyKey;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            Object[] objectArray = this.keys;
            int[] nArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (objectArray != null && !this.isEmpty()) {
                this.rehash(objectArray, nArray);
            }
        }
    }

    protected boolean equalElements(ObjectIntHashMap<?> object) {
        if (((ObjectIntHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((ObjectIntHashMap)object).iterator();
        while (object.hasNext()) {
            ObjectIntCursor objectIntCursor = (ObjectIntCursor)object.next();
            Object KType = objectIntCursor.key;
            if (this.containsKey(KType) && this.get(KType) == objectIntCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ObjectIntHashMap)this.getClass().cast(object));
        return bl;
    }

    protected boolean equals(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    @Override
    public <T extends ObjectIntPredicate<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        int[] nArray = this.values;
        if (this.hasEmptyKey && !t.apply(null, nArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (objectArray[i] == null || t.apply((Object)objectArray[i], nArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ObjectIntProcedure<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        int[] nArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(null, nArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (objectArray[i] == null) continue;
            t.apply((Object)objectArray[i], nArray[i]);
        }
        return t;
    }

    @Override
    public int get(KType KType) {
        Object object;
        int n = 0;
        if (KType == null) {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
            }
            return n;
        }
        Object[] objectArray = this.keys;
        int n2 = this.mask;
        n = this.hashKey(KType);
        while ((object = objectArray[n &= n2]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n];
            }
            ++n;
        }
        return 0;
    }

    @Override
    public int getOrDefault(KType KType, int n) {
        Object object;
        if (KType == null) {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
            }
            return n;
        }
        Object[] objectArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(KType);
        while ((object = objectArray[n3 &= n2]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n3];
            }
            ++n3;
        }
        return n;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectIntCursor<KType> objectIntCursor : this) {
            n += BitMixer.mix(objectIntCursor.key) + BitMixer.mix(objectIntCursor.value);
        }
        return n;
    }

    protected int hashKey(KType KType) {
        return BitMixer.mix(KType, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public int indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, KType KType, int n2) {
        if (KType == null) {
            this.values[n] = n2;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, KType, n2);
            } else {
                this.keys[n] = KType;
                this.values[n] = n2;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(KType KType) {
        Object object;
        int n = this.mask;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(KType);
        while ((object = objectArray[n3 &= n]) != null) {
            if (this.equals(object, KType)) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public int indexReplace(int n, int n2) {
        int[] nArray = this.values;
        int n3 = nArray[n];
        nArray[n] = n2;
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectIntCursor<KType>> iterator() {
        return new EntryIterator();
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public int put(KType object, int n) {
        Object object2;
        Object object3 = this.mask;
        if (object == null) {
            this.hasEmptyKey = true;
            object = this.values;
            int n2 = object3 + 1;
            object3 = object[n2];
            object[n2] = n;
            return object3;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= object3]) != null) {
            if (this.equals(object2, object)) {
                object = this.values;
                object3 = object[n3];
                object[n3] = n;
                return object3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, object, n);
        } else {
            objectArray[n3] = object;
            this.values[n3] = n;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(ObjectIntAssociativeContainer<? extends KType> object) {
        int n = this.size();
        Iterator<ObjectIntCursor<KType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ObjectIntCursor)object).key, ((ObjectIntCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ObjectIntCursor<? extends KType>> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ObjectIntCursor objectIntCursor = (ObjectIntCursor)object.next();
            this.put(objectIntCursor.key, objectIntCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(KType KType, int n) {
        int n2 = this.indexOf(KType);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, KType, n);
            return true;
        }
        return false;
    }

    @Override
    public int putOrAdd(KType KType, int n, int n2) {
        int n3 = this.indexOf(KType);
        if (this.indexExists(n3)) {
            n = this.values[n3] + n2;
            this.indexReplace(n3, n);
        } else {
            this.indexInsert(n3, KType, n);
        }
        return n;
    }

    protected void rehash(KType[] KTypeArray, int[] nArray) {
        int n;
        Object[] objectArray = this.keys;
        int[] nArray2 = this.values;
        int n2 = this.mask;
        int n3 = KTypeArray.length - 1;
        objectArray[objectArray.length - 1] = KTypeArray[n3];
        nArray2[nArray2.length - 1] = nArray[n3];
        while ((n = n3 - 1) >= 0) {
            KType KType = KTypeArray[n];
            n3 = n;
            if (KType == null) continue;
            n3 = this.hashKey(KType);
            while (objectArray[n3 &= n2] != null) {
                ++n3;
            }
            objectArray[n3] = KType;
            nArray2[n3] = nArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int remove(KType object) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = false;
            object = this.values;
            KType KType = object[++n];
            object[n] = false;
            return (int)KType;
        }
        Object[] objectArray = this.keys;
        int n2 = this.hashKey(object);
        while ((object2 = objectArray[n2 &= n]) != null) {
            if (this.equals(object2, object)) {
                n = this.values[n2];
                this.shiftConflictingKeys(n2);
                return n;
            }
            ++n2;
        }
        return 0;
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ObjectLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            Object[] objectArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                Object object2 = objectArray[n2];
                if (object2 != null && object.contains(object2)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ObjectCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ObjectIntPredicate<? super KType> objectIntPredicate) {
        int n;
        Object object;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && objectIntPredicate.apply(null, (object = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0;
        }
        Object[] objectArray = this.keys;
        int[] nArray = this.values;
        while (n4 <= n3) {
            object = objectArray[n4];
            if (object != null && objectIntPredicate.apply(object, nArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && objectPredicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            Object object = objectArray[n2];
            if (object != null && objectPredicate.apply(object)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        Object[] objectArray = this.keys;
        int[] nArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            Object object;
            int n4;
            int n5 = 0;
            do {
                if ((object = objectArray[n4 = n + (n3 = n5 + 1) & n2]) == null) {
                    objectArray[n] = null;
                    nArray[n] = 0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(object) & n2) < n3);
            objectArray[n] = object;
            nArray[n] = nArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ObjectIntCursor<KType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ObjectIntCursor<KType> objectIntCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(objectIntCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(objectIntCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public IntCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectIntCursor<KType>> {
        private final ObjectIntCursor<KType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectIntCursor();
        }

        @Override
        protected ObjectIntCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectIntHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.key = object;
                        this.cursor.value = ObjectIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectIntCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectIntHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(KType KType) {
            return this.owner.containsKey(KType);
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectIntPredicate<KType>(){

                @Override
                public boolean apply(KType KType, int n) {
                    return t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectIntProcedure<KType>(){

                @Override
                public void apply(KType KType, int n) {
                    t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
            return this.owner.removeAll(objectPredicate);
        }

        @Override
        public int removeAll(KType KType) {
            if (this.owner.containsKey(KType)) {
                this.owner.remove(KType);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectIntHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.value = object;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final ObjectIntHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = ObjectIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != n) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntPredicate> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final int n) {
            return this.owner.removeAll(new ObjectIntPredicate<KType>(){

                @Override
                public boolean apply(KType KType, int n2) {
                    boolean bl = n2 == n;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final IntPredicate intPredicate) {
            return this.owner.removeAll(new ObjectIntPredicate<KType>(){

                @Override
                public boolean apply(KType KType, int n) {
                    return intPredicate.apply(n);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object[] objectArray = ObjectIntHashMap.this.keys;
                    n = this.slot;
                    if (objectArray[n] != null) {
                        this.cursor.index = n;
                        this.cursor.value = ObjectIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

