/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLongAssociativeContainer;
import com.carrotsearch.hppc.ObjectLongMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.predicates.ObjectLongPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.procedures.ObjectLongProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectLongHashMap<KType>
implements ObjectLongMap<KType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public Object[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public long[] values;

    public ObjectLongHashMap() {
        this(4);
    }

    public ObjectLongHashMap(int n) {
        this(n, 0.75);
    }

    public ObjectLongHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ObjectLongHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ObjectLongHashMap(ObjectLongAssociativeContainer<? extends KType> objectLongAssociativeContainer) {
        this(objectLongAssociativeContainer.size());
        this.putAll(objectLongAssociativeContainer);
    }

    public static <KType> ObjectLongHashMap<KType> from(KType[] KTypeArray, long[] lArray) {
        if (KTypeArray.length == lArray.length) {
            ObjectLongHashMap<KType> objectLongHashMap = new ObjectLongHashMap<KType>(KTypeArray.length);
            for (int i = 0; i < KTypeArray.length; ++i) {
                objectLongHashMap.put(KTypeArray[i], lArray[i]);
            }
            return objectLongHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public long addTo(KType KType, long l) {
        return this.putOrAdd(KType, l, l);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        Object[] objectArray = this.keys;
        long[] lArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new Object[n3];
            this.values = new long[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = objectArray;
            this.values = lArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, KType KType, long l) {
        Object[] objectArray = this.keys;
        long[] lArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        objectArray[n] = KType;
        lArray[n] = l;
        this.rehash(objectArray, lArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    public ObjectLongHashMap<KType> clone() {
        try {
            ObjectLongHashMap objectLongHashMap = (ObjectLongHashMap)super.clone();
            objectLongHashMap.keys = (Object[])this.keys.clone();
            objectLongHashMap.values = (long[])this.values.clone();
            objectLongHashMap.hasEmptyKey = objectLongHashMap.hasEmptyKey;
            objectLongHashMap.orderMixer = this.orderMixer.clone();
            return objectLongHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(KType KType) {
        Object object;
        if (KType == null) {
            return this.hasEmptyKey;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            Object[] objectArray = this.keys;
            long[] lArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (objectArray != null && !this.isEmpty()) {
                this.rehash(objectArray, lArray);
            }
        }
    }

    protected boolean equalElements(ObjectLongHashMap<?> object) {
        if (((ObjectLongHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<ObjectLongCursor<?>> iterator = ((ObjectLongHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Object KType = ((ObjectLongCursor)object).key;
            if (this.containsKey(KType) && this.get(KType) == ((ObjectLongCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ObjectLongHashMap)this.getClass().cast(object));
        return bl;
    }

    protected boolean equals(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    @Override
    public <T extends ObjectLongPredicate<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        long[] lArray = this.values;
        if (this.hasEmptyKey && !t.apply(null, lArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (objectArray[i] == null || t.apply((Object)objectArray[i], lArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ObjectLongProcedure<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        long[] lArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(null, lArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (objectArray[i] == null) continue;
            t.apply((Object)objectArray[i], lArray[i]);
        }
        return t;
    }

    @Override
    public long get(KType KType) {
        Object object;
        long l = 0L;
        if (KType == null) {
            if (this.hasEmptyKey) {
                l = this.values[this.mask + 1];
            }
            return l;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0L;
    }

    @Override
    public long getOrDefault(KType KType, long l) {
        Object object;
        if (KType == null) {
            if (this.hasEmptyKey) {
                l = this.values[this.mask + 1];
            }
            return l;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n2];
            }
            ++n2;
        }
        return l;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectLongCursor<KType> objectLongCursor : this) {
            n += BitMixer.mix(objectLongCursor.key) + BitMixer.mix(objectLongCursor.value);
        }
        return n;
    }

    protected int hashKey(KType KType) {
        return BitMixer.mix(KType, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public long indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, KType KType, long l) {
        if (KType == null) {
            this.values[n] = l;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, KType, l);
            } else {
                this.keys[n] = KType;
                this.values[n] = l;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(KType KType) {
        Object object;
        int n = this.mask;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(KType);
        while ((object = objectArray[n3 &= n]) != null) {
            if (this.equals(object, KType)) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public long indexReplace(int n, long l) {
        long[] lArray = this.values;
        long l2 = lArray[n];
        lArray[n] = l;
        return l2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectLongCursor<KType>> iterator() {
        return new EntryIterator();
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public long put(KType object, long l) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = true;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = l;
            return (long)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                object = this.values;
                KType KType = object[n3];
                object[n3] = l;
                return (long)KType;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, object, l);
        } else {
            objectArray[n3] = object;
            this.values[n3] = l;
        }
        ++this.assigned;
        return 0L;
    }

    @Override
    public int putAll(ObjectLongAssociativeContainer<? extends KType> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ObjectLongCursor objectLongCursor = (ObjectLongCursor)object.next();
            this.put(objectLongCursor.key, objectLongCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ObjectLongCursor<? extends KType>> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ObjectLongCursor objectLongCursor = (ObjectLongCursor)object.next();
            this.put(objectLongCursor.key, objectLongCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(KType KType, long l) {
        int n = this.indexOf(KType);
        if (!this.indexExists(n)) {
            this.indexInsert(n, KType, l);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(KType KType, long l, long l2) {
        int n = this.indexOf(KType);
        if (this.indexExists(n)) {
            l = this.values[n] + l2;
            this.indexReplace(n, l);
        } else {
            this.indexInsert(n, KType, l);
        }
        return l;
    }

    protected void rehash(KType[] KTypeArray, long[] lArray) {
        int n;
        Object[] objectArray = this.keys;
        long[] lArray2 = this.values;
        int n2 = this.mask;
        int n3 = KTypeArray.length - 1;
        objectArray[objectArray.length - 1] = KTypeArray[n3];
        lArray2[lArray2.length - 1] = lArray[n3];
        while ((n = n3 - 1) >= 0) {
            KType KType = KTypeArray[n];
            n3 = n;
            if (KType == null) continue;
            n3 = this.hashKey(KType);
            while (objectArray[n3 &= n2] != null) {
                ++n3;
            }
            objectArray[n3] = KType;
            lArray2[n3] = lArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public long remove(KType object) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = false;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = 0L;
            return (long)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                long l = this.values[n3];
                this.shiftConflictingKeys(n3);
                return l;
            }
            ++n3;
        }
        return 0L;
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ObjectLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0L;
            }
            Object[] objectArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                Object object2 = objectArray[n2];
                if (object2 != null && object.contains(object2)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ObjectCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ObjectLongPredicate<? super KType> objectLongPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && objectLongPredicate.apply(null, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0L;
        }
        objectArray = this.keys;
        long[] lArray = this.values;
        while (n4 <= n3) {
            long l = objectArray[n4];
            if (l != null && objectLongPredicate.apply(l, lArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && objectPredicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0L;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            Object object = objectArray[n2];
            if (object != null && objectPredicate.apply(object)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        Object[] objectArray = this.keys;
        long[] lArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            Object object;
            int n4;
            int n5 = 0;
            do {
                if ((object = objectArray[n4 = n + (n3 = n5 + 1) & n2]) == null) {
                    objectArray[n] = null;
                    lArray[n] = 0L;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(object) & n2) < n3);
            objectArray[n] = object;
            lArray[n] = lArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ObjectLongCursor<KType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ObjectLongCursor<KType> objectLongCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(objectLongCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(objectLongCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public LongCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectLongCursor<KType>> {
        private final ObjectLongCursor<KType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectLongCursor();
        }

        @Override
        protected ObjectLongCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectLongHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.key = object;
                        this.cursor.value = ObjectLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectLongCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectLongHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(KType KType) {
            return this.owner.containsKey(KType);
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectLongPredicate<KType>(){

                @Override
                public boolean apply(KType KType, long l) {
                    return t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectLongProcedure<KType>(){

                @Override
                public void apply(KType KType, long l) {
                    t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
            return this.owner.removeAll(objectPredicate);
        }

        @Override
        public int removeAll(KType KType) {
            if (this.owner.containsKey(KType)) {
                this.owner.remove(KType);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectLongHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.value = object;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final ObjectLongHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = ObjectLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != l) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongPredicate> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final long l) {
            return this.owner.removeAll(new ObjectLongPredicate<KType>(){

                @Override
                public boolean apply(KType KType, long l2) {
                    boolean bl = l2 == l;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final LongPredicate longPredicate) {
            return this.owner.removeAll(new ObjectLongPredicate<KType>(){

                @Override
                public boolean apply(KType KType, long l) {
                    return longPredicate.apply(l);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object[] objectArray = ObjectLongHashMap.this.keys;
                    n = this.slot;
                    if (objectArray[n] != null) {
                        this.cursor.index = n;
                        this.cursor.value = ObjectLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

