/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectObjectAssociativeContainer;
import com.carrotsearch.hppc.ObjectObjectMap;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectObjectPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectObjectProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class ObjectObjectHashMap<KType, VType>
implements ObjectObjectMap<KType, VType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public Object[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public Object[] values;

    public ObjectObjectHashMap() {
        this(4);
    }

    public ObjectObjectHashMap(int n) {
        this(n, 0.75);
    }

    public ObjectObjectHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ObjectObjectHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ObjectObjectHashMap(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> objectObjectAssociativeContainer) {
        this(objectObjectAssociativeContainer.size());
        this.putAll(objectObjectAssociativeContainer);
    }

    public static <KType, VType> ObjectObjectHashMap<KType, VType> from(KType[] KTypeArray, VType[] VTypeArray) {
        if (KTypeArray.length == VTypeArray.length) {
            ObjectObjectHashMap<KType, VType> objectObjectHashMap = new ObjectObjectHashMap<KType, VType>(KTypeArray.length);
            for (int i = 0; i < KTypeArray.length; ++i) {
                objectObjectHashMap.put(KTypeArray[i], VTypeArray[i]);
            }
            return objectObjectHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int n3 = n + 1;
        try {
            this.keys = new Object[n3];
            this.values = new Object[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = objectArray;
            this.values = objectArray2;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, KType KType, VType VType) {
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        objectArray[n] = KType;
        objectArray2[n] = VType;
        this.rehash(objectArray, objectArray2);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
    }

    public ObjectObjectHashMap<KType, VType> clone() {
        try {
            ObjectObjectHashMap objectObjectHashMap = (ObjectObjectHashMap)super.clone();
            objectObjectHashMap.keys = (Object[])this.keys.clone();
            objectObjectHashMap.values = (Object[])this.values.clone();
            objectObjectHashMap.hasEmptyKey = objectObjectHashMap.hasEmptyKey;
            objectObjectHashMap.orderMixer = this.orderMixer.clone();
            return objectObjectHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(KType KType) {
        Object object;
        if (KType == null) {
            return this.hasEmptyKey;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            Object[] objectArray = this.keys;
            Object[] objectArray2 = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (objectArray != null && !this.isEmpty()) {
                this.rehash(objectArray, objectArray2);
            }
        }
    }

    protected boolean equalElements(ObjectObjectHashMap<?, ?> objectObjectHashMap) {
        if (objectObjectHashMap.size() != this.size()) {
            return false;
        }
        for (ObjectObjectCursor<Object, Object> objectObjectCursor : objectObjectHashMap) {
            objectObjectHashMap = objectObjectCursor.key;
            if (this.containsKey(objectObjectHashMap) && Objects.equals(this.get(objectObjectHashMap), objectObjectCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ObjectObjectHashMap)this.getClass().cast(object));
        return bl;
    }

    protected boolean equals(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    @Override
    public <T extends ObjectObjectPredicate<? super KType, ? super VType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        if (this.hasEmptyKey && !t.apply(null, (Object)objectArray2[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (objectArray[i] == null || t.apply((Object)objectArray[i], (Object)objectArray2[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ObjectObjectProcedure<? super KType, ? super VType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        if (this.hasEmptyKey) {
            t.apply(null, (Object)objectArray2[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (objectArray[i] == null) continue;
            t.apply((Object)objectArray[i], (Object)objectArray2[i]);
        }
        return t;
    }

    @Override
    public VType get(KType object) {
        Object object2 = null;
        if (object == null) {
            object = object2;
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return (VType)object;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(object);
        while ((object2 = objectArray[n2 &= n]) != null) {
            if (this.equals(object2, object)) {
                return (VType)this.values[n2];
            }
            ++n2;
        }
        return null;
    }

    @Override
    public VType getOrDefault(KType KType, VType object) {
        Object object2;
        if (KType == null) {
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return object;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object2 = objectArray[n2 &= n]) != null) {
            if (this.equals(object2, KType)) {
                return (VType)this.values[n2];
            }
            ++n2;
        }
        return object;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectObjectCursor<KType, VType> objectObjectCursor : this) {
            n += BitMixer.mix(objectObjectCursor.key) + BitMixer.mix(objectObjectCursor.value);
        }
        return n;
    }

    protected int hashKey(KType KType) {
        return BitMixer.mix(KType, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public VType indexGet(int n) {
        return (VType)this.values[n];
    }

    @Override
    public void indexInsert(int n, KType KType, VType VType) {
        if (KType == null) {
            this.values[n] = VType;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, KType, VType);
            } else {
                this.keys[n] = KType;
                this.values[n] = VType;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(KType KType) {
        Object object;
        int n = this.mask;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(KType);
        while ((object = objectArray[n3 &= n]) != null) {
            if (this.equals(object, KType)) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public VType indexReplace(int n, VType VType) {
        Object[] objectArray = this.values;
        Object object = objectArray[n];
        objectArray[n] = VType;
        return (VType)object;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectObjectCursor<KType, VType>> iterator() {
        return new EntryIterator();
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public VType put(KType object, VType VType) {
        Object[] objectArray;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = true;
            Object[] objectArray2 = this.values;
            int n2 = n + 1;
            object = objectArray2[n2];
            objectArray2[n2] = VType;
            return (VType)object;
        }
        Object[] objectArray3 = this.keys;
        int n3 = this.hashKey(object);
        while ((objectArray = objectArray3[n3 &= n]) != null) {
            if (this.equals(objectArray, object)) {
                objectArray = this.values;
                object = objectArray[n3];
                objectArray[n3] = VType;
                return (VType)object;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, object, VType);
        } else {
            objectArray3[n3] = object;
            this.values[n3] = VType;
        }
        ++this.assigned;
        return null;
    }

    @Override
    public int putAll(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> object) {
        int n = this.size();
        Iterator<ObjectObjectCursor<KType, VType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ObjectObjectCursor)object).key, ((ObjectObjectCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ObjectObjectCursor<? extends KType, ? extends VType>> object) {
        int n = this.size();
        Iterator<ObjectObjectCursor<KType, VType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ObjectObjectCursor)object).key, ((ObjectObjectCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(KType KType, VType VType) {
        int n = this.indexOf(KType);
        if (!this.indexExists(n)) {
            this.indexInsert(n, KType, VType);
            return true;
        }
        return false;
    }

    protected void rehash(KType[] KTypeArray, VType[] VTypeArray) {
        int n;
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int n2 = this.mask;
        int n3 = KTypeArray.length - 1;
        objectArray[objectArray.length - 1] = KTypeArray[n3];
        objectArray2[objectArray2.length - 1] = VTypeArray[n3];
        while ((n = n3 - 1) >= 0) {
            KType KType = KTypeArray[n];
            n3 = n;
            if (KType == null) continue;
            n3 = this.hashKey(KType);
            while (objectArray[n3 &= n2] != null) {
                ++n3;
            }
            objectArray[n3] = KType;
            objectArray2[n3] = VTypeArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public VType remove(KType object) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = false;
            Object[] objectArray = this.values;
            int n2 = n + 1;
            object = objectArray[n2];
            objectArray[n2] = null;
            return (VType)object;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                object = this.values[n3];
                this.shiftConflictingKeys(n3);
                return (VType)object;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ObjectLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = null;
            }
            Object[] objectArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                Object object2 = objectArray[n2];
                if (object2 != null && object.contains(object2)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ObjectCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ObjectObjectPredicate<? super KType, ? super VType> objectObjectPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && objectObjectPredicate.apply(null, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = null;
        }
        Object[] objectArray2 = this.keys;
        objectArray = this.values;
        while (n4 <= n3) {
            Object object = objectArray2[n4];
            if (object != null && objectObjectPredicate.apply(object, objectArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && objectPredicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = null;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            Object object = objectArray[n2];
            if (object != null && objectPredicate.apply(object)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            Object object;
            int n4;
            int n5 = 0;
            do {
                if ((object = objectArray[n4 = n + (n3 = n5 + 1) & n2]) == null) {
                    objectArray[n] = null;
                    objectArray2[n] = null;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(object) & n2) < n3);
            objectArray[n] = object;
            objectArray2[n] = objectArray2[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ObjectObjectCursor<KType, VType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ObjectObjectCursor<KType, VType> objectObjectCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(objectObjectCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(objectObjectCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ObjectCollection<VType> values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectObjectCursor<KType, VType>> {
        private final ObjectObjectCursor<KType, VType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectObjectCursor();
        }

        @Override
        protected ObjectObjectCursor<KType, VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectObjectHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.key = object;
                        this.cursor.value = ObjectObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectObjectCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectObjectHashMap<KType, VType> owner;

        public KeysContainer() {
            this.owner = ObjectObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(KType KType) {
            return this.owner.containsKey(KType);
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectObjectPredicate<KType, VType>(){

                @Override
                public boolean apply(KType KType, VType VType) {
                    return t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectObjectProcedure<KType, VType>(){

                @Override
                public void apply(KType KType, VType VType) {
                    t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
            return this.owner.removeAll(objectPredicate);
        }

        @Override
        public int removeAll(KType KType) {
            if (this.owner.containsKey(KType)) {
                this.owner.remove(KType);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectObjectHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.value = object;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final ObjectObjectHashMap<KType, VType> owner;

        private ValuesContainer() {
            this.owner = ObjectObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(VType VType) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (!Objects.equals(iterator.next().value, VType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ObjectPredicate<? super VType> objectPredicate) {
            return this.owner.removeAll(new ObjectObjectPredicate<KType, VType>(){

                @Override
                public boolean apply(KType KType, VType VType) {
                    return objectPredicate.apply(VType);
                }
            });
        }

        @Override
        public int removeAll(final VType VType) {
            return this.owner.removeAll(new ObjectObjectPredicate<KType, VType>(){

                @Override
                public boolean apply(KType KType, VType VType2) {
                    return Objects.equals(VType2, VType);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object[] objectArray = ObjectObjectHashMap.this.keys;
                    n = this.slot;
                    if (objectArray[n] != null) {
                        this.cursor.index = n;
                        this.cursor.value = ObjectObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

