/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectShortAssociativeContainer;
import com.carrotsearch.hppc.ObjectShortMap;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectShortCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.predicates.ObjectShortPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.procedures.ObjectShortProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectShortHashMap<KType>
implements ObjectShortMap<KType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public Object[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public short[] values;

    public ObjectShortHashMap() {
        this(4);
    }

    public ObjectShortHashMap(int n) {
        this(n, 0.75);
    }

    public ObjectShortHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ObjectShortHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ObjectShortHashMap(ObjectShortAssociativeContainer<? extends KType> objectShortAssociativeContainer) {
        this(objectShortAssociativeContainer.size());
        this.putAll(objectShortAssociativeContainer);
    }

    public static <KType> ObjectShortHashMap<KType> from(KType[] KTypeArray, short[] sArray) {
        if (KTypeArray.length == sArray.length) {
            ObjectShortHashMap<KType> objectShortHashMap = new ObjectShortHashMap<KType>(KTypeArray.length);
            for (int i = 0; i < KTypeArray.length; ++i) {
                objectShortHashMap.put(KTypeArray[i], sArray[i]);
            }
            return objectShortHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public short addTo(KType KType, short s) {
        return this.putOrAdd(KType, s, s);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        Object[] objectArray = this.keys;
        short[] sArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new Object[n3];
            this.values = new short[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = objectArray;
            this.values = sArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, KType KType, short s) {
        Object[] objectArray = this.keys;
        short[] sArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        objectArray[n] = KType;
        sArray[n] = s;
        this.rehash(objectArray, sArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    public ObjectShortHashMap<KType> clone() {
        try {
            ObjectShortHashMap objectShortHashMap = (ObjectShortHashMap)super.clone();
            objectShortHashMap.keys = (Object[])this.keys.clone();
            objectShortHashMap.values = (short[])this.values.clone();
            objectShortHashMap.hasEmptyKey = objectShortHashMap.hasEmptyKey;
            objectShortHashMap.orderMixer = this.orderMixer.clone();
            return objectShortHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(KType KType) {
        Object object;
        if (KType == null) {
            return this.hasEmptyKey;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            Object[] objectArray = this.keys;
            short[] sArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (objectArray != null && !this.isEmpty()) {
                this.rehash(objectArray, sArray);
            }
        }
    }

    protected boolean equalElements(ObjectShortHashMap<?> object) {
        if (((ObjectShortHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<ObjectShortCursor<?>> iterator = ((ObjectShortHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Object KType = ((ObjectShortCursor)object).key;
            if (this.containsKey(KType) && this.get(KType) == ((ObjectShortCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ObjectShortHashMap)this.getClass().cast(object));
        return bl;
    }

    protected boolean equals(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    @Override
    public <T extends ObjectShortPredicate<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        short[] sArray = this.values;
        if (this.hasEmptyKey && !t.apply(null, sArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (objectArray[i] == null || t.apply((Object)objectArray[i], sArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ObjectShortProcedure<? super KType>> T forEach(T t) {
        Object[] objectArray = this.keys;
        short[] sArray = this.values;
        if (this.hasEmptyKey) {
            t.apply(null, sArray[this.mask + 1]);
        }
        int n = this.mask;
        for (int i = 0; i <= n; ++i) {
            if (objectArray[i] == null) continue;
            t.apply((Object)objectArray[i], sArray[i]);
        }
        return t;
    }

    @Override
    public short get(KType KType) {
        Object object;
        int n = 0;
        if (KType == null) {
            int n2 = n;
            if (this.hasEmptyKey) {
                n2 = n = this.values[this.mask + 1];
            }
            return (short)n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        n = this.hashKey(KType);
        while ((object = objectArray[n &= n3]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n];
            }
            ++n;
        }
        return 0;
    }

    @Override
    public short getOrDefault(KType KType, short s) {
        Object object;
        if (KType == null) {
            if (this.hasEmptyKey) {
                short s2;
                s = s2 = this.values[this.mask + 1];
            }
            return s;
        }
        Object[] objectArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(KType);
        while ((object = objectArray[n2 &= n]) != null) {
            if (this.equals(object, KType)) {
                return this.values[n2];
            }
            ++n2;
        }
        return s;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectShortCursor<KType> objectShortCursor : this) {
            n += BitMixer.mix(objectShortCursor.key) + BitMixer.mix(objectShortCursor.value);
        }
        return n;
    }

    protected int hashKey(KType KType) {
        return BitMixer.mix(KType, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public short indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, KType KType, short s) {
        if (KType == null) {
            this.values[n] = s;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, KType, s);
            } else {
                this.keys[n] = KType;
                this.values[n] = s;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(KType KType) {
        Object object;
        int n = this.mask;
        if (KType == null) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(KType);
        while ((object = objectArray[n3 &= n]) != null) {
            if (this.equals(object, KType)) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public short indexReplace(int n, short s) {
        short[] sArray = this.values;
        short s2 = sArray[n];
        sArray[n] = s;
        return s2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectShortCursor<KType>> iterator() {
        return new EntryIterator();
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public short put(KType object, short s) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = true;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = s;
            return (short)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                object = this.values;
                KType KType = object[n3];
                object[n3] = s;
                return (short)KType;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, object, s);
        } else {
            objectArray[n3] = object;
            this.values[n3] = s;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(ObjectShortAssociativeContainer<? extends KType> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ObjectShortCursor objectShortCursor = (ObjectShortCursor)object.next();
            this.put(objectShortCursor.key, objectShortCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ObjectShortCursor<? extends KType>> object) {
        int n = this.size();
        Iterator<ObjectShortCursor<KType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ObjectShortCursor)object).key, ((ObjectShortCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(KType KType, short s) {
        int n = this.indexOf(KType);
        if (!this.indexExists(n)) {
            this.indexInsert(n, KType, s);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(KType KType, short s, short s2) {
        int n = this.indexOf(KType);
        if (this.indexExists(n)) {
            s = (short)(this.values[n] + s2);
            this.indexReplace(n, s);
        } else {
            this.indexInsert(n, KType, s);
        }
        return s;
    }

    protected void rehash(KType[] KTypeArray, short[] sArray) {
        int n;
        Object[] objectArray = this.keys;
        short[] sArray2 = this.values;
        int n2 = this.mask;
        int n3 = KTypeArray.length - 1;
        objectArray[objectArray.length - 1] = KTypeArray[n3];
        sArray2[sArray2.length - 1] = sArray[n3];
        while ((n = n3 - 1) >= 0) {
            KType KType = KTypeArray[n];
            n3 = n;
            if (KType == null) continue;
            n3 = this.hashKey(KType);
            while (objectArray[n3 &= n2] != null) {
                ++n3;
            }
            objectArray[n3] = KType;
            sArray2[n3] = sArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public short remove(KType object) {
        Object object2;
        int n = this.mask;
        if (object == null) {
            this.hasEmptyKey = false;
            object = this.values;
            int n2 = n + 1;
            KType KType = object[n2];
            object[n2] = (short)0;
            return (short)KType;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(object);
        while ((object2 = objectArray[n3 &= n]) != null) {
            if (this.equals(object2, object)) {
                short s = this.values[n3];
                this.shiftConflictingKeys(n3);
                return s;
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ObjectLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (short)0;
            }
            Object[] objectArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                Object object2 = objectArray[n2];
                if (object2 != null && object.contains(object2)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ObjectCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && objectPredicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (short)0;
        }
        Object[] objectArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            Object object = objectArray[n2];
            if (object != null && objectPredicate.apply(object)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ObjectShortPredicate<? super KType> objectShortPredicate) {
        int n;
        short[] sArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && objectShortPredicate.apply(null, (sArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (short)0;
        }
        Object[] objectArray = this.keys;
        sArray = this.values;
        while (n4 <= n3) {
            Object object = objectArray[n4];
            if (object != null && objectShortPredicate.apply(object, sArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        Object[] objectArray = this.keys;
        short[] sArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            Object object;
            int n4;
            int n5 = 0;
            do {
                if ((object = objectArray[n4 = n + (n3 = n5 + 1) & n2]) == null) {
                    objectArray[n] = null;
                    sArray[n] = (short)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(object) & n2) < n3);
            objectArray[n] = object;
            sArray[n] = sArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ObjectShortCursor<KType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ObjectShortCursor<KType> objectShortCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(objectShortCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(objectShortCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ShortCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectShortCursor<KType>> {
        private final ObjectShortCursor<KType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectShortCursor();
        }

        @Override
        protected ObjectShortCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectShortHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.key = object;
                        this.cursor.value = ObjectShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectShortCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectShortHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(KType KType) {
            return this.owner.containsKey(KType);
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectShortPredicate<KType>(){

                @Override
                public boolean apply(KType KType, short s) {
                    return t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T t) {
            this.owner.forEach(new ObjectShortProcedure<KType>(){

                @Override
                public void apply(KType KType, short s) {
                    t.apply(KType);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> objectPredicate) {
            return this.owner.removeAll(objectPredicate);
        }

        @Override
        public int removeAll(KType KType) {
            if (this.owner.containsKey(KType)) {
                this.owner.remove(KType);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object object = ObjectShortHashMap.this.keys;
                    n = this.slot;
                    if ((object = object[n]) != null) {
                        this.cursor.index = n;
                        this.cursor.value = object;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final ObjectShortHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = ObjectShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != s) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ShortPredicate shortPredicate) {
            return this.owner.removeAll(new ObjectShortPredicate<KType>(){

                @Override
                public boolean apply(KType KType, short s) {
                    return shortPredicate.apply(s);
                }
            });
        }

        @Override
        public int removeAll(final short s) {
            return this.owner.removeAll(new ObjectShortPredicate<KType>(){

                @Override
                public boolean apply(KType KType, short s2) {
                    boolean bl = s2 == s;
                    return bl;
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    Object[] objectArray = ObjectShortHashMap.this.keys;
                    n = this.slot;
                    if (objectArray[n] != null) {
                        this.cursor.index = n;
                        this.cursor.value = ObjectShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ObjectShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

