/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortArrayList;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortDeque;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortArrayDeque
extends AbstractShortCollection
implements ShortDeque,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public short[] buffer = ShortArrayList.EMPTY_ARRAY;
    public int head;
    protected final ArraySizingStrategy resizer;
    public int tail;

    public ShortArrayDeque() {
        this(4);
    }

    public ShortArrayDeque(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public ShortArrayDeque(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public ShortArrayDeque(ShortContainer shortContainer) {
        this(shortContainer.size());
        this.addLast(shortContainer);
    }

    private void descendingForEach(ShortPredicate shortPredicate, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        short[] sArray = this.buffer;
        while (shortPredicate.apply(sArray[n3 = ShortArrayDeque.oneLeft(n2, sArray.length)])) {
            n2 = n3;
            if (n3 != n) continue;
        }
    }

    private void descendingForEach(ShortProcedure shortProcedure, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        short[] sArray = this.buffer;
        do {
            n3 = ShortArrayDeque.oneLeft(n2, sArray.length);
            shortProcedure.apply(sArray[n3]);
            n2 = n3;
        } while (n3 != n);
    }

    private void forEach(ShortProcedure shortProcedure, int n, int n2) {
        short[] sArray = this.buffer;
        while (n != n2) {
            shortProcedure.apply(sArray[n]);
            n = ShortArrayDeque.oneRight(n, sArray.length);
        }
    }

    public static ShortArrayDeque from(short ... sArray) {
        ShortArrayDeque shortArrayDeque = new ShortArrayDeque(sArray.length);
        shortArrayDeque.addLast(sArray);
        return shortArrayDeque;
    }

    protected static int oneLeft(int n, int n2) {
        if (n >= 1) {
            return n - 1;
        }
        return n2 - 1;
    }

    protected static int oneRight(int n, int n2) {
        int n3;
        n = n3 = n + 1;
        if (n3 == n2) {
            n = 0;
        }
        return n;
    }

    public int addFirst(ShortContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addFirst(((ShortCursor)object.next()).value);
        }
        return n;
    }

    public int addFirst(Iterable<? extends ShortCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addFirst(((ShortCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addFirst(short s) {
        int n;
        int n2 = n = ShortArrayDeque.oneLeft(this.head, this.buffer.length);
        if (n == this.tail) {
            this.ensureBufferSpace(1);
            n2 = ShortArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        short[] sArray = this.buffer;
        this.head = n2;
        sArray[n2] = s;
    }

    public final void addFirst(short ... sArray) {
        this.ensureBufferSpace(sArray.length);
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            this.addFirst(sArray[i]);
        }
    }

    public int addLast(ShortContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addLast(((ShortCursor)object.next()).value);
        }
        return n;
    }

    public int addLast(Iterable<? extends ShortCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addLast(((ShortCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addLast(short s) {
        int n;
        int n2 = n = ShortArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == n) {
            this.ensureBufferSpace(1);
            n2 = ShortArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = s;
        this.tail = n2;
    }

    public final void addLast(short ... sArray) {
        this.ensureBufferSpace(1);
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            this.addLast(sArray[i]);
        }
    }

    public int bufferIndexOf(short s) {
        int n = this.tail;
        int n2 = this.buffer.length;
        int n3 = this.head;
        while (n3 != n) {
            if (this.buffer[n3] == s) {
                return n3;
            }
            n3 = ShortArrayDeque.oneRight(n3, n2);
        }
        return -1;
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            Arrays.fill(this.buffer, n, n2, (short)0);
        } else {
            Arrays.fill(this.buffer, 0, n2, (short)0);
            short[] sArray = this.buffer;
            Arrays.fill(sArray, this.head, sArray.length, (short)0);
        }
        this.tail = 0;
        this.head = 0;
    }

    public ShortArrayDeque clone() {
        try {
            ShortArrayDeque shortArrayDeque = (ShortArrayDeque)super.clone();
            shortArrayDeque.buffer = (short[])this.buffer.clone();
            return shortArrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(short s) {
        int n = this.head;
        int n2 = this.tail;
        short[] sArray = this.buffer;
        while (n != n2) {
            if (sArray[n] == s) {
                return true;
            }
            n = ShortArrayDeque.oneRight(n, sArray.length);
        }
        return false;
    }

    @Override
    public <T extends ShortPredicate> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public <T extends ShortProcedure> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public Iterator<ShortCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureBufferSpace(int n) {
        int n2 = this.buffer.length;
        int n3 = this.size();
        if (n3 + n < n2) return;
        n = this.resizer.grow(n2, n3 + 1, n);
        try {
            short[] sArray = new short[n];
            if (n2 > 0) {
                this.toArray(sArray);
                this.tail = n3;
                this.head = 0;
            }
            this.buffer = sArray;
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensureBufferSpace(n - this.size());
    }

    protected boolean equalElements(ShortArrayDeque object) {
        int n = this.size();
        int n2 = ((ShortArrayDeque)object).size();
        boolean bl = false;
        if (n2 != n) {
            return false;
        }
        Iterator<ShortCursor> iterator = this.iterator();
        object = ((ShortArrayDeque)object).iterator();
        while (iterator.hasNext() && object.hasNext()) {
            if (((ShortCursor)object.next()).value == iterator.next().value) continue;
            return false;
        }
        boolean bl2 = bl;
        if (!iterator.hasNext()) {
            bl2 = bl;
            if (!object.hasNext()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortArrayDeque)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortPredicate> T forEach(T t) {
        int n = this.head;
        int n2 = this.tail;
        short[] sArray = this.buffer;
        while (n != n2 && t.apply(sArray[n])) {
            n = ShortArrayDeque.oneRight(n, sArray.length);
        }
        return t;
    }

    @Override
    public <T extends ShortProcedure> T forEach(T t) {
        this.forEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public short getFirst() {
        return this.buffer[this.head];
    }

    @Override
    public short getLast() {
        short[] sArray = this.buffer;
        return sArray[ShortArrayDeque.oneLeft(this.tail, sArray.length)];
    }

    public int hashCode() {
        int n = this.head;
        int n2 = this.tail;
        short[] sArray = this.buffer;
        int n3 = 1;
        while (n != n2) {
            n3 = n3 * 31 + BitMixer.mix(this.buffer[n]);
            n = ShortArrayDeque.oneRight(n, sArray.length);
        }
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortCursor> iterator() {
        return new ValueIterator();
    }

    public int lastBufferIndexOf(short s) {
        int n;
        int n2 = this.buffer.length;
        int n3 = ShortArrayDeque.oneLeft(this.head, n2);
        int n4 = this.tail;
        while ((n = ShortArrayDeque.oneLeft(n4, n2)) != n3) {
            n4 = n;
            if (this.buffer[n] != s) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = ShortArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    /*
     * Loose catch block
     */
    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        short[] sArray;
        block10: {
            int n6;
            sArray = this.buffer;
            n5 = this.tail;
            n4 = sArray.length;
            int n7 = n6 = this.head;
            n3 = 0;
            while (true) {
                n2 = n6;
                n = n7;
                if (n6 == n5) break block10;
                n2 = n7;
                if (!shortPredicate.apply(sArray[n6])) break block11;
                break;
            }
            catch (Throwable throwable) {
                while (n6 != n5) {
                    if (n2 != n6) {
                        sArray[n2] = sArray[n6];
                        sArray[n6] = (short)0;
                    }
                    n2 = ShortArrayDeque.oneRight(n2, n4);
                    n6 = ShortArrayDeque.oneRight(n6, n4);
                }
                this.tail = n2;
                throw throwable;
            }
            {
                block12: {
                    block11: {
                        sArray[n6] = (short)0;
                        ++n3;
                        break block12;
                    }
                    if (n7 != n6) {
                        sArray[n7] = sArray[n6];
                        sArray[n6] = (short)0;
                    }
                    n2 = n7;
                    n7 = ShortArrayDeque.oneRight(n7, n4);
                }
                n2 = n7;
                n6 = n = ShortArrayDeque.oneRight(n6, n4);
                continue;
            }
        }
        while (n2 != n5) {
            if (n != n2) {
                sArray[n] = sArray[n2];
                sArray[n2] = (short)0;
            }
            n = ShortArrayDeque.oneRight(n, n4);
            n2 = ShortArrayDeque.oneRight(n2, n4);
        }
        this.tail = n;
        return n3;
    }

    @Override
    public int removeAll(short s) {
        int n;
        int n2 = this.tail;
        int n3 = this.buffer.length;
        int n4 = n = this.head;
        int n5 = 0;
        while (n != n2) {
            short[] sArray = this.buffer;
            if (sArray[n] == s) {
                sArray[n] = (short)0;
                ++n5;
            } else {
                if (n4 != n) {
                    sArray[n4] = sArray[n];
                    sArray[n] = (short)0;
                }
                n4 = ShortArrayDeque.oneRight(n4, n3);
            }
            n = ShortArrayDeque.oneRight(n, n3);
        }
        this.tail = n4;
        return n5;
    }

    public void removeAtBufferIndex(int n) {
        int n2;
        short[] sArray = this.buffer;
        int n3 = sArray.length;
        int n4 = n3 - 1;
        int n5 = this.head;
        int n6 = this.tail;
        int n7 = Math.abs(n - n5) % n3;
        if (n7 < (n2 = Math.abs(n6 - n) % n3)) {
            if (n >= n5) {
                System.arraycopy(sArray, n5, sArray, n5 + 1, n7);
            } else {
                System.arraycopy(sArray, 0, sArray, 1, n);
                sArray[0] = sArray[n4];
                System.arraycopy(sArray, n5, sArray, n5 + 1, n4 - n5);
            }
            sArray[n5] = (short)0;
            this.head = ShortArrayDeque.oneRight(n5, n3);
        } else {
            if (n < n6) {
                System.arraycopy(sArray, n + 1, sArray, n, n2);
            } else {
                System.arraycopy(sArray, n + 1, sArray, n, n4 - n);
                sArray[n4] = sArray[0];
                System.arraycopy(sArray, 1, sArray, 0, n6);
            }
            sArray[n6] = (short)0;
            this.tail = ShortArrayDeque.oneLeft(n6, n3);
        }
    }

    @Override
    public int removeFirst(short s) {
        int n = this.bufferIndexOf(s);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public short removeFirst() {
        short[] sArray = this.buffer;
        int n = this.head;
        short s = sArray[n];
        sArray[n] = (short)0;
        this.head = ShortArrayDeque.oneRight(n, sArray.length);
        return s;
    }

    @Override
    public int removeLast(short s) {
        int n = this.lastBufferIndexOf(s);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public short removeLast() {
        int n;
        this.tail = n = ShortArrayDeque.oneLeft(this.tail, this.buffer.length);
        short[] sArray = this.buffer;
        short s = sArray[n];
        sArray[n] = (short)0;
        return s;
    }

    @Override
    public int size() {
        int n = this.head;
        int n2 = this.tail;
        if (n <= n2) {
            return n2 - n;
        }
        return n2 - n + this.buffer.length;
    }

    @Override
    public short[] toArray() {
        return this.toArray(new short[this.size()]);
    }

    public short[] toArray(short[] sArray) {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            System.arraycopy(this.buffer, n, sArray, 0, this.size());
        } else if (n > n2) {
            short[] sArray2 = this.buffer;
            n2 = sArray2.length - n;
            System.arraycopy(sArray2, n, sArray, 0, n2);
            System.arraycopy(this.buffer, 0, sArray, n2, this.tail);
        }
        return sArray;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private int remaining;

        public DescendingValueIterator() {
            ShortCursor shortCursor;
            this.cursor = shortCursor = new ShortCursor();
            shortCursor.index = ShortArrayDeque.this.tail;
            this.remaining = ShortArrayDeque.this.size();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (ShortCursor)this.done();
            }
            this.remaining = n - 1;
            ShortCursor shortCursor = this.cursor;
            short[] sArray = ShortArrayDeque.this.buffer;
            ShortCursor shortCursor2 = this.cursor;
            shortCursor2.index = n = ShortArrayDeque.oneLeft(shortCursor2.index, ShortArrayDeque.this.buffer.length);
            shortCursor.value = sArray[n];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private int remaining;

        public ValueIterator() {
            ShortCursor shortCursor;
            this.cursor = shortCursor = new ShortCursor();
            shortCursor.index = ShortArrayDeque.oneLeft(ShortArrayDeque.this.head, ShortArrayDeque.this.buffer.length);
            this.remaining = ShortArrayDeque.this.size();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (ShortCursor)this.done();
            }
            this.remaining = n - 1;
            ShortCursor shortCursor = this.cursor;
            short[] sArray = ShortArrayDeque.this.buffer;
            ShortCursor shortCursor2 = this.cursor;
            shortCursor2.index = n = ShortArrayDeque.oneRight(shortCursor2.index, ShortArrayDeque.this.buffer.length);
            shortCursor.value = sArray[n];
            return this.cursor;
        }
    }
}

