/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortIndexedContainer;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortArrayList
extends AbstractShortCollection
implements ShortIndexedContainer,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final short[] EMPTY_ARRAY = new short[0];
    public short[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public ShortArrayList() {
        this(4);
    }

    public ShortArrayList(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public ShortArrayList(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public ShortArrayList(ShortContainer shortContainer) {
        this(shortContainer.size());
        this.addAll(shortContainer);
    }

    public static ShortArrayList from(short ... sArray) {
        ShortArrayList shortArrayList = new ShortArrayList(sArray.length);
        shortArrayList.add(sArray);
        return shortArrayList;
    }

    @Override
    public void add(short s) {
        this.ensureBufferSpace(1);
        short[] sArray = this.buffer;
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        sArray[n] = s;
    }

    public void add(short s, short s2) {
        int n;
        this.ensureBufferSpace(2);
        short[] sArray = this.buffer;
        int n2 = this.elementsCount;
        this.elementsCount = n = n2 + 1;
        sArray[n2] = s;
        this.elementsCount = n + 1;
        sArray[n] = s2;
    }

    public final void add(short ... sArray) {
        this.add(sArray, 0, sArray.length);
    }

    public void add(short[] sArray, int n, int n2) {
        this.ensureBufferSpace(n2);
        System.arraycopy(sArray, n, this.buffer, this.elementsCount, n2);
        this.elementsCount += n2;
    }

    public int addAll(ShortContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.add(((ShortCursor)object.next()).value);
        }
        return n;
    }

    public int addAll(Iterable<? extends ShortCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.add(((ShortCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, (short)0);
        this.elementsCount = 0;
    }

    public ShortArrayList clone() {
        try {
            ShortArrayList shortArrayList = (ShortArrayList)super.clone();
            shortArrayList.buffer = (short[])this.buffer.clone();
            return shortArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(short s) {
        boolean bl = this.indexOf(s) >= 0;
        return bl;
    }

    protected void ensureBufferSpace(int n) {
        int n2 = this.elementsCount;
        short[] sArray = this.buffer;
        int n3 = sArray == null ? 0 : sArray.length;
        if (n2 + n > n3) {
            n = this.resizer.grow(n3, n2, n);
            this.buffer = Arrays.copyOf(this.buffer, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        short[] sArray = this.buffer;
        int n2 = sArray == null ? 0 : sArray.length;
        if (n > n2) {
            this.ensureBufferSpace(n - this.size());
        }
    }

    protected boolean equalElements(ShortArrayList shortArrayList) {
        int n = this.size();
        if (shortArrayList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (shortArrayList.get(i) == this.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortArrayList)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortPredicate> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends ShortPredicate> T forEach(T t, int n, int n2) {
        short[] sArray = this.buffer;
        while (n < n2 && t.apply(sArray[n])) {
            ++n;
        }
        return t;
    }

    @Override
    public <T extends ShortProcedure> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends ShortProcedure> T forEach(T t, int n, int n2) {
        short[] sArray = this.buffer;
        while (n < n2) {
            t.apply(sArray[n]);
            ++n;
        }
        return t;
    }

    @Override
    public short get(int n) {
        return this.buffer[n];
    }

    public int hashCode() {
        int n = this.elementsCount;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + BitMixer.mix(this.buffer[i]);
        }
        return n2;
    }

    @Override
    public int indexOf(short s) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (this.buffer[i] != s) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insert(int n, short s) {
        this.ensureBufferSpace(1);
        short[] sArray = this.buffer;
        System.arraycopy(sArray, n, sArray, n + 1, this.elementsCount - n);
        this.buffer[n] = s;
        ++this.elementsCount;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.elementsCount == 0;
        return bl;
    }

    @Override
    public Iterator<ShortCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public int lastIndexOf(short s) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (this.buffer[i] != s) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public short remove(int n) {
        short[] sArray = this.buffer;
        short s = sArray[n];
        int n2 = n + 1;
        int n3 = this.elementsCount;
        if (n2 < n3) {
            System.arraycopy(sArray, n2, sArray, n, n3 - n - 1);
        }
        this.elementsCount = n = this.elementsCount - 1;
        this.buffer[n] = (short)0;
        return s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n;
        int n2;
        short[] sArray = this.buffer;
        int n3 = this.elementsCount;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            block9: {
                n2 = ++n4;
                n = ++n5;
                if (n4 >= n3) break;
                try {
                    if (!shortPredicate.apply(sArray[n4])) break block9;
                }
                catch (Throwable throwable) {
                    while (true) {
                        if (n4 >= n3) {
                            this.elementsCount = n5;
                            throw throwable;
                        }
                        if (n5 != n4) {
                            sArray[n5] = sArray[n4];
                            sArray[n4] = (short)0;
                        }
                        ++n5;
                        ++n4;
                    }
                }
                sArray[n4] = (short)0;
                continue;
            }
            if (n5 == n4) continue;
            sArray[n5] = sArray[n4];
            sArray[n4] = (short)0;
        }
        while (true) {
            if (n2 >= n3) {
                this.elementsCount = n;
                return n3 - n;
            }
            if (n != n2) {
                sArray[n] = sArray[n2];
                sArray[n2] = (short)0;
            }
            ++n;
            ++n2;
        }
    }

    @Override
    public int removeAll(short s) {
        int n;
        int n2 = 0;
        for (int i = 0; i < (n = this.elementsCount); ++i) {
            short[] sArray = this.buffer;
            if (sArray[i] == s) {
                sArray[i] = (short)0;
                continue;
            }
            if (n2 != i) {
                sArray[n2] = sArray[i];
                sArray[i] = (short)0;
            }
            ++n2;
        }
        this.elementsCount = n2;
        return n - n2;
    }

    @Override
    public int removeFirst(short s) {
        int n = this.indexOf(s);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public int removeLast(short s) {
        int n = this.lastIndexOf(s);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public void removeRange(int n, int n2) {
        short[] sArray = this.buffer;
        System.arraycopy(sArray, n2, sArray, n, this.elementsCount - n2);
        n = n2 - n;
        this.elementsCount = n2 = this.elementsCount - n;
        Arrays.fill(this.buffer, n2, n + n2, (short)0);
    }

    public void resize(int n) {
        short[] sArray = this.buffer;
        if (n <= sArray.length) {
            int n2 = this.elementsCount;
            if (n < n2) {
                Arrays.fill(sArray, n, n2, (short)0);
            } else {
                Arrays.fill(sArray, n2, n, (short)0);
            }
        } else {
            this.ensureCapacity(n);
        }
        this.elementsCount = n;
    }

    @Override
    public short set(int n, short s) {
        short[] sArray = this.buffer;
        short s2 = sArray[n];
        sArray[n] = s;
        return s2;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public short[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    static final class ValueIterator
    extends AbstractIterator<ShortCursor> {
        private final short[] buffer;
        private final ShortCursor cursor;
        private final int size;

        public ValueIterator(short[] sArray, int n) {
            ShortCursor shortCursor;
            this.cursor = shortCursor = new ShortCursor();
            shortCursor.index = -1;
            this.size = n;
            this.buffer = sArray;
        }

        @Override
        protected ShortCursor fetch() {
            int n;
            if (this.cursor.index + 1 == this.size) {
                return (ShortCursor)this.done();
            }
            ShortCursor shortCursor = this.cursor;
            short[] sArray = this.buffer;
            shortCursor.index = n = shortCursor.index + 1;
            shortCursor.value = sArray[n];
            return this.cursor;
        }
    }
}

