/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortByteAssociativeContainer;
import com.carrotsearch.hppc.ShortByteMap;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.ShortByteCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.ShortBytePredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.ShortByteProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortByteHashMap
implements ShortByteMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public short[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public byte[] values;

    public ShortByteHashMap() {
        this(4);
    }

    public ShortByteHashMap(int n) {
        this(n, 0.75);
    }

    public ShortByteHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ShortByteHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ShortByteHashMap(ShortByteAssociativeContainer shortByteAssociativeContainer) {
        this(shortByteAssociativeContainer.size());
        this.putAll(shortByteAssociativeContainer);
    }

    public static ShortByteHashMap from(short[] sArray, byte[] byArray) {
        if (sArray.length == byArray.length) {
            ShortByteHashMap shortByteHashMap = new ShortByteHashMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortByteHashMap.put(sArray[i], byArray[i]);
            }
            return shortByteHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public byte addTo(short s, byte by) {
        return this.putOrAdd(s, by, by);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        short[] sArray = this.keys;
        byte[] byArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new short[n3];
            this.values = new byte[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = sArray;
            this.values = byArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, short s, byte by) {
        short[] sArray = this.keys;
        byte[] byArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        sArray[n] = s;
        byArray[n] = by;
        this.rehash(sArray, byArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    public ShortByteHashMap clone() {
        try {
            ShortByteHashMap shortByteHashMap = (ShortByteHashMap)super.clone();
            shortByteHashMap.keys = (short[])this.keys.clone();
            shortByteHashMap.values = (byte[])this.values.clone();
            shortByteHashMap.hasEmptyKey = shortByteHashMap.hasEmptyKey;
            shortByteHashMap.orderMixer = this.orderMixer.clone();
            return shortByteHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(short s) {
        int n;
        if (s == 0) {
            return this.hasEmptyKey;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(s);
        while ((n3 = sArray[n = n3 & n2]) != 0) {
            if (n3 == s) {
                return true;
            }
            n3 = n + 1;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            short[] sArray = this.keys;
            byte[] byArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (sArray != null && !this.isEmpty()) {
                this.rehash(sArray, byArray);
            }
        }
    }

    protected boolean equalElements(ShortByteHashMap object) {
        if (((ShortByteHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((ShortByteHashMap)object).iterator();
        while (object.hasNext()) {
            ShortByteCursor shortByteCursor = (ShortByteCursor)object.next();
            short s = shortByteCursor.key;
            if (this.containsKey(s) && this.get(s) == shortByteCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortByteHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortBytePredicate> T forEach(T t) {
        short[] sArray = this.keys;
        byte[] byArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply((short)0, byArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (sArray[i] == 0 || t.apply(sArray[i], byArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ShortByteProcedure> T forEach(T t) {
        short[] sArray = this.keys;
        byte[] byArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply((short)0, byArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (sArray[n] != 0) {
                t.apply(sArray[n], byArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public byte get(short s) {
        short s2;
        int n = 0;
        if (s == 0) {
            int n2 = n;
            if (this.hasEmptyKey) {
                n2 = n = this.values[this.mask + 1];
            }
            return (byte)n2;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        n = this.hashKey(s);
        while ((s2 = sArray[n &= n3]) != 0) {
            if (s2 == s) {
                return this.values[n];
            }
            ++n;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(short s, byte by) {
        short s2;
        if (s == 0) {
            if (this.hasEmptyKey) {
                byte by2;
                by = by2 = this.values[this.mask + 1];
            }
            return by;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return this.values[n2];
            }
            ++n2;
        }
        return by;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ShortByteCursor shortByteCursor : this) {
            n += BitMixer.mix(shortByteCursor.key) + BitMixer.mix(shortByteCursor.value);
        }
        return n;
    }

    protected int hashKey(short s) {
        return BitMixer.mix(s, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public byte indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, short s, byte by) {
        if (s == 0) {
            this.values[n] = by;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, s, by);
            } else {
                this.keys[n] = s;
                this.values[n] = by;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(short s) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        short[] sArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = sArray[n3 &= n]) != 0) {
            if (s2 == s) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public byte indexReplace(int n, byte by) {
        byte[] byArray = this.values;
        byte by2 = byArray[n];
        byArray[n] = by;
        return by2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public byte put(short s, byte by) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = true;
            byte[] byArray = this.values;
            int n3 = n2 + 1;
            byte by2 = byArray[n3];
            byArray[n3] = by;
            return by2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = objectArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                objectArray = this.values;
                byte by3 = objectArray[n];
                objectArray[n] = by;
                return by3;
            }
            n4 = n + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n, s, by);
        } else {
            objectArray[n] = s;
            this.values[n] = by;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(ShortByteAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortByteCursor shortByteCursor = (ShortByteCursor)object.next();
            this.put(shortByteCursor.key, shortByteCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ShortByteCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortByteCursor shortByteCursor = (ShortByteCursor)object.next();
            this.put(shortByteCursor.key, shortByteCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(short s, byte by) {
        int n = this.indexOf(s);
        if (!this.indexExists(n)) {
            this.indexInsert(n, s, by);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(short s, byte by, byte by2) {
        int n = this.indexOf(s);
        if (this.indexExists(n)) {
            by = (byte)(this.values[n] + by2);
            this.indexReplace(n, by);
        } else {
            this.indexInsert(n, s, by);
        }
        return by;
    }

    protected void rehash(short[] sArray, byte[] byArray) {
        int n;
        short[] sArray2 = this.keys;
        byte[] byArray2 = this.values;
        int n2 = this.mask;
        int n3 = sArray.length - 1;
        sArray2[sArray2.length - 1] = sArray[n3];
        byArray2[byArray2.length - 1] = byArray[n3];
        while ((n = n3 - 1) >= 0) {
            short s = sArray[n];
            n3 = n;
            if (s == 0) continue;
            n3 = this.hashKey(s);
            while (sArray2[n3 &= n2] != 0) {
                ++n3;
            }
            sArray2[n3] = s;
            byArray2[n3] = byArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public byte remove(short s) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            this.hasEmptyKey = false;
            byte[] byArray = this.values;
            int n2 = n + 1;
            byte by = byArray[n2];
            byArray[n2] = (byte)0;
            return by;
        }
        short[] sArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = sArray[n3 &= n]) != 0) {
            if (s2 == s) {
                byte by = this.values[n3];
                this.shiftConflictingKeys(n3);
                return by;
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int removeAll(ShortContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ShortLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (byte)0;
            }
            short[] sArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                short s = sArray[n2];
                if (s != 0 && object.contains(s)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ShortCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ShortBytePredicate shortBytePredicate) {
        int n;
        byte[] byArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && shortBytePredicate.apply((short)0, (byArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (byte)0;
        }
        short[] sArray = this.keys;
        byArray = this.values;
        while (n4 <= n3) {
            short s = sArray[n4];
            if (s != 0 && shortBytePredicate.apply(s, byArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && shortPredicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (byte)0;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray[n2];
            if (s != 0 && shortPredicate.apply(s)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        short[] sArray = this.keys;
        byte[] byArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            short s;
            int n4;
            int n5 = 0;
            do {
                if ((s = sArray[n4 = n + (n3 = n5 + 1) & n2]) == 0) {
                    sArray[n] = (short)0;
                    byArray[n] = (byte)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(s) & n2) < n3);
            sArray[n] = s;
            byArray[n] = byArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ShortByteCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ShortByteCursor shortByteCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(shortByteCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(shortByteCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortByteCursor> {
        private final ShortByteCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortByteCursor();
        }

        @Override
        protected ShortByteCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortByteHashMap.this.keys;
                    n = this.slot;
                    short s = sArray[n];
                    if (s != 0) {
                        this.cursor.index = n;
                        this.cursor.key = s;
                        this.cursor.value = ShortByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (short)0;
                this.cursor.value = ShortByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortByteCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortByteHashMap owner;

        public KeysContainer() {
            this.owner = ShortByteHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            return this.owner.containsKey(s);
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T t) {
            this.owner.forEach(new ShortBytePredicate(){

                @Override
                public boolean apply(short s, byte by) {
                    return t.apply(s);
                }
            });
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T t) {
            this.owner.forEach(new ShortByteProcedure(){

                @Override
                public void apply(short s, byte by) {
                    t.apply(s);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate shortPredicate) {
            return this.owner.removeAll(shortPredicate);
        }

        @Override
        public int removeAll(short s) {
            if (this.owner.containsKey(s)) {
                this.owner.remove(s);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortByteHashMap.this.keys;
                    int n2 = this.slot;
                    n = sArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.value = (short)n;
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && ShortByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (short)0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final ShortByteHashMap owner;

        private ValuesContainer() {
            this.owner = ShortByteHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(byte by) {
            Iterator<ShortByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != by) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends BytePredicate> T forEach(T t) {
            Iterator<ShortByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T t) {
            Iterator<ShortByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final byte by) {
            return this.owner.removeAll(new ShortBytePredicate(){

                @Override
                public boolean apply(short s, byte by2) {
                    boolean bl = by2 == by;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final BytePredicate bytePredicate) {
            return this.owner.removeAll(new ShortBytePredicate(){

                @Override
                public boolean apply(short s, byte by) {
                    return bytePredicate.apply(by);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortByteHashMap.this.keys;
                    n = this.slot;
                    if (sArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = ShortByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }
}

