/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortByteHashMap;

public class ShortByteScatterMap
extends ShortByteHashMap {
    public ShortByteScatterMap() {
        this(4);
    }

    public ShortByteScatterMap(int n) {
        this(n, 0.75);
    }

    public ShortByteScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static ShortByteScatterMap from(short[] sArray, byte[] byArray) {
        if (sArray.length == byArray.length) {
            ShortByteScatterMap shortByteScatterMap = new ShortByteScatterMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortByteScatterMap.put(sArray[i], byArray[i]);
            }
            return shortByteScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(short s) {
        return BitMixer.mixPhi(s);
    }
}

